/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ConstantPool;

public class ElementValue {
    private byte tag;
    private int const_value_index;
    private int type_name_index;
    private int const_name_index;
    private int class_info_index;
    private AnnotationEntry annotation;
    private int num_values;
    private ElementValue[] values;

    ElementValue(DataInputStream file, ConstantPool constant_pool) throws IOException {
        this.tag = file.readByte();
        switch (this.tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                this.const_value_index = file.readUnsignedShort();
                break;
            }
            case 101: {
                this.type_name_index = file.readUnsignedShort();
                this.const_name_index = file.readUnsignedShort();
                break;
            }
            case 99: {
                this.class_info_index = file.readUnsignedShort();
                break;
            }
            case 64: {
                this.annotation = new AnnotationEntry(file, constant_pool);
                break;
            }
            case 91: {
                this.num_values = file.readUnsignedShort();
                this.values = new ElementValue[this.num_values];
                for (int i = 0; i < this.num_values; ++i) {
                    this.values[i] = new ElementValue(file, constant_pool);
                }
                break;
            }
            default: {
                throw new IOException("Invalid ElementValue tag: " + this.tag);
            }
        }
    }
}

