/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.nodes;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.text.MessageFormat;
import org.netbeans.api.db.explorer.DatabaseMetaDataTransfer;
import org.netbeans.lib.ddl.CommandNotSupportedException;
import org.netbeans.lib.ddl.impl.RenameView;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseMetaDataTransferAccessor;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.nodes.DatabaseNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;

public class ViewNode
extends DatabaseNode {
    public void setName(String string) {
        try {
            DatabaseNodeInfo databaseNodeInfo = this.getInfo();
            Specification specification = (Specification)databaseNodeInfo.getSpecification();
            RenameView renameView = specification.createCommandRenameView(databaseNodeInfo.getName(), string);
            renameView.setObjectOwner((String)databaseNodeInfo.get("schema"));
            renameView.execute();
            super.setName(string);
            databaseNodeInfo.put("table", string);
            databaseNodeInfo.put("view", string);
        }
        catch (CommandNotSupportedException commandNotSupportedException) {
            String string2 = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("EXC_UnableToChangeName"), commandNotSupportedException.getCommand());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getShortDescription() {
        return NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ND_View");
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCopy());
        ConnectionNodeInfo connectionNodeInfo = (ConnectionNodeInfo)this.getInfo().getParent("connection");
        final DatabaseConnection databaseConnection = ConnectionList.getDefault().getConnection(connectionNodeInfo.getDatabaseConnection());
        exTransferable.put(new ExTransferable.Single(DatabaseMetaDataTransfer.VIEW_FLAVOR){

            protected Object getData() {
                return DatabaseMetaDataTransferAccessor.DEFAULT.createViewData(databaseConnection.getDatabaseConnection(), databaseConnection.findJDBCDriver(), ViewNode.this.getInfo().getName());
            }
        });
        return exTransferable;
    }
}

