/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DatabaseProductNotFoundException;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.SpecificationFactory;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DerbyConectionEventListener;
import org.netbeans.modules.db.explorer.infos.ConnectionOperations;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class ConnectionNodeInfo
extends DatabaseNodeInfo
implements ConnectionOperations {
    static final long serialVersionUID = -8322295510950137669L;
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo;

    private void connect(String string) throws DatabaseException {
        String string2 = this.getDriver();
        String string3 = this.getDatabase();
        try {
            DatabaseConnection databaseConnection = new DatabaseConnection(string2, string3, this.getUser(), this.getPassword());
            Connection connection = databaseConnection.createJDBCConnection();
            this.finishConnect(string, databaseConnection, connection);
        }
        catch (Exception exception) {
            DatabaseException databaseException = new DatabaseException(exception.getMessage());
            databaseException.initCause(exception);
            throw databaseException;
        }
    }

    public void connect() throws DatabaseException {
        this.connect((String)null);
    }

    public void connect(DBConnection dBConnection) throws DatabaseException {
        try {
            DatabaseConnection databaseConnection = (DatabaseConnection)dBConnection;
            Connection connection = databaseConnection.getConnection();
            SpecificationFactory specificationFactory = (SpecificationFactory)this.getSpecificationFactory();
            this.setReadOnly(false);
            Specification specification = (Specification)specificationFactory.createSpecification(databaseConnection, connection);
            this.put("dbproduct", specification.getProperties().get("dbproduct"));
            this.setSpecification(specification);
            DriverSpecification driverSpecification = specificationFactory.createDriverSpecification(specification.getMetaData().getDriverName().trim());
            if (specification.getMetaData().getDriverName().trim().equals("jConnect (TM) for JDBC (TM)")) {
                driverSpecification.setMetaData(connection.getMetaData());
            } else {
                driverSpecification.setMetaData(specification.getMetaData());
            }
            driverSpecification.setCatalog(connection.getCatalog());
            driverSpecification.setSchema(this.getSchema());
            this.setDriverSpecification(driverSpecification);
            this.setConnection(connection);
        }
        catch (DatabaseProductNotFoundException databaseProductNotFoundException) {
            this.setReadOnly(false);
            this.connect("GenericDatabaseSystem");
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void finishConnect(String string, DatabaseConnection databaseConnection, Connection connection) throws DatabaseException {
        try {
            Specification specification;
            SpecificationFactory specificationFactory = (SpecificationFactory)this.getSpecificationFactory();
            if (string != null) {
                specification = (Specification)specificationFactory.createSpecification(databaseConnection, string, connection);
            } else {
                this.setReadOnly(false);
                specification = (Specification)specificationFactory.createSpecification(databaseConnection, connection);
            }
            this.put("dbproduct", specification.getProperties().get("dbproduct"));
            this.setSpecification(specification);
            DriverSpecification driverSpecification = specificationFactory.createDriverSpecification(specification.getMetaData().getDriverName().trim());
            if (specification.getMetaData().getDriverName().trim().equals("jConnect (TM) for JDBC (TM)")) {
                driverSpecification.setMetaData(connection.getMetaData());
            } else {
                driverSpecification.setMetaData(specification.getMetaData());
            }
            driverSpecification.setCatalog(connection.getCatalog());
            driverSpecification.setSchema(this.getSchema());
            this.setDriverSpecification(driverSpecification);
            this.setConnection(connection);
        }
        catch (DatabaseProductNotFoundException databaseProductNotFoundException) {
            this.setReadOnly(false);
            this.connect("GenericDatabaseSystem");
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void disconnect() throws DatabaseException {
        Connection connection = this.getConnection();
        if (connection != null) {
            String string = null;
            try {
                connection.close();
                this.setConnection(null);
            }
            catch (Exception exception) {
                this.setConnection(null);
                string = MessageFormat.format(ConnectionNodeInfo.bundle().getString("EXC_ConnectionError"), exception.getMessage());
            }
            DerbyConectionEventListener.getDefault().afterDisconnect(this.getDatabaseConnection(), connection);
            if (string != null) {
                throw new DatabaseException(string);
            }
        }
    }

    public void delete() throws IOException {
        try {
            DatabaseConnection databaseConnection = this.getDatabaseConnection();
            ConnectionList.getDefault().remove(databaseConnection);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public Object put(Object object, Object object2) {
        if (object.equals("user") || object.equals("driver") || object.equals("db") || object.equals("schema") || object.equals("rememberpwd")) {
            this.updateConnection((String)object, object2);
        }
        return super.put(object, object2);
    }

    private void updateConnection(String string, Object object) {
        DatabaseConnection databaseConnection = this.getDatabaseConnection();
        DatabaseConnection databaseConnection2 = ConnectionList.getDefault().getConnection(databaseConnection);
        if (databaseConnection2 != null) {
            if (string.equals("schema")) {
                databaseConnection2.setSchema((String)object);
            } else if (string.equals("user")) {
                databaseConnection2.setUser((String)object);
            } else if (string.equals("driver")) {
                databaseConnection2.setDriver((String)object);
            } else if (string.equals("db")) {
                databaseConnection2.setDatabase((String)object);
            } else if (string.equals("rememberpwd")) {
                databaseConnection2.setRememberPassword((Boolean)object);
            }
        }
        this.setName(databaseConnection.getName());
    }

    public void refreshChildren() throws DatabaseException {
        Children children = this.getNode().getChildren();
        Node[] nodeArray = children.getNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            DatabaseNodeInfo databaseNodeInfo = (DatabaseNodeInfo)nodeArray[i].getCookie(class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo == null ? ConnectionNodeInfo.class$("org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo") : class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo);
            databaseNodeInfo.refreshChildren();
        }
    }
}

