/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.standalone.actions;

import com.jaspersoft.ireport.designer.standalone.actions.ImportSettingsUtilities;
import com.jaspersoft.ireport.designer.standalone.actions.ImportSettingsWizardPanel1PlatformSelection;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class ImportSettingsVisualPanel1PlatformSelection
extends JPanel {
    ImportSettingsWizardPanel1PlatformSelection wizard = null;
    private boolean init = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonBrowse;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList jListPlatforms;
    private JRadioButton jRadioButtonUserDir;
    private JRadioButton jRadioButtonVersion;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldDirectory;

    public ImportSettingsVisualPanel1PlatformSelection(ImportSettingsWizardPanel1PlatformSelection wizard) {
        this.initComponents();
        this.wizard = wizard;
        this.jListPlatforms.setModel(new DefaultListModel());
        this.jTextFieldDirectory.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ImportSettingsVisualPanel1PlatformSelection.this.notifyChange();
            }

            public void removeUpdate(DocumentEvent e) {
                ImportSettingsVisualPanel1PlatformSelection.this.notifyChange();
            }

            public void changedUpdate(DocumentEvent e) {
                ImportSettingsVisualPanel1PlatformSelection.this.notifyChange();
            }
        });
    }

    public void notifyChange() {
        if (this.wizard != null) {
            this.wizard.fireChangeEvent();
        }
    }

    public String getName() {
        return NbBundle.getMessage(ImportSettingsVisualPanel1PlatformSelection.class, (String)"ImportSettingsVisualPanel1PlatformSelection.name");
    }

    public void validateForm() {
        if (this.jRadioButtonVersion.isSelected()) {
            if (this.jListPlatforms.getSelectedValue() == null) {
                throw new IllegalArgumentException(NbBundle.getMessage(ImportSettingsVisualPanel1PlatformSelection.class, (String)"ImportSettingsVisualPanel1PlatformSelection.error.selectValidPlatform"));
            }
        } else if (this.jRadioButtonUserDir.isSelected()) {
            String s = this.jTextFieldDirectory.getText();
            try {
                File f = new File(s);
                if (!ImportSettingsUtilities.isValidConfigurationDirectory(f)) {
                    throw new IllegalArgumentException(NbBundle.getMessage(ImportSettingsVisualPanel1PlatformSelection.class, (String)"ImportSettingsVisualPanel1PlatformSelection.error.invalidFile"));
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(NbBundle.getMessage(ImportSettingsVisualPanel1PlatformSelection.class, (String)"ImportSettingsVisualPanel1PlatformSelection.error.invalidFile"));
            }
        }
    }

    public void updateVersions() {
        String[] versions;
        ((DefaultListModel)this.jListPlatforms.getModel()).removeAllElements();
        for (String version : versions = ImportSettingsUtilities.getAvailableVersions()) {
            ((DefaultListModel)this.jListPlatforms.getModel()).addElement(version);
        }
        this.jListPlatforms.updateUI();
    }

    public void readSettings(Object settings) {
        String selectedOption;
        String selectedPath;
        this.updateVersions();
        String selectedVersion = (String)((WizardDescriptor)settings).getProperty("version");
        if (selectedVersion != null) {
            this.jListPlatforms.setSelectedValue(selectedVersion, true);
        }
        if ((selectedPath = (String)((WizardDescriptor)settings).getProperty("path")) != null) {
            this.jTextFieldDirectory.setText(selectedPath);
        }
        boolean b = (selectedOption = (String)((WizardDescriptor)settings).getProperty("selectedOption")) == null || selectedOption.equals("0");
        this.jRadioButtonVersion.setSelected(b);
        this.jRadioButtonUserDir.setSelected(!b);
    }

    public void storeSettings(Object settings) {
        if (this.jListPlatforms.getSelectedValue() != null) {
            ((WizardDescriptor)settings).putProperty("version", this.jListPlatforms.getSelectedValue());
        } else {
            ((WizardDescriptor)settings).putProperty("version", null);
        }
        ((WizardDescriptor)settings).putProperty("path", (Object)this.jTextFieldDirectory.getText());
        ((WizardDescriptor)settings).putProperty("selectedOption", (Object)(this.jRadioButtonVersion.isSelected() ? "0" : "1"));
    }

    private void updateControls() {
        this.jListPlatforms.setEnabled(this.jRadioButtonVersion.isSelected());
        this.jTextFieldDirectory.setEnabled(!this.jRadioButtonVersion.isSelected());
        this.jButtonBrowse.setEnabled(!this.jRadioButtonVersion.isSelected());
        this.notifyChange();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jListPlatforms = new JList();
        this.jTextFieldDirectory = new JTextField();
        this.jButtonBrowse = new JButton();
        this.jRadioButtonVersion = new JRadioButton();
        this.jRadioButtonUserDir = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jListPlatforms.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ImportSettingsVisualPanel1PlatformSelection.this.jListPlatformsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListPlatforms);
        this.jTextFieldDirectory.setText(NbBundle.getMessage(ImportSettingsVisualPanel1PlatformSelection.class, (String)"ImportSettingsVisualPanel1PlatformSelection.jTextFieldDirectory.text"));
        this.jTextFieldDirectory.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonBrowse, (String)NbBundle.getMessage(ImportSettingsVisualPanel1PlatformSelection.class, (String)"ImportSettingsVisualPanel1PlatformSelection.jButtonBrowse.text"));
        this.jButtonBrowse.setEnabled(false);
        this.jButtonBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportSettingsVisualPanel1PlatformSelection.this.jButtonBrowseActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonVersion);
        this.jRadioButtonVersion.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonVersion, (String)NbBundle.getMessage(ImportSettingsVisualPanel1PlatformSelection.class, (String)"ImportSettingsVisualPanel1PlatformSelection.jRadioButtonVersion.text"));
        this.jRadioButtonVersion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportSettingsVisualPanel1PlatformSelection.this.jRadioButtonVersionActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonUserDir);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonUserDir, (String)NbBundle.getMessage(ImportSettingsVisualPanel1PlatformSelection.class, (String)"ImportSettingsVisualPanel1PlatformSelection.jRadioButtonUserDir.text"));
        this.jRadioButtonUserDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportSettingsVisualPanel1PlatformSelection.this.jRadioButtonUserDirActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ImportSettingsVisualPanel1PlatformSelection.class, (String)"ImportSettingsVisualPanel1PlatformSelection.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ImportSettingsVisualPanel1PlatformSelection.class, (String)"ImportSettingsVisualPanel1PlatformSelection.jLabel2.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(21, 21, 21).add((Component)this.jTextFieldDirectory, -1, 299, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonBrowse)).add((Component)this.jRadioButtonUserDir).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(15, 15, 15).add((Component)this.jScrollPane1, -1, 378, Short.MAX_VALUE)).add((Component)this.jLabel1, -1, 393, Short.MAX_VALUE).add((Component)this.jLabel2, -1, 393, Short.MAX_VALUE).add((Component)this.jRadioButtonVersion)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1, -2, -1, -2).addPreferredGap(1).add((Component)this.jLabel2, -2, -1, -2).add(18, 18, 18).add((Component)this.jRadioButtonVersion).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 41, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.jRadioButtonUserDir).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldDirectory, -2, -1, -2).add((Component)this.jButtonBrowse)).addContainerGap()));
    }

    private void jListPlatformsValueChanged(ListSelectionEvent evt) {
        this.notifyChange();
    }

    private void jRadioButtonUserDirActionPerformed(ActionEvent evt) {
        this.updateControls();
    }

    private void jRadioButtonVersionActionPerformed(ActionEvent evt) {
        this.updateControls();
    }

    private void jButtonBrowseActionPerformed(ActionEvent evt) {
        File f;
        String fileName = null;
        if (this.jTextFieldDirectory.getText() != null && (f = new File(this.jTextFieldDirectory.getText())).exists() && f.isDirectory()) {
            fileName = f.getPath();
        }
        if (fileName == null) {
            fileName = System.getProperty("netbeans.home");
        }
        JFileChooser jfc = new JFileChooser(fileName);
        jfc.setDialogTitle(NbBundle.getMessage(ImportSettingsVisualPanel1PlatformSelection.class, (String)"ImportSettingsVisualPanel1PlatformSelection.JFileChooser.title"));
        jfc.setAcceptAllFileFilterUsed(true);
        jfc.setFileSelectionMode(1);
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this) == 0) {
            File file = jfc.getSelectedFile();
            this.jTextFieldDirectory.setText(file.getPath());
            this.notifyChange();
        }
    }
}

