/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.infos.DDLHelper;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableNodeInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class IndexNodeInfo
extends TableNodeInfo {
    static final long serialVersionUID = -8633867970381524742L;
    static final Logger LOGGER = Logger.getLogger(IndexNodeInfo.class.getName());

    public void initChildren(Vector vector) throws DatabaseException {
        try {
            if (!this.ensureConnected()) {
                return;
            }
            String string = (String)this.get("table");
            DriverSpecification driverSpecification = this.getDriverSpecification();
            driverSpecification.getIndexInfo(string, false, true);
            ResultSet resultSet = driverSpecification.getResultSet();
            if (resultSet != null) {
                HashMap hashMap = new HashMap();
                while (resultSet.next()) {
                    hashMap = driverSpecification.getRow();
                    String string2 = (String)this.get("index");
                    DatabaseNodeInfo databaseNodeInfo = DatabaseNodeInfo.createNodeInfo(this, "indexcolumn", hashMap);
                    String string3 = (String)databaseNodeInfo.get("ixname");
                    if (string2 != null && string3 != null && string3.equals(string2)) {
                        String string4 = databaseNodeInfo.get("ord") instanceof Boolean ? "A" : (String)databaseNodeInfo.get("ord");
                        if (string4 == null) {
                            string4 = "A";
                        }
                        databaseNodeInfo.put("iconbase", databaseNodeInfo.get("iconbase" + string4));
                        if (databaseNodeInfo != null) {
                            vector.add(databaseNodeInfo);
                        } else {
                            resultSet.close();
                            throw new Exception(IndexNodeInfo.bundle().getString("EXC_UnableToCreateIndexNodeInfo"));
                        }
                    }
                    hashMap.clear();
                }
                resultSet.close();
            }
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public void delete() throws IOException {
        try {
            String string = (String)this.get("table");
            Specification specification = (Specification)this.getSpecification();
            DDLHelper.deleteIndex(specification, (String)this.get("schema"), string, this.getName());
            this.getParent().removeChild(this);
        }
        catch (DDLException dDLException) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)dDLException.getMessage(), 0));
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, null, exception);
            throw new IOException(exception.toString());
        }
    }

    public String getShortDescription() {
        return IndexNodeInfo.bundle().getString("ND_Index");
    }

    public String getDisplayName() {
        return this.getName();
    }
}

