/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.text.MessageFormat;
import java.util.Vector;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverListener;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.explorer.DatabaseDriver;
import org.netbeans.modules.db.explorer.DatabaseOption;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.DriverNodeInfo;
import org.netbeans.modules.db.explorer.infos.DriverOperations;
import org.netbeans.modules.db.explorer.infos.RootNodeInfo;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class DriverListNodeInfo
extends DatabaseNodeInfo
implements DriverOperations {
    static final long serialVersionUID = -7948529055260667590L;
    private JDBCDriverListener listener = new JDBCDriverListener(){

        public void driversChanged() {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        DriverListNodeInfo.this.refreshChildren();
                    }
                    catch (DatabaseException databaseException) {
                        Exceptions.printStackTrace((Throwable)databaseException);
                    }
                }
            });
        }
    };

    public DriverListNodeInfo() {
        JDBCDriverManager.getDefault().addDriverListener(this.listener);
    }

    protected void initChildren(Vector vector) throws DatabaseException {
        JDBCDriver[] jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers();
        boolean bl = Utilities.isWindows();
        for (int i = 0; i < jDBCDriverArray.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int j = 0; j < jDBCDriverArray[i].getURLs().length; ++j) {
                if (j != 0) {
                    stringBuffer.append(", ");
                }
                String string = jDBCDriverArray[i].getURLs()[j].getFile();
                if (bl) {
                    string = string.substring(1);
                }
                stringBuffer.append(string);
            }
            DatabaseDriver databaseDriver = new DatabaseDriver(jDBCDriverArray[i].getDisplayName(), jDBCDriverArray[i].getClassName(), stringBuffer.toString(), jDBCDriverArray[i]);
            DriverNodeInfo driverNodeInfo = (DriverNodeInfo)DatabaseNodeInfo.createNodeInfo(this, "driver");
            if (driverNodeInfo == null || databaseDriver == null) continue;
            driverNodeInfo.setDatabaseDriver(databaseDriver);
            vector.add(driverNodeInfo);
        }
    }

    public void addDriver(DatabaseDriver databaseDriver) throws DatabaseException {
        DatabaseOption databaseOption = RootNodeInfo.getOption();
        Vector vector = databaseOption.getAvailableDrivers();
        if (vector.contains(databaseDriver)) {
            String string = MessageFormat.format(DriverListNodeInfo.bundle().getString("EXC_DriverAlreadyExists"), databaseDriver.toString());
            throw new DatabaseException(string);
        }
        vector.add(databaseDriver);
        DriverNodeInfo driverNodeInfo = (DriverNodeInfo)DriverListNodeInfo.createNodeInfo(this, "driver");
        driverNodeInfo.setDatabaseDriver(databaseDriver);
        this.notifyChange();
    }

    public String getDisplayName() {
        return DriverListNodeInfo.bundle().getString("NDN_Drivers");
    }

    public String getShortDescription() {
        return DriverListNodeInfo.bundle().getString("ND_DriverList");
    }
}

