/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.fourstate;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.impl.ConfigurableBarcodeGenerator;
import org.krysalis.barcode4j.impl.fourstate.USPSIntelligentMailBean;
import org.krysalis.barcode4j.tools.Length;

public class USPSIntelligentMail
extends ConfigurableBarcodeGenerator
implements Configurable {
    public USPSIntelligentMail() {
        this.bean = new USPSIntelligentMailBean();
    }

    public void configure(Configuration cfg) throws ConfigurationException {
        Length mw = new Length(cfg.getChild("module-width").getValue("0.02in"), "in");
        this.getUSPSIntelligentMailBean().setModuleWidth(mw.getValueAsMillimeter());
        super.configure(cfg);
        this.getUSPSIntelligentMailBean().setChecksumMode(ChecksumMode.byName(cfg.getChild("checksum").getValue(ChecksumMode.CP_AUTO.getName())));
        Length igw = new Length(cfg.getChild("interchar-gap-width").getValue("0.025in"), "in");
        if (igw.getUnit().equalsIgnoreCase("mw")) {
            this.getUSPSIntelligentMailBean().setIntercharGapWidth(igw.getValue() * this.getUSPSIntelligentMailBean().getModuleWidth());
        } else {
            this.getUSPSIntelligentMailBean().setIntercharGapWidth(igw.getValueAsMillimeter());
        }
        Length ah = new Length(cfg.getChild("ascender-height").getValue("0.05in"), "in");
        this.getUSPSIntelligentMailBean().setAscenderHeight(ah.getValueAsMillimeter());
        Length th = new Length(cfg.getChild("track-height").getValue("0.05in"), "in");
        this.getUSPSIntelligentMailBean().setTrackHeight(th.getValueAsMillimeter());
    }

    public USPSIntelligentMailBean getUSPSIntelligentMailBean() {
        return (USPSIntelligentMailBean)this.getBean();
    }
}

