/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.util.Collection;
import java.util.prefs.Preferences;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.modules.editor.FormatterIndentEngine;
import org.netbeans.modules.editor.IndentEngineFormatter;
import org.netbeans.modules.editor.lib.SettingsConversions;
import org.openide.text.IndentEngine;
import org.openide.util.Lookup;

public final class ComplexValueSettingsFactory {
    private ComplexValueSettingsFactory() {
    }

    public static final Object getRenderingHintsValue(MimePath mimePath, String string) {
        assert (string.equals("rendering-hints")) : "The getRenderingHints factory called for '" + string + "'";
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)mimePath).lookup(FontColorSettings.class);
        return fontColorSettings.getFontColors("default").getAttribute(EditorStyleConstants.RenderingHints);
    }

    public static final Object getFormatterValue(MimePath mimePath, String string) {
        assert (string.equals("formatter")) : "The getFormatter factory called for '" + string + "'";
        IndentEngine indentEngine = ComplexValueSettingsFactory.getIndentEngine(mimePath);
        if (indentEngine != null) {
            if (indentEngine instanceof FormatterIndentEngine) {
                return ((FormatterIndentEngine)indentEngine).getFormatter();
            }
            EditorKit editorKit = (EditorKit)MimeLookup.getLookup((MimePath)mimePath).lookup(EditorKit.class);
            if (editorKit != null) {
                return new IndentEngineFormatter(editorKit.getClass(), indentEngine);
            }
        }
        return null;
    }

    public static final IndentEngine getIndentEngine(MimePath mimePath) {
        IndentEngine indentEngine = null;
        Preferences preferences = (Preferences)MimeLookup.getLookup((MimePath)mimePath).lookup(Preferences.class);
        String string = preferences.get("indentEngine", null);
        if (string != null && string.indexOf(46) == -1) {
            Lookup.Template template = new Lookup.Template(IndentEngine.class, string, null);
            Collection collection = Lookup.getDefault().lookup(template).allInstances();
            if (!collection.isEmpty()) {
                indentEngine = (IndentEngine)collection.iterator().next();
            }
        } else {
            indentEngine = (IndentEngine)SettingsConversions.callFactory((Preferences)preferences, (MimePath)mimePath, (String)"indentEngine", null);
        }
        return indentEngine;
    }

    public static final Object getIdentifierAcceptorValue(MimePath mimePath, String string) {
        assert (string.equals("identifier-acceptor")) : "The getIdentifierAcceptorValue factory called for '" + string + "'";
        return AcceptorFactory.LETTER_DIGIT;
    }

    public static final Object getWhitespaceAcceptorValue(MimePath mimePath, String string) {
        assert (string.equals("whitespace-acceptor")) : "The getWhitespaceAcceptorValue factory called for '" + string + "'";
        return AcceptorFactory.WHITESPACE;
    }
}

