/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nickyb.sqleonardo.querybuilder.BaseMask;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.querybuilder.syntax.SubQuery;

public class MaskCondition
extends BaseMask
implements ItemListener,
ChangeListener {
    private JComboBox predicate;
    private JComboBox operator;
    private JCheckBox subquery;
    private JTextArea left;
    private JTextArea right;
    private QueryTokens.Condition querytoken;

    public MaskCondition(QueryTokens.Condition token, QueryBuilder builder) {
        super("condition.edit", builder);
        this.querytoken = token;
        this.predicate = new JComboBox<String>(new String[]{"AND", "OR"});
        this.operator = new JComboBox<String>(new String[]{"=", "<", ">", "<=", ">=", "<>", "LIKE", "NOT LIKE", "IS", "IS NOT", "IN", "NOT IN", "EXISTS", "NOT EXISTS", "BETWEEN", "NOT BETWEEN"});
        this.subquery = new JCheckBox("<html><i>SUBQUERY");
        this.subquery.setEnabled(false);
        this.subquery.setSelected(this.querytoken.getRight() instanceof SubQuery);
        this.operator.addItemListener(this);
        this.subquery.addChangeListener(this);
        this.left = new JTextArea();
        JScrollPane scrollL = new JScrollPane(this.left);
        this.right = new JTextArea();
        JScrollPane scrollR = new JScrollPane(this.right);
        this.left.setWrapStyleWord(true);
        this.right.setWrapStyleWord(true);
        this.left.setLineWrap(true);
        this.right.setLineWrap(true);
        this.left.setColumns(50);
        this.right.setColumns(50);
        this.left.setRows(5);
        this.right.setRows(5);
        GridBagLayout gbl = new GridBagLayout();
        JPanel pane = new JPanel(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 2, 0);
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbl.setConstraints(this.predicate, gbc);
        pane.add(this.predicate);
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbl.setConstraints(scrollL, gbc);
        pane.add(scrollL);
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.gridwidth = -1;
        gbl.setConstraints(this.operator, gbc);
        pane.add(this.operator);
        gbc.gridwidth = 0;
        gbl.setConstraints(this.subquery, gbc);
        pane.add(this.subquery);
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbl.setConstraints(scrollR, gbc);
        pane.add(scrollR);
        this.setComponentCenter(pane);
    }

    protected boolean onConfirm() {
        if (this.predicate.isEnabled()) {
            this.querytoken.setAppend(this.predicate.getSelectedItem().toString());
        }
        this.querytoken.setOperator(this.operator.getSelectedItem().toString());
        if (this.isExistsSelected()) {
            this.querytoken.setLeft(null);
        } else {
            this.querytoken.setLeft(new QueryTokens.DefaultExpression(this.left.getText()));
        }
        if (this.subquery.isSelected()) {
            if (!(this.querytoken.getRight() instanceof SubQuery)) {
                this.querytoken.setRight(new SubQuery());
            }
        } else {
            this.querytoken.setRight(new QueryTokens.DefaultExpression(this.right.getText()));
        }
        return true;
    }

    protected void onShow() {
        this.predicate.setEnabled(this.querytoken.getAppend() != null);
        this.predicate.setSelectedItem(this.querytoken.getAppend());
        this.operator.setSelectedItem(this.querytoken.getOperator());
        if (this.querytoken.getLeft() != null) {
            this.left.setText(this.querytoken.getLeft().toString());
            if (this.querytoken.getLeft() instanceof QueryTokens.DefaultExpression && ((QueryTokens.DefaultExpression)this.querytoken.getLeft()).isEmpty()) {
                this.left.setText("");
            }
        }
        if (this.querytoken.getRight() != null) {
            this.right.setText(this.querytoken.getRight().toString());
            if (this.querytoken.getRight() instanceof QueryTokens.DefaultExpression && ((QueryTokens.DefaultExpression)this.querytoken.getRight()).isEmpty()) {
                this.right.setText("");
            }
        }
    }

    private boolean isExistsSelected() {
        return this.operator.getSelectedItem().toString().equals("EXISTS") || this.operator.getSelectedItem().toString().equals("NOT EXISTS");
    }

    private boolean isInSelected() {
        return this.operator.getSelectedItem().toString().equals("IN") || this.operator.getSelectedItem().toString().equals("NOT IN");
    }

    private void onChanged() {
        this.subquery.setEnabled(this.isExistsSelected() || this.isInSelected());
        this.left.setEnabled(!this.isExistsSelected());
        this.right.setEnabled(!this.subquery.isSelected());
        this.left.setOpaque(this.left.isEnabled());
        this.right.setOpaque(this.right.isEnabled());
        if (!this.left.isEnabled()) {
            this.left.setText("");
        }
        if (!this.right.isEnabled()) {
            this.right.setText("");
        }
        if (!this.subquery.isEnabled()) {
            this.subquery.setSelected(false);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.onChanged();
    }

    public void stateChanged(ChangeEvent e) {
        this.onChanged();
    }
}

