/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.palette.actions.tools;

import com.jaspersoft.ireport.designer.palette.actions.CreateTextFieldAction;
import com.jaspersoft.ireport.designer.palette.actions.tools.FieldPercentageDialog;
import com.jaspersoft.ireport.designer.utils.Misc;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;

public class CreatePercentageTextfieldAction
extends CreateTextFieldAction {
    public JRDesignElement createReportElement(JasperDesign jd) {
        JRDesignTextField element = (JRDesignTextField)super.createReportElement(jd);
        FieldPercentageDialog dialog = new FieldPercentageDialog(Misc.getMainFrame());
        dialog.setJasperDesign(jd);
        dialog.setVisible(true);
        if (dialog.getDialogResult() == 0) {
            String vname;
            JRField f = dialog.getSelectedField();
            ResetTypeEnum resetType = dialog.getSelectedResetTypeValue();
            JRGroup group = null;
            if (resetType == ResetTypeEnum.GROUP) {
                group = dialog.getSelectedGroup();
            }
            JRDesignVariable variable = new JRDesignVariable();
            int i = 0;
            while (true) {
                vname = f.getName() + "_SUM";
                if (i > 0) {
                    vname = vname + "_" + i;
                }
                if (!jd.getVariablesMap().containsKey(vname)) break;
                ++i;
            }
            variable.setName(vname);
            variable.setExpression((JRExpression)Misc.createExpression(f.getValueClassName(), "$F{" + f.getName() + "}"));
            variable.setValueClassName(f.getValueClassName());
            variable.setCalculation(CalculationEnum.SUM);
            variable.setResetType(resetType);
            if (resetType == ResetTypeEnum.GROUP) {
                variable.setResetGroup(group);
            }
            try {
                jd.addVariable(variable);
            }
            catch (JRException ex) {
                ex.printStackTrace();
            }
            ((JRDesignExpression)element.getExpression()).setText("new Double( $F{" + f.getName() + "}.doubleValue() / $V{" + variable.getName() + "}.doubleValue() )");
            ((JRDesignExpression)element.getExpression()).setValueClassName("java.lang.Double");
            element.setPattern("#,##0.00%");
            CreatePercentageTextfieldAction.setMatchingClassExpression((JRDesignExpression)element.getExpression(), ((JRDesignExpression)element.getExpression()).getValueClassName(), true);
            element.setEvaluationTime(EvaluationTimeEnum.AUTO);
            return element;
        }
        return null;
    }
}

