/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.outline.nodes.ElementContainerChildren;
import com.jaspersoft.ireport.designer.outline.nodes.ElementPasteType;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import com.jaspersoft.ireport.designer.undo.DeleteElementGroupUndoableEdit;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class ElementGroupNode
extends IRIndexedNode
implements PropertyChangeListener {
    JasperDesign jd = null;
    JRDesignElementGroup elementGroup = null;

    public JRDesignElementGroup getElementGroup() {
        return this.elementGroup;
    }

    public ElementGroupNode(JasperDesign jd, JRDesignElementGroup elementGroup, Lookup doLkp) {
        this(new ElementContainerChildren(jd, elementGroup, doLkp), jd, elementGroup, doLkp);
    }

    public ElementGroupNode(ElementContainerChildren pc, JasperDesign jd, JRDesignElementGroup elementGroup, Lookup doLkp) {
        super((Children)pc, pc.getIndex(), (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, elementGroup})}));
        this.jd = jd;
        this.elementGroup = elementGroup;
        this.setDisplayName("Group");
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/elementgroup-16.png");
        elementGroup.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        this.addNodeListener(new NodeListener(){

            public void childrenAdded(NodeMemberEvent ev) {
            }

            public void childrenRemoved(NodeMemberEvent ev) {
            }

            public void nodeDestroyed(NodeEvent ev) {
            }

            public void propertyChange(PropertyChangeEvent evt) {
            }

            public void childrenReordered(NodeReorderEvent ev) {
                int i;
                List elements = ElementGroupNode.this.getElementGroup().getChildren();
                int[] permutations = ev.getPermutation();
                boolean permFound = false;
                Object[] elementsArray = new Object[elements.size()];
                for (i = 0; i < elementsArray.length; ++i) {
                    if (i >= permutations.length || permutations[i] >= elements.size()) {
                        permFound = true;
                        continue;
                    }
                    elementsArray[permutations[i]] = elements.get(i);
                    if (permutations[i] == i) continue;
                    permFound = true;
                }
                if (!permFound) {
                    return;
                }
                elements.clear();
                for (i = 0; i < elementsArray.length; ++i) {
                    if (elementsArray[i] == null) continue;
                    elements.add(elementsArray[i]);
                }
                ElementGroupNode.this.getElementGroup().getEventSupport().firePropertyChange("children", null, (Object)ElementGroupNode.this.getElementGroup().getChildren());
            }
        });
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        return sheet;
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(CopyAction.class), SystemAction.get(CutAction.class), SystemAction.get(PasteAction.class), SystemAction.get(ReorderAction.class), SystemAction.get(MoveUpAction.class), SystemAction.get(MoveDownAction.class), null, SystemAction.get(DeleteAction.class)};
    }

    public boolean canCut() {
        return true;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        JRDesignElementGroup container = (JRDesignElementGroup)this.getElementGroup().getElementGroup();
        int index = container.getChildren().indexOf(this.getElementGroup());
        container.removeElementGroup(this.getElementGroup());
        DeleteElementGroupUndoableEdit undo = new DeleteElementGroupUndoableEdit(this.getElementGroup(), container, index);
        IReportManager.getInstance().addUndoableEdit(undo);
        super.destroy();
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)4);
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)1);
    }

    public Transferable drag() throws IOException {
        return this.clipboardCut();
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        Node[] dropNodes = NodeTransfer.nodes((Transferable)t, (int)7);
        int dropAction = DnDUtilities.getTransferAction(t);
        if (dropNode == null) {
            ElementPasteType.setLastPastedNodes(dropNodes);
        }
        if (null != dropNode) {
            JRDesignElement element = (JRDesignElement)dropNode.getLookup().lookup(JRDesignElement.class);
            if (null != element) {
                if (element instanceof JRElementGroup && ModelUtils.isAncestorElemenetGroup((JRElementGroup)element, (JRElementGroup)this.getElementGroup())) {
                    return null;
                }
                return new ElementPasteType(element.getElementGroup(), (JRElementGroup)this.getElementGroup(), element, dropAction, (Node)this);
            }
            if (dropNode instanceof ElementGroupNode) {
                JRDesignElementGroup g = ((ElementGroupNode)dropNode).getElementGroup();
                if (ModelUtils.isAncestorElemenetGroup((JRElementGroup)g, (JRElementGroup)this.getElementGroup())) {
                    return null;
                }
                return new ElementPasteType(g.getElementGroup(), (JRElementGroup)this.getElementGroup(), g, dropAction, (Node)this);
            }
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
    }
}

