/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.palette.actions.CreateTextFieldAction;
import com.jaspersoft.ireport.designer.undo.AddStyleUndoableEdit;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabBucket;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignReportTemplate;
import net.sf.jasperreports.engine.design.JRDesignScriptlet;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.Pair;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.datatransfer.NewType;

class NewObjectType
extends NewType {
    Node parentNode = null;
    int type = -1;

    public NewObjectType(int type, Node parentNode) {
        this.parentNode = parentNode;
        this.type = type;
    }

    public void create() throws IOException {
        JasperDesign jd = (JasperDesign)this.parentNode.getLookup().lookup(JasperDesign.class);
        if (jd == null) {
            return;
        }
        JRDesignCrosstab crosstab = null;
        JRDesignDataset dataset = (JRDesignDataset)this.parentNode.getLookup().lookup(JRDesignDataset.class);
        if (dataset == null && (crosstab = (JRDesignCrosstab)this.parentNode.getLookup().lookup(JRDesignCrosstab.class)) != null) {
            dataset = ModelUtils.getElementDataset((JRDesignElement)crosstab, jd);
        }
        if (dataset == null) {
            dataset = jd.getMainDesignDataset();
        }
        if (dataset == null) {
            return;
        }
        JRDesignParameter obj = null;
        switch (this.type) {
            case 1: {
                try {
                    String baseName;
                    JRDesignParameter p = new JRDesignParameter();
                    String new_name = baseName = "parameter";
                    List list = dataset.getParametersList();
                    boolean found = true;
                    int j = 1;
                    while (found) {
                        found = false;
                        new_name = baseName + j;
                        for (int i = 0; i < list.size(); ++i) {
                            JRDesignParameter tmpP = (JRDesignParameter)list.get(i);
                            if (!tmpP.getName().equals(new_name)) continue;
                            found = true;
                        }
                        ++j;
                    }
                    p.setName(new_name);
                    obj = p;
                    dataset.addParameter((JRParameter)p);
                }
                catch (JRException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            case 2: {
                try {
                    String baseName;
                    JRDesignField f = new JRDesignField();
                    String new_name = baseName = "field";
                    List list = dataset.getFieldsList();
                    boolean found = true;
                    int j = 1;
                    while (found) {
                        found = false;
                        new_name = baseName + j;
                        for (int i = 0; i < list.size(); ++i) {
                            JRDesignField tmpP = (JRDesignField)list.get(i);
                            if (!tmpP.getName().equals(new_name)) continue;
                            found = true;
                        }
                        ++j;
                    }
                    f.setName(new_name);
                    obj = f;
                    dataset.addField((JRField)f);
                }
                catch (JRException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            case 3: {
                try {
                    String baseName;
                    JRDesignVariable v = new JRDesignVariable();
                    String new_name = baseName = "variable";
                    List list = dataset.getVariablesList();
                    boolean found = true;
                    int j = 1;
                    while (found) {
                        found = false;
                        new_name = baseName + j;
                        for (int i = 0; i < list.size(); ++i) {
                            JRDesignVariable tmpP = (JRDesignVariable)list.get(i);
                            if (!tmpP.getName().equals(new_name)) continue;
                            found = true;
                        }
                        ++j;
                    }
                    v.setName(new_name);
                    obj = v;
                    dataset.addVariable(v);
                }
                catch (JRException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            case 10: {
                try {
                    String baseName;
                    JRDesignGroup v = new JRDesignGroup();
                    String new_name = baseName = "group";
                    List list = dataset.getGroupsList();
                    boolean found = true;
                    int j = 1;
                    while (found) {
                        found = false;
                        new_name = baseName + j;
                        for (int i = 0; i < list.size(); ++i) {
                            JRDesignGroup tmpP = (JRDesignGroup)list.get(i);
                            if (!tmpP.getName().equals(new_name)) continue;
                            found = true;
                        }
                        ++j;
                    }
                    v.setName(new_name);
                    obj = v;
                    dataset.addGroup(v);
                }
                catch (JRException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            case 4: {
                try {
                    String baseName;
                    JRDesignStyle v = new JRDesignStyle();
                    String new_name = baseName = "style";
                    List list = jd.getStylesList();
                    boolean found = true;
                    int j = 1;
                    while (found) {
                        found = false;
                        new_name = baseName + j;
                        for (int i = 0; i < list.size(); ++i) {
                            JRDesignStyle tmpP = (JRDesignStyle)list.get(i);
                            if (!tmpP.getName().equals(new_name)) continue;
                            found = true;
                        }
                        ++j;
                    }
                    v.setName(new_name);
                    obj = v;
                    jd.addStyle((JRStyle)v);
                    AddStyleUndoableEdit undo = new AddStyleUndoableEdit(v, jd);
                    IReportManager.getInstance().addUndoableEdit(undo);
                }
                catch (JRException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            case 9: {
                JRDesignStyle parentStyle = (JRDesignStyle)this.parentNode.getLookup().lookup(JRDesignStyle.class);
                if (parentStyle == null) {
                    return;
                }
                JRDesignConditionalStyle v = new JRDesignConditionalStyle();
                parentStyle.addConditionalStyle((JRConditionalStyle)v);
                break;
            }
            case 5: {
                if (crosstab == null) {
                    return;
                }
                try {
                    String baseName;
                    JRDesignCrosstabParameter p = new JRDesignCrosstabParameter();
                    String new_name = baseName = "parameter";
                    List list = crosstab.getParametersList();
                    boolean found = true;
                    int j = 1;
                    while (found) {
                        found = false;
                        new_name = baseName + j;
                        for (int i = 0; i < list.size(); ++i) {
                            JRDesignParameter tmpP = (JRDesignParameter)list.get(i);
                            if (!tmpP.getName().equals(new_name)) continue;
                            found = true;
                        }
                        ++j;
                    }
                    p.setName(new_name);
                    obj = p;
                    crosstab.addParameter((JRCrosstabParameter)p);
                }
                catch (JRException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            case 6: {
                if (crosstab == null) {
                    return;
                }
                try {
                    String baseName;
                    JRDesignCrosstabMeasure p = new JRDesignCrosstabMeasure();
                    String new_name = baseName = "measure";
                    int j = 1;
                    while (!ModelUtils.isValidNewCrosstabObjectName(crosstab, new_name = baseName + j)) {
                        ++j;
                    }
                    p.setName(new_name);
                    JRDesignExpression exp = Misc.createExpression("java.lang.Integer", "\"\"");
                    p.setValueExpression((JRExpression)exp);
                    p.setValueClassName("java.lang.Integer");
                    obj = p;
                    crosstab.addMeasure(p);
                }
                catch (JRException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            case 7: {
                if (crosstab == null) {
                    return;
                }
                try {
                    String baseName;
                    JRDesignCrosstabRowGroup group = new JRDesignCrosstabRowGroup();
                    String new_name = baseName = "group";
                    int j = 1;
                    while (!ModelUtils.isValidNewCrosstabObjectName(crosstab, new_name = baseName + j)) {
                        ++j;
                    }
                    group.setName(new_name);
                    group.setWidth(100);
                    JRDesignExpression exp = Misc.createExpression("java.lang.String", "");
                    JRDesignCrosstabBucket bucket = new JRDesignCrosstabBucket();
                    bucket.setExpression(exp);
                    group.setBucket(bucket);
                    JRDesignCellContents headerCell = new JRDesignCellContents();
                    group.setHeader(headerCell);
                    JRDesignCrosstabCell baseCell = (JRDesignCrosstabCell)crosstab.getCellsMap().get(new Pair(null, null));
                    int baseHeight = baseCell.getHeight() != null ? baseCell.getHeight() : (baseCell.getContents() != null ? baseCell.getContents().getHeight() : 30);
                    headerCell.addElement((JRDesignElement)this.createField(jd, Misc.createExpression("java.lang.String", "$V{" + new_name + "}"), 100, baseHeight, "Crosstab Data Text"));
                    group.setTotalHeader(new JRDesignCellContents());
                    obj = group;
                    crosstab.addRowGroup(group);
                    JRCrosstabColumnGroup[] columns = crosstab.getColumnGroups();
                    JRDesignCrosstabCell dT = new JRDesignCrosstabCell();
                    dT.setRowTotalGroup(new_name);
                    crosstab.addCell(dT);
                    for (int i = 0; i < columns.length; ++i) {
                        JRDesignCrosstabCell cell = new JRDesignCrosstabCell();
                        cell.setRowTotalGroup(new_name);
                        cell.setColumnTotalGroup(columns[i].getName());
                        crosstab.addCell(cell);
                    }
                    break;
                }
                catch (JRException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    break;
                }
            }
            case 8: {
                if (crosstab == null) {
                    return;
                }
                try {
                    String baseName;
                    JRDesignCrosstabColumnGroup group = new JRDesignCrosstabColumnGroup();
                    String new_name = baseName = "group";
                    int j = 1;
                    while (!ModelUtils.isValidNewCrosstabObjectName(crosstab, new_name = baseName + j)) {
                        ++j;
                    }
                    group.setName(new_name);
                    group.setHeight(30);
                    JRDesignExpression exp = Misc.createExpression("java.lang.String", "");
                    JRDesignCrosstabBucket bucket = new JRDesignCrosstabBucket();
                    bucket.setExpression(exp);
                    group.setBucket(bucket);
                    JRDesignCellContents headerCell = new JRDesignCellContents();
                    group.setHeader(headerCell);
                    JRDesignCrosstabCell baseCell = (JRDesignCrosstabCell)crosstab.getCellsMap().get(new Pair(null, null));
                    int baseWidth = baseCell.getWidth() != null ? baseCell.getWidth() : (baseCell.getContents() != null ? baseCell.getContents().getWidth() : 50);
                    headerCell.addElement((JRDesignElement)this.createField(jd, Misc.createExpression("java.lang.String", "$V{" + new_name + "}"), baseWidth, 30, "Crosstab Data Text"));
                    group.setTotalHeader(new JRDesignCellContents());
                    obj = group;
                    crosstab.addColumnGroup(group);
                    JRCrosstabRowGroup[] rows = crosstab.getRowGroups();
                    JRDesignCrosstabCell dT = new JRDesignCrosstabCell();
                    dT.setColumnTotalGroup(new_name);
                    crosstab.addCell(dT);
                    for (int i = 0; i < rows.length; ++i) {
                        JRDesignCrosstabCell cell = new JRDesignCrosstabCell();
                        cell.setColumnTotalGroup(new_name);
                        cell.setRowTotalGroup(rows[i].getName());
                        crosstab.addCell(cell);
                    }
                    break;
                }
                catch (JRException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    break;
                }
            }
            case 11: {
                JrxmlVisualView view;
                FileObject fobj;
                File f;
                JRDesignReportTemplate v = new JRDesignReportTemplate();
                File parent = new File(IReportManager.getInstance().getCurrentDirectory());
                if (IReportManager.getInstance().getActiveVisualView() != null && (f = FileUtil.toFile((FileObject)(fobj = (view = IReportManager.getInstance().getActiveVisualView()).getEditorSupport().getDataObject().getPrimaryFile()))) != null && f.getParentFile().exists()) {
                    parent = f.getParentFile();
                }
                JFileChooser jfc = new JFileChooser(parent);
                jfc.setDialogTitle("Select an Report Template (JRTX) file....");
                jfc.setFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        String filename = file.getName();
                        return filename.endsWith(".jrtx") || file.isDirectory();
                    }

                    public String getDescription() {
                        return "JasperReports Tempate *.jrtx|*.xml";
                    }
                });
                jfc.setMultiSelectionEnabled(false);
                jfc.setDialogType(0);
                if (jfc.showOpenDialog(null) == 0) {
                    IReportManager.getInstance().setCurrentDirectory(jfc.getSelectedFile().getParent(), true);
                    v.setSourceExpression((JRExpression)Misc.createExpression("java.lang.String", "\"" + Misc.string_replace("\\\\", "\\", jfc.getSelectedFile().getPath() + "\"")));
                    IReportManager.getInstance().setCurrentDirectory(jfc.getSelectedFile().getParent(), true);
                } else {
                    v.setSourceExpression((JRExpression)Misc.createExpression("java.lang.String", ""));
                }
                jd.addTemplate((JRReportTemplate)v);
                break;
            }
            case 12: {
                try {
                    String baseName;
                    JRDesignScriptlet p = new JRDesignScriptlet();
                    p.setValueClassName("net.sf.jasperreports.engine.JRDefaultScriptlet");
                    String new_name = baseName = "scriptlet";
                    List list = dataset.getScriptletsList();
                    boolean found = true;
                    int j = 1;
                    while (found) {
                        found = false;
                        new_name = baseName + j;
                        for (int i = 0; i < list.size(); ++i) {
                            JRDesignScriptlet tmpP = (JRDesignScriptlet)list.get(i);
                            if (!tmpP.getName().equals(new_name)) continue;
                            found = true;
                        }
                        ++j;
                    }
                    p.setName(new_name);
                    obj = p;
                    dataset.addScriptlet((JRScriptlet)p);
                    break;
                }
                catch (JRException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (obj != null) {
            IReportManager.getInstance().setSelectedObject(obj);
        }
    }

    public String getName() {
        switch (this.type) {
            case 1: {
                return I18n.getString("NewType.Parameter");
            }
            case 2: {
                return I18n.getString("NewType.Field");
            }
            case 3: {
                return I18n.getString("NewType.Variable");
            }
            case 4: {
                return I18n.getString("NewType.Style");
            }
            case 9: {
                return I18n.getString("NewType.ConditionalStyle");
            }
            case 5: {
                return I18n.getString("NewType.CrosstabParameter");
            }
            case 6: {
                return I18n.getString("NewType.Measure");
            }
            case 7: {
                return I18n.getString("NewType.RowGroup");
            }
            case 8: {
                return I18n.getString("NewType.ColumnGroup");
            }
            case 10: {
                return I18n.getString("NewType.DatasetGroup");
            }
            case 11: {
                return I18n.getString("Style reference");
            }
            case 12: {
                return I18n.getString("Scriptlet");
            }
        }
        return super.getName();
    }

    private JRDesignStaticText createLabel(JasperDesign jd, String text, int w, int h, String styleName) {
        JRDesignStaticText element = new JRDesignStaticText();
        element.setX(0);
        element.setY(0);
        element.setWidth(w);
        element.setHeight(h);
        element.setText(text);
        element.setHorizontalAlignment(HorizontalAlignEnum.CENTER);
        element.setVerticalAlignment(VerticalAlignEnum.MIDDLE);
        if (styleName != null && jd.getStylesMap().containsKey(styleName)) {
            element.setStyle((JRStyle)jd.getStylesMap().get(styleName));
        }
        return element;
    }

    private JRDesignTextField createField(JasperDesign jd, JRDesignExpression exp, int w, int h, String styleName) {
        JRDesignTextField element = new JRDesignTextField();
        element.setX(0);
        element.setY(0);
        element.setWidth(w);
        element.setHeight(h);
        if (styleName != null && jd.getStylesMap().containsKey(styleName)) {
            element.setStyle((JRStyle)jd.getStylesMap().get(styleName));
        }
        try {
            CreateTextFieldAction.setMatchingClassExpression(exp, exp.getValueClassName(), true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        element.setExpression((JRExpression)exp);
        return element;
    }
}

