/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.jrtx;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.jrtx.JRTXEditorSupport;
import com.jaspersoft.ireport.designer.jrtx.StylesChildren;
import com.jaspersoft.ireport.designer.jrtx.TemplateNode;
import com.jaspersoft.ireport.designer.sheet.JRPenProperty;
import com.jaspersoft.ireport.designer.sheet.properties.StringProperty;
import com.jaspersoft.ireport.designer.sheet.properties.StylePatternProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.BackcolorProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.BlankWhenNullProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.BoldProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.FillProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.FirstLineIndentProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.FontNameProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.FontSizeProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.ForecolorProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.HorizontalAlignmentProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.ItalicProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.LeftIndentProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.LineSpacingProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.LineSpacingSizeProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.ModeProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.PaddingAndBordersProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.PdfEmbeddedProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.PdfEncodingProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.PdfFontNameProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.RadiusProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.RightIndentProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.RotationProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.ScaleImageProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.SpacingAfterProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.SpacingBeforeProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.StrikeThroughProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.TabStopWidthProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.TabStopsProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.UnderlineProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.VerticalAlignmentProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRPenContainer;
import net.sf.jasperreports.engine.JRSimpleTemplate;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBaseParagraph;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import org.openide.ErrorManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.RenameAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class StyleNode
extends AbstractNode
implements PropertyChangeListener {
    private JRSimpleTemplate template;
    private JRBaseStyle style = null;

    public StyleNode(JRSimpleTemplate template, JRBaseStyle style, Lookup doLkp) {
        super(Children.LEAF, (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{template, style})}));
        this.template = template;
        this.style = style;
        this.init();
    }

    public String getDisplayName() {
        return this.getStyle().getName();
    }

    private void init() {
        this.setDisplayName(this.style.getName());
        super.setName(this.style.getName());
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/style-16.png");
        this.style.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBasePen)this.style.getLinePen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        JRBaseLineBox baseBox = (JRBaseLineBox)this.style.getLineBox();
        baseBox.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBasePen)baseBox.getPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBasePen)baseBox.getTopPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBasePen)baseBox.getBottomPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBasePen)baseBox.getLeftPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBasePen)baseBox.getRightPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBaseParagraph)this.style.getParagraph()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void destroy() throws IOException {
        this.getTemplate().removeStyle((JRStyle)this.getStyle());
        JRTXEditorSupport ed = (JRTXEditorSupport)((Object)this.getLookup().lookup(JRTXEditorSupport.class));
        if (ed != null) {
            ed.notifyModelChangeToTheView();
        }
        if (this.getParentNode() != null && this.getParentNode() instanceof TemplateNode) {
            ((StylesChildren)this.getParentNode().getChildren()).recalculateKeys();
        }
        super.destroy();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new NameProperty((JRDesignStyle)this.getStyle(), this.getTemplate()));
        set.put((Node.Property)new DefaultStyleProperty((JRDesignStyle)this.getStyle(), this.getTemplate()));
        set.put((Node.Property)new ParentStyleNameProperty((JRDesignStyle)this.getStyle()));
        set.put((Node.Property)new ModeProperty(this.getStyle()));
        set.put((Node.Property)new ForecolorProperty(this.getStyle()));
        set.put((Node.Property)new BackcolorProperty(this.getStyle()));
        set.put((Node.Property)new PaddingAndBordersProperty(this.getStyle()));
        JRPenProperty penProp = new JRPenProperty(this.getStyle().getLinePen(), (JRPenContainer)this.getStyle());
        set.put((Node.Property)penProp);
        set.put((Node.Property)new FillProperty(this.getStyle()));
        set.put((Node.Property)new RadiusProperty(this.getStyle()));
        set.put((Node.Property)new ScaleImageProperty(this.getStyle()));
        set.put((Node.Property)new FontNameProperty(this.getStyle()));
        set.put((Node.Property)new FontSizeProperty(this.getStyle()));
        set.put((Node.Property)new BoldProperty(this.getStyle()));
        set.put((Node.Property)new ItalicProperty(this.getStyle()));
        set.put((Node.Property)new UnderlineProperty(this.getStyle()));
        set.put((Node.Property)new StrikeThroughProperty(this.getStyle()));
        set.put((Node.Property)new HorizontalAlignmentProperty(this.getStyle()));
        set.put((Node.Property)new VerticalAlignmentProperty(this.getStyle()));
        set.put((Node.Property)new RotationProperty(this.getStyle()));
        set.put((Node.Property)new LineSpacingProperty(this.getStyle()));
        set.put((Node.Property)new LineSpacingSizeProperty(this.getStyle()));
        set.put((Node.Property)new FirstLineIndentProperty(this.getStyle()));
        set.put((Node.Property)new LeftIndentProperty(this.getStyle()));
        set.put((Node.Property)new RightIndentProperty(this.getStyle()));
        set.put((Node.Property)new SpacingBeforeProperty(this.getStyle()));
        set.put((Node.Property)new SpacingAfterProperty(this.getStyle()));
        set.put((Node.Property)new TabStopWidthProperty(this.getStyle()));
        set.put((Node.Property)new TabStopsProperty(this.getStyle()));
        set.put((Node.Property)new PdfFontNameProperty(this.getStyle()));
        set.put((Node.Property)new PdfEmbeddedProperty(this.getStyle()));
        set.put((Node.Property)new PdfEncodingProperty(this.getStyle()));
        set.put((Node.Property)new StylePatternProperty(this.getStyle()));
        set.put((Node.Property)new BlankWhenNullProperty(this.getStyle()));
        sheet.put(set);
        return sheet;
    }

    public boolean canCut() {
        return true;
    }

    public boolean canRename() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)4);
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)1);
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(CopyAction.class), SystemAction.get(CutAction.class), SystemAction.get(RenameAction.class), null, SystemAction.get(DeleteAction.class)};
    }

    public Transferable drag() throws IOException {
        ExTransferable tras = ExTransferable.create((Transferable)this.clipboardCut());
        return tras;
    }

    public void setName(String s) {
        if (s.equals("")) {
            throw new IllegalArgumentException(I18n.getString("StyleNode.Exception.NameNotValid"));
        }
        ArrayList<JRDesignStyle> currentStyles = new ArrayList<JRDesignStyle>();
        JRStyle[] ss = this.getTemplate().getStyles();
        for (int i = 0; i < ss.length; ++i) {
            currentStyles.add((JRDesignStyle)ss[i]);
        }
        for (JRDesignStyle st : currentStyles) {
            if (st == this.getStyle() || !st.getName().equals(s)) continue;
            IllegalArgumentException iae = this.annotateException(I18n.getString("StyleNode.Exception.NameInUse"));
            throw iae;
        }
        String oldName = this.getStyle().getName();
        ((JRDesignStyle)this.getStyle()).setName(s);
        ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getStyle(), "Name", String.class, oldName, this.getStyle().getName());
    }

    public IllegalArgumentException annotateException(String msg) {
        IllegalArgumentException iae = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
        return iae;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        JRTXEditorSupport ed = (JRTXEditorSupport)((Object)this.getLookup().lookup(JRTXEditorSupport.class));
        if (ed != null) {
            ed.notifyModelChangeToTheView();
        }
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("name")) {
            super.setName(this.getStyle().getName());
            this.setDisplayName(this.getStyle().getName());
        } else if (evt.getPropertyName().equals("lineColor") || evt.getPropertyName().equals("lineStyle") || evt.getPropertyName().equals("lineWidth")) {
            if (ModelUtils.containsProperty(this.getPropertySets(), "pen")) {
                this.firePropertyChange("pen", evt.getOldValue(), evt.getNewValue());
            }
            if (ModelUtils.containsProperty(this.getPropertySets(), "linebox")) {
                this.firePropertyChange("linebox", evt.getOldValue(), evt.getNewValue());
            }
        } else if ((evt.getPropertyName().equals("bottomPadding") || evt.getPropertyName().equals("bottomPadding") || evt.getPropertyName().equals("bottomPadding") || evt.getPropertyName().equals("bottomPadding")) && ModelUtils.containsProperty(this.getPropertySets(), "linebox")) {
            this.firePropertyChange("linebox", evt.getOldValue(), evt.getNewValue());
        }
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    public JRBaseStyle getStyle() {
        return this.style;
    }

    public void setStyle(JRBaseStyle style) {
        this.style = style;
    }

    public JRSimpleTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(JRSimpleTemplate template) {
        this.template = template;
    }

    public static final class DefaultStyleProperty
    extends PropertySupport.ReadWrite {
        JRDesignStyle style = null;
        JRSimpleTemplate template = null;

        public DefaultStyleProperty(JRDesignStyle style, JRSimpleTemplate template) {
            super("isDefault", Boolean.class, "Default Style", I18n.getString("StyleNode.Property.DefaultStyle"));
            this.template = template;
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return new Boolean(this.getStyle().isDefault());
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val != null && val instanceof Boolean) {
                Boolean oldValue = this.getStyle().isDefault();
                Boolean newValue = (Boolean)val;
                ObjectPropertyUndoableEdit urob2 = null;
                if (newValue.booleanValue()) {
                    ArrayList<JRDesignStyle> list = new ArrayList<JRDesignStyle>();
                    JRStyle[] ss = this.template.getStyles();
                    for (int i = 0; i < ss.length; ++i) {
                        list.add((JRDesignStyle)ss[i]);
                    }
                    for (JRDesignStyle st : list) {
                        if (!st.isDefault()) continue;
                        st.setDefault(false);
                        urob2 = new ObjectPropertyUndoableEdit(st, "Default", Boolean.TYPE, Boolean.TRUE, Boolean.FALSE);
                        break;
                    }
                }
                this.getStyle().setDefault(newValue.booleanValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.getStyle(), "Default", Boolean.TYPE, oldValue, newValue);
                if (urob2 != null) {
                    urob.concatenate(urob2);
                }
            }
        }

        public boolean isDefaultValue() {
            return !this.getStyle().isDefault();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            super.restoreDefaultValue();
            this.setValue(Boolean.FALSE);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public JRDesignStyle getStyle() {
            return this.style;
        }
    }

    public static final class ParentStyleNameProperty
    extends StringProperty {
        JRDesignStyle style = null;

        public ParentStyleNameProperty(JRDesignStyle style) {
            super(style);
            this.setName("parentStyleNameReference");
            this.setDisplayName("Parent Style Name");
            this.setShortDescription("Parent Style Name");
            this.style = style;
            this.setValue("oneline", Boolean.TRUE);
        }

        public String getString() {
            return this.style.getStyleNameReference();
        }

        public String getOwnString() {
            return this.style.getStyleNameReference();
        }

        public String getDefaultString() {
            return null;
        }

        public void setString(String value) {
            this.style.setParentStyleNameReference(value);
        }
    }

    public static final class NameProperty
    extends PropertySupport.ReadWrite {
        JRDesignStyle style = null;
        JRSimpleTemplate template = null;

        public NameProperty(JRDesignStyle style, JRSimpleTemplate template) {
            super("name", String.class, I18n.getString("StyleNode.Property.Name"), I18n.getString("StyleNode.Property.NameStyle"));
            this.style = style;
            this.template = template;
            this.setValue("oneline", Boolean.TRUE);
        }

        public boolean canWrite() {
            return true;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.getStyle().getName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val.equals("")) {
                IllegalArgumentException iae = this.annotateException(I18n.getString("StyleNode.Exception.NameNotValid"));
                throw iae;
            }
            String s = val + "";
            ArrayList<JRDesignStyle> currentStyles = new ArrayList<JRDesignStyle>();
            JRStyle[] ss = this.template.getStyles();
            for (int i = 0; i < ss.length; ++i) {
                currentStyles.add((JRDesignStyle)ss[i]);
            }
            for (JRDesignStyle st : currentStyles) {
                if (st == this.getStyle() || !st.getName().equals(s)) continue;
                IllegalArgumentException iae = this.annotateException(I18n.getString("StyleNode.Exception.NameInUse"));
                throw iae;
            }
            String oldName = this.getStyle().getName();
            this.getStyle().setName(s);
            ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getStyle(), "Name", String.class, oldName, this.getStyle().getName());
            IReportManager.getInstance().addUndoableEdit(opue);
        }

        public JRDesignStyle getStyle() {
            return this.style;
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }
}

