/*
 * Decompiled with CFR 0.152.
 */
package rex;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Locale;
import java.util.Properties;
import rex.utils.I18n;
import rex.utils.S;

public class LogPropertyGenerator {
    private String strPropertyContent;
    private File logFileLocation;
    Properties rexProp;
    boolean created = false;

    public LogPropertyGenerator() {
        try {
            File logFolder = new File("logs");
            if (!logFolder.exists() || !logFolder.isDirectory()) {
                this.created = logFolder.mkdir();
            }
            String userHome = System.getProperty("user.home");
            this.logFileLocation = new File(userHome, "rex.properties");
            if (!this.logFileLocation.exists()) {
                this.generateLogProperty();
                FileOutputStream out = new FileOutputStream(this.logFileLocation);
                out.write(this.strPropertyContent.getBytes());
                out.close();
            }
            Locale locale = I18n.getCurrentLocale();
        }
        catch (Exception exception) {
            S.reportError(exception);
        }
    }

    private void generateLogProperty() {
        this.strPropertyContent = "# This Property file is means to append logs with Console as well as to log file.\n";
        this.strPropertyContent = this.strPropertyContent.concat("# file (By default).\n");
        this.strPropertyContent = this.strPropertyContent.concat("log4j.rootLogger=debug, stdout, R\n");
        this.strPropertyContent = this.strPropertyContent.concat("####################### Binding logs with console #######################\n");
        this.strPropertyContent = this.strPropertyContent.concat("log4j.appender.stdout=org.apache.log4j.ConsoleAppender\n");
        this.strPropertyContent = this.strPropertyContent.concat("log4j.appender.stdout.layout=org.apache.log4j.PatternLayout\n");
        this.strPropertyContent = this.strPropertyContent.concat("# Pattern to output the caller's file name and line number.\n");
        this.strPropertyContent = this.strPropertyContent.concat("log4j.appender.stdout.layout.ConversionPattern=%5p [%t] (%F:%L) - %m%n\n");
        this.strPropertyContent = this.strPropertyContent.concat("#########################################################################\n");
        this.strPropertyContent = this.strPropertyContent.concat("###################### Binding logs with log file #######################\n");
        this.strPropertyContent = this.strPropertyContent.concat("log4j.appender.R=org.apache.log4j.RollingFileAppender\n");
        this.strPropertyContent = this.created ? this.strPropertyContent.concat("log4j.appender.R.File=logs/rex.log\n") : this.strPropertyContent.concat("log4j.appender.R.File=rex.log\n");
        this.strPropertyContent = this.strPropertyContent.concat("# Keep one backup file\n");
        this.strPropertyContent = this.strPropertyContent.concat("log4j.appender.R.MaxBackupIndex=1\n");
        this.strPropertyContent = this.strPropertyContent.concat("log4j.appender.R.layout=org.apache.log4j.PatternLayout\n");
        this.strPropertyContent = this.strPropertyContent.concat("log4j.appender.R.layout.ConversionPattern=%5p [%t] (%F:%L) - %m%n\n");
        this.strPropertyContent = this.strPropertyContent.concat("#########################################################################\n");
    }

    public static void main(String[] args) {
        new LogPropertyGenerator();
    }
}

