/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.catalog.impl;

import java.io.IOException;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModel;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModelFactory;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogModelImpl;
import org.netbeans.modules.xml.retriever.catalog.impl.LSResourceResolverImpl;
import org.netbeans.modules.xml.retriever.catalog.impl.XAMCatalogWriteModelImpl;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileObject;
import org.w3c.dom.ls.LSResourceResolver;

public class CatalogModelFactoryImpl
extends CatalogWriteModelFactory {
    private static Logger logger = Logger.getLogger(CatalogModelFactoryImpl.class.getName());
    private static WeakHashMap<Project, CatalogWriteModel> projcat = new WeakHashMap();
    private static WeakHashMap<FileObject, CatalogWriteModel> foCat = new WeakHashMap();
    private static int count = 0;
    private static WeakHashMap<Project, CatalogModel> proj2cm = new WeakHashMap();

    public CatalogWriteModel getCatalogWriteModelForProject(FileObject fileObject) throws CatalogModelException {
        logger.entering("CatalogModelFactoryImpl", "getCatalogModelForProject");
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        assert (project != null);
        XAMCatalogWriteModelImpl xAMCatalogWriteModelImpl = null;
        try {
            CatalogWriteModel catalogWriteModel = foCat.get(Utilities.getProjectCatalogFileObject(project));
            if (catalogWriteModel != null) {
                return catalogWriteModel;
            }
            xAMCatalogWriteModelImpl = new XAMCatalogWriteModelImpl(project);
            foCat.put(xAMCatalogWriteModelImpl.getCatalogFileObject(), xAMCatalogWriteModelImpl);
            return xAMCatalogWriteModelImpl;
        }
        catch (IOException iOException) {
            throw new CatalogModelException((Throwable)iOException);
        }
    }

    public CatalogModel getCatalogModel(ModelSource modelSource) throws CatalogModelException {
        if (modelSource == null) {
            throw new IllegalArgumentException("modelSource arg is null.");
        }
        CatalogModel catalogModel = (CatalogModel)modelSource.getLookup().lookup(CatalogModel.class);
        if (catalogModel == null) {
            FileObject fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class);
            if (fileObject == null) {
                throw new IllegalArgumentException("ModelSource must have FileObject in its lookup");
            }
            return this.getCatalogModel(fileObject);
        }
        return catalogModel;
    }

    public CatalogModel getCatalogModel(FileObject fileObject) throws CatalogModelException {
        CatalogModelImpl catalogModelImpl = null;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            catalogModelImpl = proj2cm.get(fileObject);
            if (catalogModelImpl != null) {
                return catalogModelImpl;
            }
            try {
                catalogModelImpl = new CatalogModelImpl(project);
            }
            catch (IOException iOException) {
                throw new CatalogModelException((Throwable)iOException);
            }
            return catalogModelImpl;
        }
        catalogModelImpl = new CatalogModelImpl();
        return catalogModelImpl;
    }

    public LSResourceResolver getLSResourceResolver() {
        return new LSResourceResolverImpl();
    }

    public CatalogWriteModel getCatalogWriteModelForCatalogFile(FileObject fileObject) throws CatalogModelException {
        try {
            return new XAMCatalogWriteModelImpl(fileObject);
        }
        catch (IOException iOException) {
            throw new CatalogModelException((Throwable)iOException);
        }
    }
}

