/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.errorstripe.privatespi;

import java.awt.Color;

public final class Status
implements Comparable {
    private static final int STATUS_OK_NUMBER = 0;
    private static final int STATUS_WARNING_NUMBER = 1;
    private static final int STATUS_ERROR_NUMBER = 2;
    public static final Status STATUS_OK = new Status(0);
    public static final Status STATUS_WARNING = new Status(1);
    public static final Status STATUS_ERROR = new Status(2);
    private static final Status[] VALUES = new Status[]{STATUS_OK, STATUS_WARNING, STATUS_ERROR};
    private static final Color[] DEFAULT_STATUS_COLORS = new Color[]{Color.GREEN, new Color(14789120), new Color(16722460)};
    private int status;
    private static String[] STATUS_NAMES = new String[]{"OK", "WARNING", "ERROR"};

    private Status(int n) throws IllegalArgumentException {
        if (n != 2 && n != 1 && n != 0) {
            throw new IllegalArgumentException("Invalid status provided: " + n);
        }
        this.status = n;
    }

    private int getStatus() {
        return this.status;
    }

    public int compareTo(Object object) {
        Status status = (Status)object;
        if (this.status > status.status) {
            return 1;
        }
        if (this.status < status.status) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Status)) {
            return false;
        }
        Status status = (Status)object;
        return this.status == status.status;
    }

    public int hashCode() {
        return 0x2B ^ this.status;
    }

    public String toString() {
        return "[Status: " + STATUS_NAMES[this.getStatus()] + "]";
    }

    public static Status getCompoundStatus(Status status, Status status2) throws IllegalArgumentException {
        if (status != STATUS_ERROR && status != STATUS_WARNING && status != STATUS_OK) {
            throw new IllegalArgumentException("Invalid status provided: " + status);
        }
        if (status2 != STATUS_ERROR && status2 != STATUS_WARNING && status2 != STATUS_OK) {
            throw new IllegalArgumentException("Invalid status provided: " + status2);
        }
        return VALUES[Math.max(status.getStatus(), status2.getStatus())];
    }

    public static Color getDefaultColor(Status status) {
        return DEFAULT_STATUS_COLORS[status.getStatus()];
    }
}

