/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.virtualization;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JRRecordedValues;
import net.sf.jasperreports.engine.virtualization.ObjectSerializer;
import net.sf.jasperreports.engine.virtualization.ReferenceType;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;

public class RecordedValuesSerializer
implements ObjectSerializer<JRRecordedValues> {
    @Override
    public int typeValue() {
        return 63;
    }

    @Override
    public ReferenceType defaultReferenceType() {
        return ReferenceType.IDENTITY;
    }

    @Override
    public boolean defaultStoreReference() {
        return false;
    }

    @Override
    public void write(JRRecordedValues values, VirtualizationOutput out) throws IOException {
        Set<JREvaluationTime> evaluationTimes = values.getEvaluationTimes();
        out.writeIntCompressed(evaluationTimes.size());
        for (JREvaluationTime evaluationTime : evaluationTimes) {
            out.writeJRObject(evaluationTime);
        }
        Map<String, Object> recordedFieldValues = values.getRecordedFieldValues();
        this.writeMap(out, recordedFieldValues);
        Map<String, Object> recordedVariableValues = values.getRecordedVariableValues();
        this.writeMap(out, recordedVariableValues);
    }

    protected void writeMap(VirtualizationOutput out, Map<String, Object> values) throws IOException {
        if (values == null) {
            out.writeIntCompressed(0);
        } else {
            out.writeIntCompressed(values.size() + 1);
            for (Map.Entry<String, Object> varEntry : values.entrySet()) {
                out.writeJRObject(varEntry.getKey());
                out.writeJRObject(varEntry.getValue());
            }
        }
    }

    @Override
    public JRRecordedValues read(VirtualizationInput in) throws IOException {
        int evalTimesCount = in.readIntCompressed();
        HashSet<JREvaluationTime> evaluationTimes = new HashSet<JREvaluationTime>(evalTimesCount * 4 / 3 + 1, 0.75f);
        int i = 0;
        while (i < evalTimesCount) {
            evaluationTimes.add((JREvaluationTime)in.readJRObject());
            ++i;
        }
        Map<String, Object> recordedFieldValues = this.readMap(in);
        Map<String, Object> recordedVariableValues = this.readMap(in);
        JRRecordedValues values = new JRRecordedValues(evaluationTimes, recordedFieldValues, recordedVariableValues);
        return values;
    }

    protected Map<String, Object> readMap(VirtualizationInput in) throws IOException {
        int size = in.readIntCompressed();
        if (size == 0) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(size * 4 / 3 + 1, 0.75f);
        int i = 0;
        while (i < size - 1) {
            String key = (String)in.readJRObject();
            Object value = in.readJRObject();
            map.put(key, value);
            ++i;
        }
        return map;
    }
}

