/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.metrics;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.hive.common.metrics.MetricsMBean;
import org.apache.hadoop.hive.common.metrics.MetricsMBeanImpl;

public class Metrics {
    static MetricsMBean metrics = new MetricsMBeanImpl();
    static ThreadLocal<HashMap<String, MetricsScope>> threadLocalScopes = new ThreadLocal<HashMap<String, MetricsScope>>(){

        @Override
        protected synchronized HashMap<String, MetricsScope> initialValue() {
            return new HashMap<String, MetricsScope>();
        }
    };
    static boolean initialized = false;
    static Metrics m = new Metrics();

    public static void init() throws Exception {
        if (!initialized) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName oname = new ObjectName("org.apache.hadoop.hive.common.metrics:type=MetricsMBean");
            mbs.registerMBean(metrics, oname);
            initialized = true;
        }
    }

    public static void incrementCounter(String name) throws IOException {
        if (!initialized) {
            return;
        }
        Metrics.incrementCounter(name, 1L);
    }

    public static void incrementCounter(String name, long increment) throws IOException {
        if (!initialized) {
            return;
        }
        if (!metrics.hasKey(name)) {
            Metrics.set(name, increment);
        } else {
            Metrics.set(name, (Long)Metrics.get(name) + increment);
        }
    }

    public static void set(String name, Object value) throws IOException {
        if (!initialized) {
            return;
        }
        metrics.put(name, value);
    }

    public static Object get(String name) throws IOException {
        if (!initialized) {
            return null;
        }
        return metrics.get(name);
    }

    public static MetricsScope startScope(String name) throws IOException {
        if (!initialized) {
            return null;
        }
        if (threadLocalScopes.get().containsKey(name)) {
            threadLocalScopes.get().get(name).open();
        } else {
            Metrics metrics = m;
            metrics.getClass();
            threadLocalScopes.get().put(name, metrics.new MetricsScope(name));
        }
        return threadLocalScopes.get().get(name);
    }

    public static MetricsScope getScope(String name) throws IOException {
        if (!initialized) {
            return null;
        }
        if (threadLocalScopes.get().containsKey(name)) {
            return threadLocalScopes.get().get(name);
        }
        throw new IOException("No metrics scope named " + name);
    }

    public static void endScope(String name) throws IOException {
        if (!initialized) {
            return;
        }
        if (threadLocalScopes.get().containsKey(name)) {
            threadLocalScopes.get().get(name).close();
        }
    }

    public class MetricsScope {
        String name = null;
        boolean isOpen = false;
        Long startTime = null;
        String numCounter = null;
        String timeCounter = null;

        private MetricsScope() {
        }

        MetricsScope(String name) throws IOException {
            this.name = name;
            this.numCounter = name + ".n";
            this.timeCounter = name + ".t";
            this.open();
        }

        public void open() throws IOException {
            if (this.isOpen) {
                throw new IOException("Scope named " + this.name + " is not closed, cannot be opened.");
            }
            Metrics.incrementCounter(this.numCounter);
            this.isOpen = true;
            this.startTime = System.currentTimeMillis();
        }

        public void close() throws IOException {
            if (!this.isOpen) {
                throw new IOException("Scope named " + this.name + " is not open, cannot be closed.");
            }
            Long endTime = System.currentTimeMillis();
            Metrics.incrementCounter(this.timeCounter, endTime - this.startTime);
            this.isOpen = false;
        }

        public void reopen() throws IOException {
            if (this.isOpen) {
                this.close();
            }
            this.open();
        }
    }
}

