/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.Manager;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.SearchPanel;
import org.netbeans.modules.search.SearchScope;
import org.netbeans.modules.search.SearchScopeRegistry;
import org.netbeans.modules.search.SearchTask;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;
import org.openidex.search.SearchType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindInFilesAction
extends CallableSystemAction
implements ContextAwareAction,
ChangeListener {
    static final long serialVersionUID = 4554342565076372611L;
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.search.FindAction_state");
    private static final String VAR_FIRST_ISENABLED = "first call of isEnabled()";
    private static final String VAR_TOOLBAR_COMP_REF = "toolbar presenter ref";
    private static final String VAR_LISTENING = "listening";
    protected static final String REPLACING = "replacing";
    private static final String VAR_LAST_SEARCH_SCOPE_TYPE = "lastScopeType";
    private final String shortClassName;

    public FindInFilesAction() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        this.shortClassName = n != -1 ? string.substring(n + 1) : string;
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.putProperty(VAR_FIRST_ISENABLED, Boolean.TRUE);
        this.putProperty(REPLACING, Boolean.FALSE, false);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        if (this.shouldLog(LOG)) {
            this.log("createContextAwareInstance(lookup)");
        }
        return new LookupSensitive(this, lookup);
    }

    public Action createContextAwareInstance(Lookup lookup, boolean bl) {
        if (this.shouldLog(LOG)) {
            this.log("createContextAwareInstance(lookup, " + bl + ')');
        }
        LookupSensitive lookupSensitive = new LookupSensitive(this, lookup, bl);
        if (this.shouldLog(LOG)) {
            this.log(" -> " + lookupSensitive);
        }
        return lookupSensitive;
    }

    public Component getToolbarPresenter() {
        assert (EventQueue.isDispatchThread());
        if (this.shouldLog(LOG)) {
            this.log("getMenuPresenter()");
        }
        Component component = this.getStoredToolbarPresenter();
        if (this.putProperty(VAR_LISTENING, Boolean.TRUE) == null) {
            SearchScopeRegistry.getDefault().addChangeListener(this);
            this.putProperty(VAR_FIRST_ISENABLED, null);
            this.updateState();
        }
        return component;
    }

    private Component getStoredToolbarPresenter() {
        Object object;
        Object t;
        Object object2;
        assert (EventQueue.isDispatchThread());
        if (this.shouldLog(LOG)) {
            this.log("getStoredToolbarPresenter()");
        }
        if ((object2 = this.getProperty(VAR_TOOLBAR_COMP_REF)) != null && (t = ((Reference)(object = (Reference)object2)).get()) != null) {
            return (Component)t;
        }
        object = super.getToolbarPresenter();
        this.putProperty(VAR_TOOLBAR_COMP_REF, new WeakReference<Object>(object));
        return object;
    }

    private boolean checkToolbarPresenterExists() {
        Object object;
        assert (EventQueue.isDispatchThread());
        if (this.shouldLog(LOG)) {
            this.log("checkToolbarPresenterExists()");
        }
        if ((object = this.getProperty(VAR_TOOLBAR_COMP_REF)) == null) {
            return false;
        }
        return ((Reference)object).get() != null;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        assert (EventQueue.isDispatchThread());
        if (this.shouldLog(LOG)) {
            this.log("stateChanged()");
        }
        if (this.getProperty(VAR_LISTENING) == null) {
            return;
        }
        if (this.checkToolbarPresenterExists()) {
            this.updateState();
        } else {
            SearchScopeRegistry.getDefault().removeChangeListener(this);
            this.putProperty(VAR_LISTENING, null);
            this.putProperty(VAR_TOOLBAR_COMP_REF, null);
        }
    }

    public boolean isEnabled() {
        assert (EventQueue.isDispatchThread());
        if (this.shouldLog(LOG)) {
            this.log("isEnabled()");
        }
        if (this.getProperty(VAR_LISTENING) != null) {
            this.log(" - isListening");
            return super.isEnabled();
        }
        if (this.getProperty(VAR_FIRST_ISENABLED) == null) {
            this.log(" - checking registry");
            return SearchScopeRegistry.getDefault().hasApplicableSearchScope();
        }
        this.log(" - first \"isEnabled()\"");
        this.putProperty(VAR_FIRST_ISENABLED, null);
        return false;
    }

    private void updateState() {
        assert (EventQueue.isDispatchThread());
        if (this.shouldLog(LOG)) {
            this.log("updateState()");
        }
        final boolean bl = SearchScopeRegistry.getDefault().hasApplicableSearchScope();
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                FindInFilesAction.this.setEnabled(bl);
            }
        });
    }

    protected String iconResource() {
        return "org/openide/resources/actions/find.gif";
    }

    public String getName() {
        String string = SearchScopeRegistry.getDefault().hasProjectSearchScopes() ? "LBL_Action_FindInProjects" : "LBL_Action_FindInFiles";
        return NbBundle.getMessage(this.getClass(), (String)string);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(FindInFilesAction.class);
    }

    public void performAction() {
        this.performAction(SearchScopeRegistry.getDefault().getSearchScopes(), this.getLastSearchScope());
    }

    private void performAction(Map<SearchScope, Boolean> map, String string) {
        assert (EventQueue.isDispatchThread());
        String string2 = Manager.getInstance().mayStartSearching();
        if (string2 != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 1));
            return;
        }
        if (!FindInFilesAction.isSomeEnabled(map)) {
            return;
        }
        boolean bl = Boolean.TRUE.equals(this.getProperty(REPLACING));
        SearchPanel searchPanel = new SearchPanel(map, string, bl);
        searchPanel.showDialog();
        if (searchPanel.getReturnStatus() != 1) {
            return;
        }
        SearchScope searchScope = searchPanel.getSearchScope();
        this.storeLastSearchScope(searchScope.getTypeId());
        BasicSearchCriteria basicSearchCriteria = searchPanel.getBasicSearchCriteria();
        List<SearchType> list = searchPanel.getSearchTypes();
        ResultView resultView = ResultView.getInstance();
        resultView.rememberInput(searchScope.getTypeId(), basicSearchCriteria, list);
        resultView.open();
        resultView.requestActive();
        Manager.getInstance().scheduleSearchTask(new SearchTask(searchScope, basicSearchCriteria, searchPanel.getCustomizedSearchTypes()));
    }

    private String getLastSearchScope() {
        Object object = this.getProperty(VAR_LAST_SEARCH_SCOPE_TYPE);
        return object instanceof String ? (String)object : null;
    }

    private void storeLastSearchScope(String string) {
        this.putProperty(VAR_LAST_SEARCH_SCOPE_TYPE, string, false);
    }

    private static boolean isSomeEnabled(Map<SearchScope, Boolean> map) {
        for (Boolean bl : map.values()) {
            if (!bl.booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected boolean asynchronous() {
        return false;
    }

    private boolean shouldLog(Logger logger) {
        return logger.isLoggable(Level.FINER) && this.shortClassName.equals("FindInFilesAction");
    }

    private void log(String string) {
        LOG.finer(this.shortClassName + ": " + string);
    }

    private static final class LookupSensitive
    implements Action,
    ChangeListener,
    Presenter.Menu,
    Presenter.Popup,
    Presenter.Toolbar {
        private static int counter = 0;
        private final FindInFilesAction delegate;
        private final SearchScopeRegistry searchScopeRegistry;
        private final boolean searchSelection;
        private final int id = ++counter;
        private PropertyChangeSupport support;
        private boolean enabled;
        private final String shortClassName;

        LookupSensitive(FindInFilesAction findInFilesAction, Lookup lookup) {
            this(findInFilesAction, lookup, false);
        }

        LookupSensitive(FindInFilesAction findInFilesAction, Lookup lookup, boolean bl) {
            String string = this.getClass().getName();
            int n = string.lastIndexOf(46);
            this.shortClassName = (n != -1 ? string.substring(n + 1) : string).replace('$', '.');
            this.delegate = findInFilesAction;
            this.searchScopeRegistry = SearchScopeRegistry.getInstance(lookup, this.id);
            this.searchSelection = bl;
            this.log("<init>");
        }

        private Object getLock() {
            return this;
        }

        public Object getValue(String string) {
            if (this.shouldLog(LOG)) {
                this.log("getValue(\"" + string + "\")");
            }
            return this.delegate.getValue(string);
        }

        public void putValue(String string, Object object) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            assert (EventQueue.isDispatchThread());
            if (this.shouldLog(LOG)) {
                this.log("actionPerformed(...)");
            }
            this.delegate.performAction(this.searchScopeRegistry.getSearchScopes(), this.searchSelection ? this.searchScopeRegistry.getNodeSelectionSearchScope().getTypeId() : this.delegate.getLastSearchScope());
        }

        public void setEnabled(boolean bl) {
            if (this.shouldLog(LOG)) {
                this.log("setEnabled(" + bl + ')');
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEnabled() {
            assert (EventQueue.isDispatchThread());
            if (this.shouldLog(LOG)) {
                this.log("isEnabled(...)");
            }
            Object object = this.getLock();
            synchronized (object) {
                if (this.support != null) {
                    return this.enabled;
                }
            }
            return this.searchScopeRegistry.hasApplicableSearchScope();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.shouldLog(LOG)) {
                this.log("addPropertyChangeListener(...)");
            }
            if (propertyChangeListener == null) {
                return;
            }
            Object object = this.getLock();
            synchronized (object) {
                if (this.support == null) {
                    this.support = new PropertyChangeSupport(this);
                    this.searchScopeRegistry.addChangeListener(this);
                    this.enabled = this.searchScopeRegistry.hasApplicableSearchScope();
                }
                this.support.addPropertyChangeListener(propertyChangeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.shouldLog(LOG)) {
                this.log("removePropertyChangeListener(...)");
            }
            if (propertyChangeListener == null) {
                return;
            }
            Object object = this.getLock();
            synchronized (object) {
                boolean bl;
                if (this.support == null) {
                    return;
                }
                this.support.removePropertyChangeListener(propertyChangeListener);
                boolean bl2 = bl = !this.support.hasListeners(null);
                if (bl) {
                    this.searchScopeRegistry.removeChangeListener(this);
                    this.support = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent changeEvent) {
            if (this.shouldLog(LOG)) {
                this.log("stateChanged(...)");
            }
            Object object = this.getLock();
            synchronized (object) {
                if (this.support != null) {
                    boolean bl = this.enabled;
                    this.enabled = this.searchScopeRegistry.hasApplicableSearchScope();
                    final PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "enabled", bl, this.enabled);
                    final PropertyChangeListener[] propertyChangeListenerArray = this.support.getPropertyChangeListeners();
                    Mutex.EVENT.writeAccess(new Runnable(){

                        public void run() {
                            for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray) {
                                propertyChangeListener.propertyChange(propertyChangeEvent);
                            }
                        }
                    });
                }
            }
        }

        public JMenuItem getMenuPresenter() {
            if (this.shouldLog(LOG)) {
                this.log("getMenuPresenter(...)");
            }
            return this.delegate.getMenuPresenter();
        }

        public JMenuItem getPopupPresenter() {
            if (this.shouldLog(LOG)) {
                this.log("getPopupPresenter(...)");
            }
            return this.delegate.getPopupPresenter();
        }

        public Component getToolbarPresenter() {
            if (this.shouldLog(LOG)) {
                this.log("getToolbarPresenter(...)");
            }
            return this.delegate.getToolbarPresenter();
        }

        public String toString() {
            return this.shortClassName + " #" + this.id;
        }

        private boolean shouldLog(Logger logger) {
            return logger.isLoggable(Level.FINER) && this.shortClassName.startsWith("FindInFilesAction");
        }

        private void log(String string) {
            LOG.finer(this + ": " + string);
        }
    }
}

