/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.diff;

import java.util.Collections;
import java.util.List;
import org.netbeans.modules.xml.xdm.diff.DiffFinder;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeInfo {
    private Node n;
    private boolean updated = false;
    private final int pos;
    private final List<Node> ancestors1;
    private List<Node> ancestors2;
    private Node parent2;

    public NodeInfo(Node node, int n, List<Node> list, List<Node> list2) {
        if (!(node instanceof Document)) {
            assert (list != null && !list.isEmpty()) : "bad ancestors1";
            assert (list2 != null && !list2.isEmpty()) : "bad ancestors1";
        }
        this.n = node;
        this.pos = n;
        this.ancestors1 = list;
        this.ancestors2 = list2;
    }

    public Node getNode() {
        return this.n;
    }

    void setNode(Node node) {
        if (this.updated) assert (node.getId() == this.n.getId()) : "expect id=" + this.n.getId() + " got id=" + node.getId();
        this.updated = true;
        this.n = node;
    }

    public int getPosition() {
        return this.pos;
    }

    public Node getParent() {
        if (this.ancestors1 != null && this.ancestors1.size() > 0) {
            return this.ancestors1.get(0);
        }
        return null;
    }

    public Document getDocument() {
        return (Document)this.ancestors1.get(this.ancestors1.size() - 1);
    }

    public List<Node> getOriginalAncestors() {
        return Collections.unmodifiableList(this.ancestors1);
    }

    public List<Node> getNewAncestors() {
        if (this.ancestors2 == null) {
            assert (this.parent2 != null) : "expect parent2 is set";
            this.ancestors2 = DiffFinder.getPathToRoot(this.parent2);
        }
        return Collections.unmodifiableList(this.ancestors2);
    }

    public void setNewAncestors(List<Node> list) {
        assert (list != null && !list.isEmpty());
        this.ancestors2 = list;
        this.parent2 = list.get(0);
    }

    public void setNewParent(Node node) {
        assert (node != null && node.isInTree()) : "new parent should be not null and inTree";
        this.ancestors2 = null;
        this.parent2 = node;
    }

    public Node getNewParent() {
        if (this.parent2 == null && !(this.getNode() instanceof Document)) {
            assert (this.ancestors2 != null && this.ancestors2.size() > 0);
            return this.ancestors2.get(0);
        }
        return this.parent2;
    }

    public String toString() {
        int n = this.getParent() == null ? -1 : this.getParent().getId();
        return (Object)((Object)DiffFinder.getNodeType(this.n)) + "." + this.pos + " ids[" + this.n.getId() + "," + n + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeType {
        ELEMENT,
        ATTRIBUTE,
        TEXT,
        WHITE_SPACE;

    }
}

