/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.features.ColorsASTEvaluator;
import org.netbeans.modules.languages.features.ContextASTEvaluator;
import org.netbeans.modules.languages.features.DeclarationASTEvaluator;
import org.netbeans.modules.languages.features.UsagesASTEvaluator;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SemanticHighlightsLayer
extends AbstractHighlightsContainer {
    private static Map<Document, List<WeakReference<SemanticHighlightsLayer>>> cache = new WeakHashMap<Document, List<WeakReference<SemanticHighlightsLayer>>>();
    private Document document;
    private OffsetsBag offsetsBag;
    private OffsetsBag offsetsBag1;
    private Map<String, Set<ASTEvaluator>> evaluators;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void addHighlight(Document document, int n, int n2, AttributeSet attributeSet) {
        List<WeakReference<SemanticHighlightsLayer>> list = cache.get(document);
        ArrayList<WeakReference<SemanticHighlightsLayer>> arrayList = new ArrayList<WeakReference<SemanticHighlightsLayer>>();
        boolean bl = true;
        if (list != null) {
            for (WeakReference<SemanticHighlightsLayer> weakReference : list) {
                SemanticHighlightsLayer semanticHighlightsLayer = (SemanticHighlightsLayer)((Object)weakReference.get());
                if (semanticHighlightsLayer == null) continue;
                bl = false;
                SemanticHighlightsLayer semanticHighlightsLayer2 = semanticHighlightsLayer;
                synchronized (semanticHighlightsLayer2) {
                    if (semanticHighlightsLayer.offsetsBag1 == null) {
                        semanticHighlightsLayer.offsetsBag1 = new OffsetsBag(document);
                    }
                    semanticHighlightsLayer.offsetsBag1.addHighlight(n, n2, attributeSet);
                }
                arrayList.add(weakReference);
            }
        }
        if (bl) {
            cache.remove(document);
            ColorsASTEvaluator.unregister(document);
            DeclarationASTEvaluator.unregister(document);
            ContextASTEvaluator.unregister(document);
            UsagesASTEvaluator.unregister(document);
        } else {
            cache.put(document, arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void update(Document document) {
        List<WeakReference<SemanticHighlightsLayer>> list = cache.get(document);
        boolean bl = true;
        if (list != null) {
            for (WeakReference<SemanticHighlightsLayer> weakReference : list) {
                SemanticHighlightsLayer semanticHighlightsLayer = (SemanticHighlightsLayer)((Object)weakReference.get());
                if (semanticHighlightsLayer == null) continue;
                bl = false;
                SemanticHighlightsLayer semanticHighlightsLayer2 = semanticHighlightsLayer;
                synchronized (semanticHighlightsLayer2) {
                    semanticHighlightsLayer.offsetsBag = semanticHighlightsLayer.offsetsBag1;
                    semanticHighlightsLayer.offsetsBag1 = null;
                    if (semanticHighlightsLayer.offsetsBag == null) {
                        semanticHighlightsLayer.offsetsBag = new OffsetsBag(document);
                    }
                }
                semanticHighlightsLayer.fireHighlightsChange(0, document.getLength());
            }
        }
        if (bl) {
            cache.remove(document);
            ColorsASTEvaluator.unregister(document);
            DeclarationASTEvaluator.unregister(document);
            ContextASTEvaluator.unregister(document);
            UsagesASTEvaluator.unregister(document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SemanticHighlightsLayer(Document document) {
        this.document = document;
        ColorsASTEvaluator.register(document);
        DeclarationASTEvaluator.register(document);
        ContextASTEvaluator.register(document);
        UsagesASTEvaluator.register(document);
        Class<SemanticHighlightsLayer> clazz = SemanticHighlightsLayer.class;
        synchronized (SemanticHighlightsLayer.class) {
            List<WeakReference<SemanticHighlightsLayer>> list = cache.get(document);
            if (list == null) {
                list = new ArrayList<WeakReference<SemanticHighlightsLayer>>();
                cache.put(document, list);
            }
            list.add(new WeakReference<SemanticHighlightsLayer>(this));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public synchronized HighlightsSequence getHighlights(int n, int n2) {
        if (this.offsetsBag == null) {
            this.offsetsBag = new OffsetsBag(this.document);
            this.refresh();
        }
        return this.offsetsBag.getHighlights(n, n2);
    }

    private void refresh() {
        ParserManagerImpl parserManagerImpl = ParserManagerImpl.getImpl(this.document);
        ASTNode aSTNode = parserManagerImpl.getAST();
        if (aSTNode == null) {
            return;
        }
        parserManagerImpl.fire(parserManagerImpl.getState(), null, this.getEvaluators(), aSTNode);
    }

    private Map<String, Set<ASTEvaluator>> getEvaluators() {
        if (this.evaluators == null) {
            ContextASTEvaluator contextASTEvaluator;
            DeclarationASTEvaluator declarationASTEvaluator;
            UsagesASTEvaluator usagesASTEvaluator;
            this.evaluators = new HashMap<String, Set<ASTEvaluator>>();
            ColorsASTEvaluator colorsASTEvaluator = ColorsASTEvaluator.get(this.document);
            if (colorsASTEvaluator != null) {
                this.evaluators.put(colorsASTEvaluator.getFeatureName(), Collections.singleton(colorsASTEvaluator));
            }
            if ((usagesASTEvaluator = UsagesASTEvaluator.get(this.document)) != null) {
                this.evaluators.put(usagesASTEvaluator.getFeatureName(), Collections.singleton(usagesASTEvaluator));
            }
            if ((declarationASTEvaluator = DeclarationASTEvaluator.get(this.document)) != null) {
                this.evaluators.put(declarationASTEvaluator.getFeatureName(), Collections.singleton(declarationASTEvaluator));
            }
            if ((contextASTEvaluator = ContextASTEvaluator.get(this.document)) != null) {
                this.evaluators.put(contextASTEvaluator.getFeatureName(), Collections.singleton(contextASTEvaluator));
            }
        }
        return this.evaluators;
    }
}

