/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.CompletionItem;
import org.netbeans.api.languages.Context;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.ParserManagerListener;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.database.DatabaseContext;
import org.netbeans.api.languages.database.DatabaseDefinition;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.Utils;
import org.netbeans.modules.languages.features.CompletionSupport;
import org.netbeans.modules.languages.features.DatabaseManager;
import org.netbeans.modules.languages.features.FileNotParsedException;
import org.netbeans.modules.languages.features.Index;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionProviderImpl
implements CompletionProvider {
    static final String COMPLETION = "COMPLETION";
    static final String COMPLETION_APPEND = "append";
    static final String COMPLETION_INSERT = "insert";
    static final String COMPLETION_COMPLETE = "complete";

    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        return new CompletionTaskImpl(jTextComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        if (".".equals(string)) {
            Document document = jTextComponent.getDocument();
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            if (document instanceof NbEditorDocument) {
                ((NbEditorDocument)document).readLock();
            }
            try {
                int n = jTextComponent.getCaret().getDot();
                if (n <= 1) {
                    int n2 = 0;
                    return n2;
                }
                List list = tokenHierarchy.embeddedTokenSequences(n -= 2, true);
                if (list.isEmpty()) {
                    int n3 = 0;
                    return n3;
                }
                TokenSequence tokenSequence = (TokenSequence)list.get(list.size() - 1);
                tokenSequence.move(n);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    int n4 = 0;
                    return n4;
                }
                Token token = tokenSequence.token();
                if (token.id().name().indexOf("identifier") > -1) {
                    int n5 = 1;
                    return n5;
                }
            }
            finally {
                if (document instanceof NbEditorDocument) {
                    ((NbEditorDocument)document).readUnlock();
                }
            }
        }
        return 0;
    }

    List<CompletionItem> query(JTextComponent jTextComponent) {
        ListResult listResult = new ListResult();
        CompletionTaskImpl completionTaskImpl = new CompletionTaskImpl(jTextComponent);
        completionTaskImpl.compute(listResult);
        listResult.waitFinished();
        return listResult.getList();
    }

    private static TokenSequence getDeepestTokenSequence(TokenHierarchy tokenHierarchy, int n) {
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        while (tokenSequence != null) {
            tokenSequence.move(n - 1);
            if (!tokenSequence.moveNext()) break;
            TokenSequence tokenSequence2 = tokenSequence.embedded();
            if (tokenSequence2 == null) {
                return tokenSequence;
            }
            tokenSequence = tokenSequence2;
        }
        return tokenSequence;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListResult
    implements Result {
        private List<CompletionItem> result = new ArrayList<CompletionItem>();
        private boolean finished = false;
        private Object LOCK = new Object();

        private ListResult() {
        }

        @Override
        public void addItem(CompletionItem completionItem) {
            this.result.add(completionItem);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish() {
            this.finished = true;
            Object object = this.LOCK;
            synchronized (object) {
                this.LOCK.notify();
            }
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitFinished() {
            if (this.finished) {
                return;
            }
            Object object = this.LOCK;
            synchronized (object) {
                try {
                    this.LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public List<CompletionItem> getList() {
            return this.result;
        }
    }

    private static class CompletionResult
    implements Result {
        private CompletionResultSet resultSet;

        CompletionResult(CompletionResultSet completionResultSet) {
            this.resultSet = completionResultSet;
        }

        public void addItem(CompletionItem completionItem) {
            this.resultSet.addItem(completionItem);
        }

        public void finish() {
            this.resultSet.finish();
        }

        public boolean isFinished() {
            return this.resultSet.isFinished();
        }
    }

    private static interface Result {
        public void addItem(CompletionItem var1);

        public void finish();

        public boolean isFinished();
    }

    private static class CompletionTaskImpl
    implements CompletionTask {
        private JTextComponent component;
        private Document doc;
        private FileObject fileObject;
        private boolean ignoreCase;
        private List<CompletionItem> items = new ArrayList<CompletionItem>();
        private String fileName;

        CompletionTaskImpl(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        public void query(CompletionResultSet completionResultSet) {
            this.compute(new CompletionResult(completionResultSet));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh(CompletionResultSet completionResultSet) {
            if (completionResultSet == null) {
                return;
            }
            this.doc = this.component.getDocument();
            this.fileObject = NbEditorUtilities.getFileObject((Document)this.doc);
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
            if (this.doc instanceof NbEditorDocument) {
                ((NbEditorDocument)this.doc).readLock();
            }
            try {
                Token token;
                int n = this.component.getCaret().getDot();
                TokenSequence tokenSequence = CompletionProviderImpl.getDeepestTokenSequence(tokenHierarchy, n);
                Token token2 = token = tokenSequence != null ? tokenSequence.token() : null;
                if (token != null) {
                    String string = ((Object)token.text()).toString();
                    String string2 = this.getCompletionType(null, token.id().name());
                    int n2 = tokenSequence.offset();
                    string = string2 == null || CompletionProviderImpl.COMPLETION_APPEND.equals(string2) && n < n2 + token.length() ? string.substring(0, n - n2).trim() : (CompletionProviderImpl.COMPLETION_COMPLETE.equals(string2) ? string.substring(0, n - n2).trim() : "");
                    for (CompletionItem completionItem : this.items) {
                        String string3 = ((Object)completionItem.getInsertPrefix()).toString();
                        if (!string3.startsWith(string)) continue;
                        completionResultSet.addItem(completionItem);
                    }
                }
            }
            finally {
                if (this.doc instanceof NbEditorDocument) {
                    ((NbEditorDocument)this.doc).readUnlock();
                }
            }
            completionResultSet.finish();
        }

        public void cancel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void compute(Result result) {
            this.doc = this.component.getDocument();
            this.fileObject = NbEditorUtilities.getFileObject((Document)this.doc);
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
            boolean bl = true;
            if (this.doc instanceof NbEditorDocument) {
                ((NbEditorDocument)this.doc).readLock();
            }
            try {
                int n = this.component.getCaret().getDot();
                TokenSequence tokenSequence = CompletionProviderImpl.getDeepestTokenSequence(tokenHierarchy, this.component.getCaret().getDot());
                if (tokenSequence == null || !tokenSequence.isEmpty() && tokenSequence.offset() > n) {
                    return;
                }
                String string = tokenSequence.language().mimeType();
                Language language = LanguagesManager.getDefault().getLanguage(string);
                if (!tokenSequence.isEmpty()) {
                    this.compute(tokenSequence, n, result, this.doc, language);
                }
                bl = this.addParserTags(result, language);
            }
            catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            }
            finally {
                if (this.doc instanceof NbEditorDocument) {
                    ((NbEditorDocument)this.doc).readUnlock();
                }
            }
            if (bl) {
                result.finish();
            }
        }

        private String getCompletionType(Feature feature, String string) {
            if (feature != null) {
                String string2;
                String string3 = (String)feature.getValue("project_type");
                if (string3 != null) {
                    if (this.fileObject == null) {
                        return null;
                    }
                    if (!Utils.isOfProjectType(this.fileObject, string3)) {
                        return null;
                    }
                }
                if ((string2 = (String)feature.getValue("type")) != null) {
                    return string2;
                }
            }
            if (string == null) {
                return CompletionProviderImpl.COMPLETION_COMPLETE;
            }
            if (string.indexOf("whitespace") >= 0 || string.indexOf("operator") >= 0 || string.indexOf("separator") >= 0) {
                return CompletionProviderImpl.COMPLETION_INSERT;
            }
            if (string.indexOf("comment") >= 0) {
                return CompletionProviderImpl.COMPLETION_APPEND;
            }
            return CompletionProviderImpl.COMPLETION_COMPLETE;
        }

        private void compute(TokenSequence tokenSequence, int n, Result result, Document document, Language language) {
            String string = null;
            Token token = tokenSequence.token();
            string = ((Object)token.text()).toString();
            String string2 = language.getTokenType(token.id().ordinal());
            List<Feature> list = language.getFeatureList().getFeatures(CompletionProviderImpl.COMPLETION, string2);
            for (Feature feature : list) {
                String string3 = this.getCompletionType(feature, token.id().name());
                int n2 = tokenSequence.offset();
                if (string3 == null || CompletionProviderImpl.COMPLETION_APPEND.equals(string3) && n < n2 + token.length()) continue;
                string = CompletionProviderImpl.COMPLETION_COMPLETE.equals(string3) ? string.substring(0, n - n2).trim() : "";
                this.ignoreCase = false;
                Feature feature2 = language.getFeatureList().getFeature("PROPERTIES");
                if (feature2 != null) {
                    this.ignoreCase = feature2.getBoolean("ignoreCase", false);
                }
                if (this.ignoreCase) {
                    string = string.toLowerCase();
                }
                this.addTags(feature, string, Context.create(document, n), result);
            }
        }

        private boolean addParserTags(final Result result, final Language language) {
            final ParserManager parserManager = ParserManager.get(this.doc);
            if (parserManager.getState() == ParserManager.State.PARSING) {
                parserManager.addListener(new ParserManagerListener(){

                    public void parsed(ParserManager.State state, ASTNode aSTNode) {
                        parserManager.removeListener(this);
                        if (result.isFinished()) {
                            return;
                        }
                        CompletionTaskImpl.this.addParserTags(aSTNode, result, language);
                        result.finish();
                    }
                });
                return false;
            }
            this.addParserTags(ParserManagerImpl.getImpl(this.doc).getAST(), result, language);
            return true;
        }

        private void addParserTags(ASTNode aSTNode, Result result, Language language) {
            Object object;
            Object object2;
            Object object32;
            List<Object> list;
            if (aSTNode == null) {
                return;
            }
            int n = this.component.getCaret().getDot();
            ASTPath aSTPath = aSTNode.findPath(n - 1);
            if (aSTPath == null) {
                return;
            }
            ASTItem aSTItem = aSTPath.getLeaf();
            if (aSTItem instanceof ASTNode) {
                return;
            }
            ASTToken aSTToken = (ASTToken)aSTItem;
            if (aSTToken.getLength() != aSTToken.getIdentifier().length()) {
                return;
            }
            int n2 = aSTToken.getOffset();
            for (int i = aSTPath.size() - 1; i >= 0 && (aSTItem = aSTPath.get(i)).getLanguage() != language; --i) {
                list = language.getFeatureList().getFeatures(CompletionProviderImpl.COMPLETION, aSTPath.subPath(i));
                for (Object object32 : list) {
                    object2 = this.getCompletionType((Feature)object32, aSTToken.getTypeName());
                    if (object2 == null || CompletionProviderImpl.COMPLETION_APPEND.equals(object2) && n < n2 + aSTToken.getLength()) continue;
                    String string = CompletionProviderImpl.COMPLETION_COMPLETE.equals(object2) ? aSTToken.getIdentifier().substring(0, n - n2).trim() : "";
                    this.addTags((Feature)object32, string, SyntaxContext.create(this.doc, aSTPath.subPath(i)), result);
                }
            }
            DatabaseContext databaseContext = DatabaseManager.getRoot(aSTNode);
            if (databaseContext == null) {
                return;
            }
            list = databaseContext.getAllVisibleDefinitions(n);
            String string = this.getCompletionType(null, aSTToken.getTypeName());
            object32 = null;
            object32 = string == null || CompletionProviderImpl.COMPLETION_APPEND.equals(string) && n < n2 + aSTToken.getLength() ? aSTToken.getIdentifier().substring(0, n - n2).trim() : (CompletionProviderImpl.COMPLETION_COMPLETE.equals(string) ? aSTToken.getIdentifier().substring(0, n - n2).trim() : "");
            object2 = new HashSet();
            for (Object object4 : list) {
                object2.add(((DatabaseDefinition)object4).getName());
                object = CompletionTaskImpl.createCompletionItem((DatabaseDefinition)object4, this.getFileName(), (String)object32);
                this.items.add((CompletionItem)object);
                if (!((DatabaseDefinition)object4).getName().startsWith((String)object32)) continue;
                result.addItem((CompletionItem)object);
            }
            try {
                if (this.fileObject != null) {
                    Object object4;
                    object4 = language.getMimeType();
                    object = Index.getGlobalItems(this.fileObject, true);
                    for (FileObject fileObject : object.keySet()) {
                        if (!((String)object4).equals(fileObject.getMIMEType())) continue;
                        List list2 = (List)object.get(fileObject);
                        for (DatabaseDefinition databaseDefinition : list2) {
                            if (object2.contains(databaseDefinition.getName())) continue;
                            CompletionSupport completionSupport = CompletionTaskImpl.createCompletionItem(databaseDefinition, fileObject.getNameExt(), (String)object32);
                            this.items.add(completionSupport);
                            if (!databaseDefinition.getName().startsWith((String)object32)) continue;
                            result.addItem(completionSupport);
                        }
                    }
                }
            }
            catch (FileNotParsedException fileNotParsedException) {
                fileNotParsedException.printStackTrace();
            }
        }

        private String getFileName() {
            if (this.fileName == null) {
                this.fileName = (String)this.doc.getProperty("title");
                if (this.fileName == null) {
                    return null;
                }
                int n = this.fileName.lastIndexOf(File.separatorChar);
                if (n > 0) {
                    this.fileName = this.fileName.substring(n + 1);
                }
            }
            return this.fileName;
        }

        private void addTags(Feature feature, String string, Context context, Result result) {
            int n = 1;
            while (true) {
                if (context instanceof SyntaxContext && feature.getType("text" + n) == Feature.Type.STRING && ((SyntaxContext)context).getASTPath().getLeaf() instanceof ASTToken) {
                    ++n;
                    continue;
                }
                Object object = feature.getValue("text" + n, context);
                if (object == null) break;
                if (object instanceof String) {
                    this.addTags((String)object, feature, n, string, result);
                } else {
                    this.addMethodCallTags((List)object, context, result, string);
                }
                ++n;
            }
        }

        private void addMethodCallTags(List list, Context context, Result result, String string) {
            for (Object object : list) {
                String string2;
                if (object instanceof org.netbeans.api.languages.CompletionItem) {
                    object = new CompletionSupport((org.netbeans.api.languages.CompletionItem)object, string);
                }
                CompletionItem completionItem = (CompletionItem)object;
                this.items.add(completionItem);
                CharSequence charSequence = completionItem.getInsertPrefix();
                String string3 = string2 = charSequence instanceof String ? (String)charSequence : ((Object)charSequence).toString();
                if (this.ignoreCase) {
                    string2 = string2.toLowerCase();
                }
                if (!string2.startsWith(string)) continue;
                result.addItem(completionItem);
            }
        }

        private void addTags(String string, Feature feature, int n, String string2, Result result) {
            String string3;
            if (this.ignoreCase) {
                string = string.toLowerCase();
            }
            if ((string3 = (String)feature.getValue("description" + n)) == null) {
                string3 = string;
            }
            String string4 = (String)feature.getValue("icon" + n);
            CompletionSupport completionSupport = new CompletionSupport(string, string2, string3, null, string4, 2);
            this.items.add(completionSupport);
            if (!string.startsWith(string2)) {
                return;
            }
            result.addItem(completionSupport);
        }

        private static CompletionSupport createCompletionItem(DatabaseDefinition databaseDefinition, String string, String string2) {
            CompletionItem.Type type = null;
            if ("local".equals(databaseDefinition.getType())) {
                type = CompletionItem.Type.LOCAL;
            } else if ("parameter".equals(databaseDefinition.getType())) {
                type = CompletionItem.Type.PARAMETER;
            } else if ("field".equals(databaseDefinition.getType())) {
                type = CompletionItem.Type.FIELD;
            } else if ("method".equals(databaseDefinition.getType())) {
                type = CompletionItem.Type.METHOD;
            }
            return new CompletionSupport(new org.netbeans.api.languages.CompletionItem(databaseDefinition.getName(), null, string, type, 100), string2);
        }
    }
}

