/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.editor.ExpObjectCellRenderer;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditorArea;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetParameter;
import net.sf.jasperreports.engine.design.JRDesignExpression;

public class JRDatasetParameterDialog
extends JDialog {
    JRDesignDatasetParameter tmpParameter = null;
    private String oldName = null;
    private Map currentParameters = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private ExpressionEditorArea jRTextExpressionAreaDefaultExpression;
    private JSeparator jSeparator1;
    private int dialogResult;
    public static final int COMPONENT_NONE = 0;
    public static final int COMPONENT_PARAM_NAME = 1;
    public static final int COMPONENT_PARAM_EXPRESSION = 2;

    public JRDatasetParameterDialog(Dialog parent, Map currentParameters, JRDesignDataset dataset) {
        super(parent);
        this.initAll(currentParameters, dataset);
    }

    public JRDatasetParameterDialog(Frame parent, Map currentParameters, JRDesignDataset dataset) {
        super(parent);
        this.initAll(currentParameters, dataset);
    }

    public void initAll(Map currentParameters, JRDesignDataset dataset) {
        this.setModal(true);
        this.initComponents();
        this.currentParameters = currentParameters;
        this.jRTextExpressionAreaDefaultExpression.setText("");
        this.jComboBox1.setModel(new DefaultComboBoxModel<JRParameter>(dataset.getParameters()));
        this.jComboBox1.setRenderer(new ExpObjectCellRenderer());
        this.setLocationRelativeTo(null);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRDatasetParameterDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jRTextExpressionAreaDefaultExpression = new ExpressionEditorArea();
        this.jSeparator1 = new JSeparator();
        this.setTitle("Add/modify parameter");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRDatasetParameterDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRDatasetParameterDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRDatasetParameterDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setPreferredSize(new Dimension(350, 250));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("Dataset parameter name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel2.add((Component)this.jComboBox1, gridBagConstraints);
        this.jLabel3.setText("Value expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jRTextExpressionAreaDefaultExpression.setPreferredSize(new Dimension(300, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanel2.add((Component)this.jRTextExpressionAreaDefaultExpression, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jSeparator1, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.setBounds(0, 0, 320, 220);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        JRParameter param = (JRParameter)this.jComboBox1.getSelectedItem();
        if (param == null) {
            JOptionPane.showMessageDialog(this, I18n.getString("JRDatasetParameterDialog.Message.Warning"), I18n.getString("JRDatasetParameterDialog.Message.Error"), 2);
            return;
        }
        String newName = param.getName();
        if (this.oldName != null && !this.oldName.equals(newName) && this.currentParameters != null && this.currentParameters.containsKey(newName)) {
            JOptionPane.showMessageDialog(this, I18n.getString("JRDatasetParameterDialog.Message.Warning2"), I18n.getString("JRFontPanel.Message.Error2"), 2);
            return;
        }
        this.tmpParameter = new JRDesignDatasetParameter();
        this.tmpParameter.setName(newName);
        JRDesignExpression exp = new JRDesignExpression();
        exp.setText(this.jRTextExpressionAreaDefaultExpression.getText());
        exp.setValueClassName(param.getValueClassName());
        this.tmpParameter.setExpression((JRExpression)exp);
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public JRDesignDatasetParameter getParameter() {
        return this.tmpParameter;
    }

    public void setParameter(JRDesignDatasetParameter tmpParameter) {
        for (int i = 0; i < this.jComboBox1.getItemCount(); ++i) {
            JRParameter p = (JRParameter)this.jComboBox1.getItemAt(i);
            if (!p.getName().equals(tmpParameter.getName())) continue;
            this.jComboBox1.setSelectedItem(p);
            break;
        }
        this.oldName = tmpParameter.getName();
        String text = "";
        if (tmpParameter.getExpression() != null && tmpParameter.getExpression().getText() != null) {
            text = tmpParameter.getExpression().getText();
        }
        this.jRTextExpressionAreaDefaultExpression.setText(text);
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void setFocusedExpression(int expID) {
        try {
            switch (expID) {
                case 2: {
                    Misc.selectTextAndFocusArea(this.jRTextExpressionAreaDefaultExpression);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setExpressionContext(ExpressionContext context) {
        this.jRTextExpressionAreaDefaultExpression.setExpressionContext(context);
    }
}

