/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.ParameterNode;
import com.jaspersoft.ireport.designer.outline.nodes.ParametersNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Mutex;

public class ParametersChildren
extends Index.KeysChildren
implements PropertyChangeListener,
PreferenceChangeListener {
    JasperDesign jd = null;
    private JRDesignDataset dataset = null;
    private Lookup doLkp = null;

    public ParametersChildren(JasperDesign jd, Lookup doLkp) {
        this(jd, jd.getMainDesignDataset(), doLkp);
    }

    public ParametersChildren(JasperDesign jd, JRDesignDataset dataset, Lookup doLkp) {
        super(new ArrayList());
        this.jd = jd;
        this.doLkp = doLkp;
        if (dataset == null) {
            dataset = jd.getMainDesignDataset();
        }
        this.dataset = dataset;
        this.dataset.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        IReportManager.getPreferences().addPreferenceChangeListener(this);
    }

    protected Node[] createNodes(Object key) {
        return new Node[]{new ParameterNode(this.jd, (JRDesignParameter)key, this.doLkp)};
    }

    protected void addNotify() {
        super.addNotify();
        this.recalculateKeys();
    }

    public void recalculateKeys() {
        List l = (List)this.lock();
        l.clear();
        if (IReportManager.getPreferences().getBoolean("filter_parameters", false)) {
            List paramsAll = this.dataset.getParametersList();
            for (int i = 0; i < paramsAll.size(); ++i) {
                JRParameter p = (JRParameter)paramsAll.get(i);
                if (p.isSystemDefined()) continue;
                l.add(p);
            }
        } else {
            l.addAll(this.dataset.getParametersList());
        }
        if (this.getNode() != null && this.getNode() instanceof ParametersNode && ((ParametersNode)this.getNode()).isSort()) {
            Object[] parameters = l.toArray();
            Arrays.sort(parameters, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((JRDesignParameter)o1).getName().compareToIgnoreCase(((JRDesignParameter)o2).getName());
                }
            });
            l.clear();
            l.addAll(Arrays.asList(parameters));
        }
        this.update();
    }

    protected void forceReorder(int[] ints) {
        super.reorder(ints);
        this.update();
    }

    public void reorder() {
        Mutex.Action action = new Mutex.Action(){

            public Object run() {
                Index.Support.showIndexedCustomizer((Index)ParametersChildren.this.getIndex());
                return null;
            }
        };
        MUTEX.writeAccess(action);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("parameters")) {
            this.recalculateKeys();
        }
    }

    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().equals("filter_parameters")) {
            this.recalculateKeys();
        }
    }

    protected void reorder(int[] ints) {
        if (this.getNode() != null && this.getNode() instanceof ParametersNode && ((ParametersNode)this.getNode()).isSort()) {
            return;
        }
        super.reorder(ints);
    }
}

