/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.outline.nodes.CrosstabGroupNode;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.properties.ByteProperty;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabGroup;
import net.sf.jasperreports.crosstabs.type.CrosstabColumnPositionEnum;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrosstabColumnGroupNode
extends CrosstabGroupNode
implements PropertyChangeListener {
    private JRDesignCrosstabColumnGroup group = null;

    public CrosstabColumnGroupNode(JasperDesign jd, JRDesignCrosstab crosstab, JRDesignCrosstabColumnGroup group, Lookup doLkp) {
        super(jd, crosstab, (JRDesignCrosstabGroup)group, doLkp);
        this.group = group;
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/crosstabcolumns-16.png");
    }

    @Override
    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = sheet.get("properties");
        set.put((Node.Property)new PositionProperty(this.group, this.getCrosstab()));
        sheet.put(set);
        return sheet;
    }

    @Override
    public List<JRDesignCrosstabGroup> getGroups() {
        List<JRCrosstabColumnGroup> list = Arrays.asList(this.getCrosstab().getColumnGroups());
        return list;
    }

    @Override
    public int getType() {
        return 2;
    }

    public static final class PositionProperty
    extends ByteProperty {
        private final JRDesignCrosstabColumnGroup group;
        private final JRDesignCrosstab crosstab;

        public PositionProperty(JRDesignCrosstabColumnGroup group, JRDesignCrosstab crosstab) {
            super(group);
            this.setName("position");
            this.setDisplayName("Header Position");
            this.setShortDescription("This property set the position of the content of the group header cell");
            this.crosstab = crosstab;
            this.group = group;
        }

        public List getTagList() {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            tags.add(new Tag(CrosstabColumnPositionEnum.LEFT.getValueByte(), "Left"));
            tags.add(new Tag(CrosstabColumnPositionEnum.CENTER.getValueByte(), "Center"));
            tags.add(new Tag(CrosstabColumnPositionEnum.RIGHT.getValueByte(), "Right"));
            tags.add(new Tag(CrosstabColumnPositionEnum.STRETCH.getValueByte(), "Stretch"));
            return tags;
        }

        public Byte getByte() {
            return this.group.getPositionValue() == null ? null : this.group.getPositionValue().getValueByte();
        }

        public Byte getOwnByte() {
            return this.getByte();
        }

        public Byte getDefaultByte() {
            return null;
        }

        public void setByte(Byte positionType) {
            this.group.setPosition(positionType != null ? CrosstabColumnPositionEnum.getByValue((Byte)positionType) : null);
        }
    }
}

