/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.menu;

import com.jaspersoft.ireport.designer.IReportManager;
import java.io.File;
import java.io.IOException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class OpenReportDirectoryInFavoritesAction
extends NodeAction {
    private static DataFolder getFavoritesFolder() {
        try {
            FileObject fo = FileUtil.createFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot(), (String)"Favorites");
            DataFolder folder = DataFolder.findFolder((FileObject)fo);
            return folder;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot());
        }
    }

    private boolean isInFavorites(FileObject fo) {
        DataFolder f = OpenReportDirectoryInFavoritesAction.getFavoritesFolder();
        DataObject[] arr = f.getChildren();
        for (int i = 0; i < arr.length; ++i) {
            if (!(arr[i] instanceof DataShadow) || !fo.equals(((DataShadow)arr[i]).getOriginal().getPrimaryFile())) continue;
            return true;
        }
        return false;
    }

    protected void performAction(Node[] nodes) {
        try {
            TopComponent win;
            File directory = FileUtil.toFile((FileObject)IReportManager.getInstance().getActiveVisualView().getEditorSupport().getDataObject().getPrimaryFile());
            directory = directory.getParentFile();
            FileObject dirFO = FileUtil.toFileObject((File)directory);
            DataObject dirDO = DataObject.find((FileObject)dirFO);
            if (!this.isInFavorites(dirFO)) {
                DataShadow createdDO = dirDO.createShadow(OpenReportDirectoryInFavoritesAction.getFavoritesFolder());
            }
            if ((win = WindowManager.getDefault().findTopComponent("favorites")) != null) {
                win.open();
                win.requestActive();
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getName() {
        return NbBundle.getMessage(OpenReportDirectoryInFavoritesAction.class, (String)"CTL_OpenReportDirectoryInFavoritesAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodes) {
        return IReportManager.getInstance().getActiveVisualView() != null;
    }
}

