/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import bsh.EvalError;
import bsh.Interpreter;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.sf.jasperreports.charts.design.JRDesignPieDataset;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignEllipse;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignRectangle;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransformElementAction
extends NodeAction {
    public static final int TRANSFORMATION_TYPE_TO_TEXTFIELD = 0;
    public static final int TRANSFORMATION_TYPE_TO_STATICTEXT = 1;
    public static final int TRANSFORMATION_TYPE_TO_RECTANGLE = 2;
    public static final int TRANSFORMATION_TYPE_TO_ELLIPSE = 3;
    public static final int TRANSFORMATION_TYPE_TO_FRAME = 4;
    public static final int TRANSFORMATION_TYPE_TO_CHART_PIE = 5;
    public static final int TRANSFORMATION_TYPE_TO_CHART_PIE3D = 6;
    private JMenu menu = null;
    private List<JMenuItem> transformActions = null;

    public String getName() {
        return I18n.getString("TransformElementAction.name");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
    }

    public void transformElements(ActionEvent e) {
        int transformationType = -1;
        try {
            transformationType = Integer.valueOf(e.getActionCommand());
        }
        catch (Exception ex) {
            return;
        }
        Node[] nodes = this.getActivatedNodes();
        ArrayList<Object> selectedElements = new ArrayList<Object>();
        List<JRDesignElement> selection = IReportManager.getInstance().getActiveVisualView().getReportDesignerPanel().getActiveScene().getSelectionManager().getSelectedElements();
        JRDesignElement primarySelected = selection.size() > 0 ? selection.get(0) : null;
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof ElementNode)) continue;
            ElementNode node = (ElementNode)nodes[i];
            JRDesignElement jRDesignElement = node.getElement();
            JRDesignTextField newElement = null;
            JasperDesign jd = node.getJasperDesign();
            switch (transformationType) {
                case 0: {
                    if (!(jRDesignElement instanceof JRDesignStaticText)) break;
                    newElement = new JRDesignTextField((JRDefaultStyleProvider)jd);
                    this.copyBasicProperties(jRDesignElement, (JRDesignElement)newElement);
                    this.copyTextProperties((JRDesignTextElement)((JRDesignStaticText)jRDesignElement), (JRDesignTextElement)newElement);
                    String s = ((JRDesignStaticText)jRDesignElement).getText();
                    s = Misc.string_replace("\\\\", "\\", s);
                    s = Misc.string_replace("\\\"", "\"", s);
                    s = "\"" + s + "\"";
                    JRDesignExpression exp = Misc.createExpression("java.lang.String", s);
                    newElement.setExpression((JRExpression)exp);
                    break;
                }
                case 1: {
                    if (!(jRDesignElement instanceof JRDesignTextField)) break;
                    newElement = new JRDesignStaticText((JRDefaultStyleProvider)jd);
                    this.copyBasicProperties(jRDesignElement, (JRDesignElement)newElement);
                    this.copyTextProperties((JRDesignTextElement)((JRDesignTextField)jRDesignElement), (JRDesignTextElement)((JRDesignStaticText)newElement));
                    String s = Misc.getExpressionText(((JRDesignTextField)jRDesignElement).getExpression());
                    StringBuffer newString = new StringBuffer();
                    if (s.length() > 0) {
                        block18: for (int index = 0; index < s.length(); ++index) {
                            char c = s.charAt(index);
                            switch (c) {
                                case '\"': {
                                    continue block18;
                                }
                                case '\\': {
                                    if (++index < s.length()) {
                                        char c1 = s.charAt(index);
                                        if (c1 == 'n') {
                                            newString.append('\n');
                                            continue block18;
                                        }
                                        if (c1 == 't') {
                                            newString.append('\t');
                                            continue block18;
                                        }
                                        if (c1 == '\\') {
                                            newString.append('\\');
                                            continue block18;
                                        }
                                        if (c1 == '\"') {
                                            newString.append('\"');
                                            continue block18;
                                        }
                                        if (c1 == 'u') {
                                            if (index + 4 >= s.length() || !this.isOctal(s.charAt(index + 1)) || !this.isOctal(s.charAt(index + 2)) || !this.isOctal(s.charAt(index + 3)) || !this.isOctal(s.charAt(index + 4))) continue block18;
                                            Interpreter interpreter = new Interpreter();
                                            try {
                                                newString.append(interpreter.eval("\"" + s.substring(index - 1, index - 1 + 6) + "\""));
                                            }
                                            catch (EvalError ex) {
                                                ex.printStackTrace();
                                                newString.append(s.substring(index - 1, index - 1 + 6));
                                            }
                                            index += 4;
                                            continue block18;
                                        }
                                        newString.append("\\" + c);
                                        continue block18;
                                    }
                                    newString.append(c);
                                    continue block18;
                                }
                                default: {
                                    newString.append(c);
                                }
                            }
                        }
                    }
                    ((JRDesignStaticText)newElement).setText(newString.toString());
                    break;
                }
                case 3: {
                    if (!(jRDesignElement instanceof JRDesignRectangle)) break;
                    newElement = new JRDesignEllipse((JRDefaultStyleProvider)jd);
                    this.copyBasicProperties(jRDesignElement, (JRDesignElement)newElement);
                    break;
                }
                case 2: {
                    if (!(jRDesignElement instanceof JRDesignEllipse)) break;
                    newElement = new JRDesignRectangle((JRDefaultStyleProvider)jd);
                    this.copyBasicProperties(jRDesignElement, (JRDesignElement)newElement);
                    break;
                }
                case 4: {
                    if (!(jRDesignElement instanceof JRDesignRectangle)) break;
                    newElement = new JRDesignFrame((JRDefaultStyleProvider)jd);
                    this.copyBasicProperties(jRDesignElement, (JRDesignElement)newElement);
                    break;
                }
                case 5: {
                    JRDesignChart chartElement;
                    if (!(jRDesignElement instanceof JRDesignChart) || (chartElement = (JRDesignChart)jRDesignElement).getChartType() != 8) break;
                    newElement = new JRDesignChart((JRDefaultStyleProvider)jd, 9);
                    this.copyBasicProperties(jRDesignElement, (JRDesignElement)newElement);
                    this.copyBasicChartProperties((JRDesignChart)jRDesignElement, (JRDesignChart)newElement);
                    ((JRDesignChart)newElement).setDataset((JRChartDataset)((JRDesignPieDataset)chartElement.getDataset().clone()));
                    break;
                }
                case 6: {
                    JRDesignChart chartElement;
                    if (!(jRDesignElement instanceof JRDesignChart) || (chartElement = (JRDesignChart)jRDesignElement).getChartType() != 9) break;
                    newElement = new JRDesignChart((JRDefaultStyleProvider)jd, 8);
                    this.copyBasicProperties(jRDesignElement, (JRDesignElement)newElement);
                    this.copyBasicChartProperties((JRDesignChart)jRDesignElement, (JRDesignChart)newElement);
                    ((JRDesignChart)newElement).setDataset((JRChartDataset)((JRDesignPieDataset)chartElement.getDataset().clone()));
                }
            }
            if (newElement != null) {
                TransformElementAction.replaceElement(node, newElement);
                selectedElements.add(newElement);
                if (primarySelected != jRDesignElement) continue;
                primarySelected = newElement;
                continue;
            }
            selectedElements.add(jRDesignElement);
        }
        if (selectedElements.size() > 0) {
            boolean first = true;
            if (primarySelected != null && selectedElements.contains(primarySelected)) {
                selectedElements.remove(primarySelected);
                selectedElements.add(0, primarySelected);
            }
            for (JRDesignElement jRDesignElement : selectedElements) {
                if (first) {
                    IReportManager.getInstance().setSelectedObject(jRDesignElement);
                } else {
                    IReportManager.getInstance().addSelectedObject(jRDesignElement);
                }
                first = false;
            }
        }
    }

    public static void replaceElement(ElementNode node, JRDesignElement newElement) {
        JRDesignElement element = node.getElement();
        JRElementGroup container = element.getElementGroup();
        if (container instanceof JRDesignElementGroup) {
            int index = ((JRDesignElementGroup)container).getChildren().indexOf(element);
            ((JRDesignElementGroup)container).getChildren().add(index, newElement);
            newElement.setElementGroup(container);
            ((JRDesignElementGroup)container).removeElement(element);
        } else if (container instanceof JRDesignFrame) {
            int index = ((JRDesignFrame)container).getChildren().indexOf(element);
            ((JRDesignFrame)container).getChildren().set(index, newElement);
            newElement.setElementGroup(container);
            ((JRDesignFrame)container).removeElement((JRElement)element);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        this.getMenu().setEnabled(false);
        if (activatedNodes == null || activatedNodes.length < 1) {
            return false;
        }
        List<Integer> commonTransformationTypes = this.getTransformationTypes(activatedNodes);
        if (commonTransformationTypes == null || commonTransformationTypes.size() == 0) {
            return false;
        }
        this.rebuildMenu(commonTransformationTypes);
        this.getMenu().setEnabled(true);
        return true;
    }

    private JRExpression cloneExpression(JRExpression expression) {
        if (expression != null) {
            return (JRExpression)expression.clone();
        }
        return null;
    }

    private void copyBasicChartProperties(JRDesignChart element, JRDesignChart newElement) {
        newElement.setAnchorNameExpression(element.getAnchorNameExpression());
        newElement.setBookmarkLevel(element.getBookmarkLevel());
        newElement.setCustomizerClass(element.getCustomizerClass());
        newElement.setEvaluationGroup(element.getEvaluationGroup());
        newElement.setEvaluationTime(element.getEvaluationTimeValue());
        newElement.setHyperlinkAnchorExpression(this.cloneExpression(element.getHyperlinkAnchorExpression()));
        newElement.setHyperlinkWhenExpression(this.cloneExpression(element.getHyperlinkWhenExpression()));
        newElement.setHyperlinkPageExpression(this.cloneExpression(element.getHyperlinkPageExpression()));
        newElement.setHyperlinkReferenceExpression(this.cloneExpression(element.getHyperlinkReferenceExpression()));
        newElement.setHyperlinkTarget(element.getHyperlinkTarget());
        newElement.setLinkTarget(element.getLinkTarget());
        newElement.setHyperlinkTooltipExpression(this.cloneExpression(element.getHyperlinkTooltipExpression()));
        newElement.setHyperlinkType(element.getHyperlinkType());
        newElement.setLegendBackgroundColor(element.getOwnLegendBackgroundColor());
        newElement.setLegendColor(element.getOwnLegendColor());
        newElement.setLegendFont(element.getLegendFont());
        newElement.setLegendPosition(element.getLegendPositionValue());
        newElement.setLinkTarget(element.getLinkTarget());
        newElement.setLinkType(element.getLinkType());
        newElement.setRenderType(element.getRenderType());
        newElement.setShowLegend(element.getShowLegend());
        newElement.setSubtitleColor(element.getOwnSubtitleColor());
        newElement.setSubtitleExpression(this.cloneExpression(element.getSubtitleExpression()));
        newElement.setSubtitleFont(element.getSubtitleFont());
        newElement.setTheme(element.getTheme());
        newElement.setTitleFont(element.getTitleFont());
        newElement.setTitlePosition(element.getTitlePositionValue());
        newElement.setTitleColor(element.getOwnTitleColor());
        newElement.setTitleExpression(this.cloneExpression(element.getTitleExpression()));
        newElement.getPlot().setBackcolor(element.getPlot().getOwnBackcolor());
        newElement.getPlot().setBackgroundAlpha(element.getPlot().getBackgroundAlphaFloat());
        newElement.getPlot().setForegroundAlpha(element.getPlot().getForegroundAlphaFloat());
        newElement.getPlot().setLabelRotation(element.getPlot().getLabelRotationDouble());
        newElement.getPlot().setOrientation(element.getPlot().getOrientation());
        newElement.getPlot().setSeriesColors((Collection)element.getPlot().getSeriesColors());
    }

    private void copyBasicProperties(JRDesignElement element, JRDesignElement newElement) {
        newElement.setX(element.getX());
        newElement.setY(element.getY());
        newElement.setWidth(element.getWidth());
        newElement.setHeight(element.getHeight());
        newElement.setBackcolor(element.getOwnBackcolor());
        newElement.setForecolor(element.getOwnForecolor());
        newElement.setKey(element.getKey());
        newElement.setMode(element.getOwnModeValue());
        newElement.setPositionType(element.getPositionTypeValue());
        newElement.setPrintWhenDetailOverflows(element.isPrintWhenDetailOverflows());
        newElement.setPrintWhenExpression(this.cloneExpression(element.getPrintWhenExpression()));
        newElement.setPrintRepeatedValues(element.isPrintRepeatedValues());
        newElement.setPrintInFirstWholeBand(element.isPrintInFirstWholeBand());
        newElement.setPrintWhenGroupChanges(element.getPrintWhenGroupChanges());
        newElement.setRemoveLineWhenBlank(element.isRemoveLineWhenBlank());
        newElement.setStretchType(element.getStretchTypeValue());
        newElement.setStyle(element.getStyle());
        newElement.setStyleNameReference(element.getStyleNameReference());
    }

    private void copyTextProperties(JRDesignTextElement element, JRDesignTextElement newElement) {
        newElement.setBold(element.isOwnBold());
        newElement.setItalic(element.isOwnItalic());
        newElement.setFontName(element.getOwnFontName());
        newElement.setFontSize(element.getOwnFontSize());
        newElement.setHorizontalAlignment(element.getOwnHorizontalAlignmentValue());
        newElement.setLineSpacing(element.getOwnLineSpacingValue());
        newElement.setMarkup(element.getMarkup());
        newElement.setPdfEmbedded(element.isOwnPdfEmbedded());
        newElement.setPdfEncoding(element.getOwnPdfEncoding());
        newElement.setPdfFontName(element.getOwnPdfFontName());
        newElement.setRotation(element.getOwnRotationValue());
        newElement.setStrikeThrough(element.isOwnStrikeThrough());
        newElement.setVerticalAlignment(element.getOwnVerticalAlignmentValue());
        newElement.setUnderline(element.isOwnUnderline());
    }

    private List<Integer> getTransformationTypes(Node[] activatedNodes) {
        List<Integer> commonTransformationTypes = null;
        for (int i = 0; i < activatedNodes.length; ++i) {
            if (!(activatedNodes[i] instanceof ElementNode)) {
                return commonTransformationTypes;
            }
            if (commonTransformationTypes == null) {
                commonTransformationTypes = this.getTransformationTypes(((ElementNode)activatedNodes[i]).getElement());
            } else {
                List<Integer> thisSet = this.getTransformationTypes(((ElementNode)activatedNodes[i]).getElement());
                commonTransformationTypes.retainAll(thisSet);
            }
            if (commonTransformationTypes.size() != 0) continue;
            return commonTransformationTypes;
        }
        return commonTransformationTypes;
    }

    private List<Integer> getTransformationTypes(JRDesignElement element) {
        ArrayList<Integer> commonTransformationTypes = new ArrayList<Integer>();
        if (element instanceof JRDesignRectangle) {
            commonTransformationTypes.add(3);
            commonTransformationTypes.add(4);
        }
        if (element instanceof JRDesignEllipse) {
            commonTransformationTypes.add(2);
        }
        if (element instanceof JRDesignTextField) {
            commonTransformationTypes.add(1);
        }
        if (element instanceof JRDesignStaticText) {
            commonTransformationTypes.add(0);
        }
        if (element instanceof JRDesignChart) {
            JRDesignChart chartElement = (JRDesignChart)element;
            if (chartElement.getChartType() == 9) {
                commonTransformationTypes.add(6);
            } else if (chartElement.getChartType() == 8) {
                commonTransformationTypes.add(5);
            }
        }
        return commonTransformationTypes;
    }

    public JMenuItem getMenuPresenter() {
        return this.getMenu();
    }

    public JMenuItem getPopupPresenter() {
        return this.getMenu();
    }

    public JMenu getMenu() {
        if (this.menu == null) {
            this.menu = new JMenu(this.getName());
        }
        return this.menu;
    }

    public void setMenu(JMenu menu) {
        this.menu = menu;
    }

    private void rebuildMenu(List<Integer> commonTransformationTypes) {
        this.getMenu().removeAll();
        for (Integer k : commonTransformationTypes) {
            this.getMenu().add(this.getTransformActions().get(k));
        }
    }

    private List<JMenuItem> getTransformActions() {
        if (this.transformActions == null) {
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransformElementAction.this.transformElements(e);
                }
            };
            this.transformActions = new ArrayList<JMenuItem>();
            JMenuItem itemTextfield = new JMenuItem();
            itemTextfield.setText(I18n.getString("TextField_Name"));
            itemTextfield.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/jaspersoft/ireport/designer/resources/textfield-16.png")));
            itemTextfield.setActionCommand("0");
            itemTextfield.addActionListener(listener);
            this.transformActions.add(itemTextfield);
            JMenuItem itemStaticText = new JMenuItem();
            itemStaticText.setText(I18n.getString("StaticText_Name"));
            itemStaticText.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/jaspersoft/ireport/designer/resources/statictext-16.png")));
            itemStaticText.setActionCommand("1");
            itemStaticText.addActionListener(listener);
            this.transformActions.add(itemStaticText);
            JMenuItem itemRectangle = new JMenuItem();
            itemRectangle.setText(I18n.getString("Rectangle_Name"));
            itemRectangle.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/jaspersoft/ireport/designer/resources/rectangle-16.png")));
            itemRectangle.setActionCommand("2");
            itemRectangle.addActionListener(listener);
            this.transformActions.add(itemRectangle);
            JMenuItem itemEllipse = new JMenuItem();
            itemEllipse.setText(I18n.getString("Ellipse_Name"));
            itemEllipse.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/jaspersoft/ireport/designer/resources/ellipse-16.png")));
            itemEllipse.setActionCommand("3");
            itemEllipse.addActionListener(listener);
            this.transformActions.add(itemEllipse);
            JMenuItem itemFrame = new JMenuItem();
            itemFrame.setText(I18n.getString("Frame_Name"));
            itemFrame.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/jaspersoft/ireport/designer/resources/frame-16.png")));
            itemFrame.setActionCommand("4");
            itemFrame.addActionListener(listener);
            this.transformActions.add(itemFrame);
            JMenuItem itemChartPie = new JMenuItem();
            itemChartPie.setText(I18n.getString("ChartSelectionJDialog.Chart.Pie"));
            itemChartPie.setToolTipText(I18n.getString("ChartSelectionJDialog.Chart.Pie"));
            itemChartPie.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/jaspersoft/ireport/designer/charts/icons/pie.png")));
            itemChartPie.setActionCommand("5");
            itemChartPie.addActionListener(listener);
            this.transformActions.add(itemChartPie);
            JMenuItem itemChartPie3d = new JMenuItem();
            itemChartPie3d.setText(I18n.getString("ChartSelectionJDialog.Chart.Pie3D"));
            itemChartPie3d.setToolTipText(I18n.getString("ChartSelectionJDialog.Chart.Pie3D"));
            itemChartPie3d.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/jaspersoft/ireport/designer/charts/icons/pie3d.png")));
            itemChartPie3d.setActionCommand("6");
            itemChartPie3d.addActionListener(listener);
            this.transformActions.add(itemChartPie3d);
        }
        return this.transformActions;
    }

    private boolean isOctal(char c) {
        return (c = Character.toLowerCase(c)) == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9' || c == 'a' || c == 'b' || c == 'c' || c == 'd' || c == 'e' || c == 'f';
    }
}

