/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.widgets.SelectionWidget;
import java.awt.Point;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.Widget;

public class SelectAction
extends WidgetAction.LockedAdapter {
    private boolean aiming = false;
    private Widget aimedWidget = null;
    private boolean invertSelection;
    private SelectProvider provider;
    private boolean rightButton = false;

    public SelectAction(SelectProvider provider) {
        this.provider = provider;
    }

    protected boolean isLocked() {
        return this.aiming;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (this.isLocked()) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }
        if (event.getButton() == 1 || event.getButton() == 3) {
            this.rightButton = event.getButton() == 3;
            widget.getScene().getView().requestFocus();
            this.invertSelection = (event.getModifiersEx() & 0x80) != 0;
            Point localLocation = event.getPoint();
            if (this.provider.isSelectionAllowed(widget, localLocation, this.invertSelection)) {
                this.aiming = this.provider.isAimingAllowed(widget, localLocation, this.invertSelection);
                if (this.aiming) {
                    this.updateState(widget, localLocation);
                    return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
                }
                this.provider.select(widget, localLocation, this.invertSelection);
                Object object = null;
                object = widget instanceof SelectionWidget ? ((ObjectScene)widget.getScene()).findObject((Widget)((SelectionWidget)widget).getRealWidget()) : ((ObjectScene)widget.getScene()).findObject(widget);
                if (!((ObjectScene)widget.getScene()).getSelectedObjects().contains(object)) {
                    return WidgetAction.State.CONSUMED;
                }
                return WidgetAction.State.CHAIN_ONLY;
            }
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseReleased(final Widget widget, final WidgetAction.WidgetMouseEvent event) {
        if (this.aiming) {
            Point point = event.getPoint();
            this.updateState(widget, point);
            if (this.aimedWidget != null) {
                this.provider.select(widget, point, this.invertSelection);
            }
            this.updateState(null, null);
            this.aiming = false;
            if (event.getButton() == 3 && this.rightButton) {
                List actions = widget.getActions().getActions();
                for (final WidgetAction action : actions) {
                    if (!action.getClass().getName().contains("PopupMenuAction")) continue;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            action.mousePressed(widget, event);
                            action.mouseReleased(widget, event);
                        }
                    });
                    break;
                }
            }
            return WidgetAction.State.CONSUMED;
        }
        return super.mouseReleased(widget, event);
    }

    private void updateState(Widget widget, Point localLocation) {
        if (widget != null && !widget.isHitAt(localLocation)) {
            widget = null;
        }
        if (widget == this.aimedWidget) {
            return;
        }
        if (this.aimedWidget != null) {
            this.aimedWidget.setState(this.aimedWidget.getState().deriveWidgetAimed(false));
        }
        this.aimedWidget = widget;
        if (this.aimedWidget != null) {
            this.aimedWidget.setState(this.aimedWidget.getState().deriveWidgetAimed(true));
        }
    }

    public WidgetAction.State keyTyped(Widget widget, WidgetAction.WidgetKeyEvent event) {
        if (!this.aiming && event.getKeyChar() == ' ') {
            this.provider.select(widget, null, (event.getModifiersEx() & 0x80) != 0);
            return WidgetAction.State.CONSUMED;
        }
        return WidgetAction.State.REJECTED;
    }
}

