/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlEditorSupport;
import com.jaspersoft.ireport.designer.SubreportOpenerProvider;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.io.File;
import java.util.Collection;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;
import org.openide.util.lookup.Lookups;

public final class OpenSubreportAction
extends NodeAction {
    public String getName() {
        return "Open Subreport";
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void subreportNotFound(String msg) {
        JOptionPane.showMessageDialog(Misc.getMainFrame(), "Unable to open the subreport:\n" + msg);
    }

    protected void performAction(Node[] activatedNodes) {
        JasperDesign jasperDesign = ((ElementNode)activatedNodes[0]).getJasperDesign();
        JRDesignSubreport subreport = (JRDesignSubreport)((ElementNode)activatedNodes[0]).getElement();
        try {
            JrxmlEditorSupport es = IReportManager.getInstance().getActiveVisualView().getEditorSupport();
            File fileToOpen = Misc.locateFileFromExpression(jasperDesign, null, (JRDesignExpression)subreport.getExpression(), null, ".jrxml", null);
            fileToOpen = this.notifySubreportProviders(es, subreport, fileToOpen);
            this.openFile(fileToOpen);
        }
        catch (Exception ex) {
            this.subreportNotFound(ex.getMessage());
        }
    }

    protected File notifySubreportProviders(JrxmlEditorSupport ed, JRDesignSubreport subreportElement, File file) {
        Lookup lookup = Lookups.forPath((String)"ireport/SubreportOpenerProviders");
        Collection subreportProviders = lookup.lookupAll(SubreportOpenerProvider.class);
        for (SubreportOpenerProvider subreportOpenerProvider : subreportProviders) {
            try {
                File f = subreportOpenerProvider.openingSubreport(ed, subreportElement, file);
                if (f == null) continue;
                file = f;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return file;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        return activatedNodes[0] instanceof ElementNode && ((ElementNode)activatedNodes[0]).getElement() instanceof JRDesignSubreport;
    }

    private void openFile(File f) throws Exception {
        FileObject fl = FileUtil.toFileObject((File)(f = FileUtil.normalizeFile((File)f)));
        if (fl == null) {
            throw new Exception("Unable to open the file " + f);
        }
        DataObject obj = DataObject.find((FileObject)fl);
        OpenCookie ocookie = (OpenCookie)obj.getCookie(OpenCookie.class);
        if (ocookie != null) {
            ocookie.open();
        }
    }
}

