/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.actions.ReportAlignWithMoveStrategyProvider;
import java.awt.Point;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;

public class ExMoveAction
extends WidgetAction.LockedAdapter {
    private int modifiers = 0;
    private int modifiersEx = 0;
    private MoveStrategy strategy;
    private MoveProvider provider;
    private Widget movingWidget = null;
    private Point dragSceneLocation = null;
    private Point originalSceneLocation = null;
    private Point initialMouseLocation = null;

    public ExMoveAction(MoveStrategy strategy, MoveProvider provider) {
        this.strategy = strategy;
        this.provider = provider;
    }

    protected boolean isLocked() {
        return this.movingWidget != null;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (this.isLocked()) {
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }
        if (event.getButton() == 1 && event.getClickCount() == 1) {
            this.movingWidget = widget;
            this.initialMouseLocation = event.getPoint();
            this.setModifiers(event.getModifiers());
            this.setModifiersEx(event.getModifiersEx());
            this.originalSceneLocation = this.provider.getOriginalLocation(widget);
            if (this.originalSceneLocation == null) {
                this.originalSceneLocation = new Point();
            }
            this.dragSceneLocation = widget.convertLocalToScene(event.getPoint());
            this.provider.movementStarted(widget);
            if (this.provider instanceof ReportAlignWithMoveStrategyProvider) {
                ((ReportAlignWithMoveStrategyProvider)this.provider).setAction(this);
            }
            return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
        this.setModifiers(event.getModifiers());
        this.setModifiersEx(event.getModifiersEx());
        boolean state = this.initialMouseLocation != null && this.initialMouseLocation.equals(event.getPoint()) ? true : this.move(widget, event.getPoint());
        if (state) {
            this.movingWidget = null;
            this.dragSceneLocation = null;
            this.originalSceneLocation = null;
            this.initialMouseLocation = null;
            this.provider.movementFinished(widget);
        }
        return state ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent event) {
        this.setModifiers(event.getModifiers());
        this.setModifiersEx(event.getModifiersEx());
        return this.move(widget, event.getPoint()) ? WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this) : WidgetAction.State.REJECTED;
    }

    private boolean move(Widget widget, Point newLocation) {
        if (this.movingWidget != widget) {
            return false;
        }
        this.initialMouseLocation = null;
        newLocation = widget.convertLocalToScene(newLocation);
        Point location = new Point(this.originalSceneLocation.x + newLocation.x - this.dragSceneLocation.x, this.originalSceneLocation.y + newLocation.y - this.dragSceneLocation.y);
        this.provider.setNewLocation(widget, this.strategy.locationSuggested(widget, this.originalSceneLocation, location));
        return true;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public int getModifiersEx() {
        return this.modifiersEx;
    }

    public void setModifiersEx(int modifiersEx) {
        this.modifiersEx = modifiersEx;
    }
}

