/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.security.AllPermission;
import java.security.PermissionCollection;
import java.security.Permissions;
import org.netbeans.api.java.classpath.ClassPath;
import org.openide.execution.NbClassLoader;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

class ClassLoaderSupport
extends NbClassLoader
implements FileChangeListener,
PropertyChangeListener {
    private FileChangeListener listener;
    private PropertyChangeListener propListener;
    private static PermissionCollection allPermission;
    private static boolean firstTime;
    private ClassPath classPath;

    public static ClassLoader create(ClassPath classPath) {
        return ClassLoaderSupport.create(classPath, ClassLoader.getSystemClassLoader());
    }

    static ClassLoader create(ClassPath classPath, ClassLoader classLoader) {
        try {
            return new ClassLoaderSupport(classPath, classLoader);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            throw new AssertionError((Object)fileStateInvalidException);
        }
    }

    private ClassLoaderSupport(ClassPath classPath, ClassLoader classLoader) throws FileStateInvalidException {
        super(classPath.getRoots(), classLoader, null);
        this.classPath = classPath;
        this.setDefaultPermissions(ClassLoaderSupport.getAllPermissions());
        this.listener = FileUtil.weakFileChangeListener((FileChangeListener)this, null);
        this.propListener = WeakListeners.propertyChange((PropertyChangeListener)this, null);
        classPath.addPropertyChangeListener(this.propListener);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        String string2;
        FileObject fileObject;
        Class clazz = super.findClass(string);
        if (clazz != null && (fileObject = this.classPath.findResource(string2 = string.replace('.', '/') + ".class")) != null) {
            fileObject.addFileChangeListener(this.listener);
        }
        return clazz;
    }

    public URL findResource(String string) {
        FileObject fileObject;
        URL uRL = super.findResource(string);
        if (uRL != null && (fileObject = this.classPath.findResource(string)) != null) {
            fileObject.addFileChangeListener(this.listener);
        }
        return uRL;
    }

    private void test(FileObject fileObject) {
        this.classPath.resetClassLoader((ClassLoader)((Object)this));
        fileObject.removeFileChangeListener(this.listener);
    }

    private void reset() {
        this.classPath.resetClassLoader((ClassLoader)((Object)this));
    }

    private void testRemove(FileObject fileObject) {
        fileObject.removeFileChangeListener(this.listener);
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        this.testRemove(fileEvent.getFile());
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.testRemove(fileEvent.getFile());
    }

    public void fileChanged(FileEvent fileEvent) {
        this.test(fileEvent.getFile());
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.test(fileEvent.getFile());
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.test(fileRenameEvent.getFile());
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        this.testRemove(fileAttributeEvent.getFile());
    }

    static synchronized PermissionCollection getAllPermissions() {
        if (allPermission == null) {
            allPermission = new Permissions();
            allPermission.add(new AllPermission());
        }
        return allPermission;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("roots".equals(propertyChangeEvent.getPropertyName())) {
            this.reset();
        }
    }

    static {
        firstTime = true;
    }
}

