/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.highlighting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.openide.util.TopologicalSortException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZOrder {
    private static final Logger LOG = Logger.getLogger(ZOrder.class.getName());
    public static final ZOrder TOP_RACK = new ZOrder(50, 0);
    public static final ZOrder SHOW_OFF_RACK = new ZOrder(40, 0);
    public static final ZOrder DEFAULT_RACK = new ZOrder(30, 0);
    public static final ZOrder CARET_RACK = new ZOrder(20, 0);
    public static final ZOrder SYNTAX_RACK = new ZOrder(10, 0);
    public static final ZOrder BOTTOM_RACK = new ZOrder(0, 0);
    private static final Comparator<HighlightsLayer> COMPARATOR = new Comparator<HighlightsLayer>(){

        @Override
        public int compare(HighlightsLayer highlightsLayer, HighlightsLayer highlightsLayer2) {
            ZOrder zOrder = highlightsLayer.getZOrder();
            ZOrder zOrder2 = highlightsLayer2.getZOrder();
            if (zOrder.rack == zOrder2.rack) {
                return zOrder.position - zOrder2.position;
            }
            return zOrder.rack - zOrder2.rack;
        }
    };
    private final int rack;
    private final int position;

    static HighlightsLayer[] sort(HighlightsLayer[] highlightsLayerArray) throws TopologicalSortException {
        List<? extends HighlightsLayer> list = ZOrder.sort(Arrays.asList(highlightsLayerArray));
        return list.toArray(new HighlightsLayer[list.size()]);
    }

    int getRack() {
        return this.rack;
    }

    static List<? extends HighlightsLayer> sort(Collection<? extends HighlightsLayer> collection) throws TopologicalSortException {
        ArrayList<? extends HighlightsLayer> arrayList = new ArrayList<HighlightsLayer>(collection);
        Collections.sort(arrayList, COMPARATOR);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Sorted layer Ids: ");
            for (HighlightsLayer highlightsLayer : arrayList) {
                LOG.finest("    " + highlightsLayer.getLayerTypeId());
            }
            LOG.finest("End of Sorted layer Ids: -----------------------");
        }
        return arrayList;
    }

    private ZOrder(int n, int n2) {
        this.rack = n;
        this.position = n2;
    }

    public ZOrder forPosition(int n) {
        return new ZOrder(this.rack, n);
    }

    public String toString() {
        String string = "Unknown_rack";
        switch (this.rack) {
            case 0: {
                string = "BOTTOM_RACK";
                break;
            }
            case 10: {
                string = "SYNTAX_RACK";
                break;
            }
            case 20: {
                string = "CARET_RACK";
                break;
            }
            case 30: {
                string = "DEFAULT_RACK";
                break;
            }
            case 40: {
                string = "SHOW_OFF_RACK";
                break;
            }
            case 50: {
                string = "TOP_RACK";
            }
        }
        return string + "(" + this.position + ")";
    }
}

