/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.settings.storage.SettingsType;
import org.netbeans.modules.editor.settings.storage.StorageImpl;
import org.netbeans.modules.editor.settings.storage.spi.StorageDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditorSettingsStorage<K, V> {
    public static final String PROP_DATA = "EditorSettingsStorage.PROP_DATA";
    private static final Map<StorageDescription<?, ?>, EditorSettingsStorage> cache = new HashMap();
    private final PropertyChangeSupport PCS = new PropertyChangeSupport(this);
    private final StorageImpl<K, V> storageImpl;

    public static <K, V> EditorSettingsStorage<K, V> get(String string) {
        EditorSettingsStorage<K, V> editorSettingsStorage = EditorSettingsStorage.find(string);
        assert (editorSettingsStorage != null) : "Invalid settings type Id: '" + string + "'";
        return editorSettingsStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> EditorSettingsStorage<K, V> find(String string) {
        Map<StorageDescription<?, ?>, EditorSettingsStorage> map = cache;
        synchronized (map) {
            EditorSettingsStorage editorSettingsStorage = null;
            StorageDescription storageDescription = SettingsType.find(string);
            if (storageDescription != null && (editorSettingsStorage = cache.get(storageDescription)) == null) {
                editorSettingsStorage = new EditorSettingsStorage(storageDescription);
                cache.put(storageDescription, editorSettingsStorage);
            }
            return editorSettingsStorage;
        }
    }

    public Map<K, V> load(MimePath mimePath, String string, boolean bl) throws IOException {
        return this.storageImpl.load(mimePath, string, bl);
    }

    public void save(MimePath mimePath, String string, boolean bl, Map<K, V> map) throws IOException {
        this.storageImpl.save(mimePath, string, bl, map);
    }

    public void delete(MimePath mimePath, String string, boolean bl) throws IOException {
        this.storageImpl.delete(mimePath, string, bl);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.PCS.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.PCS.removePropertyChangeListener(propertyChangeListener);
    }

    private EditorSettingsStorage(StorageDescription<K, V> storageDescription) {
        this.storageImpl = new StorageImpl<K, V>(storageDescription, new Callable<Void>(){

            @Override
            public Void call() {
                EditorSettingsStorage.this.PCS.firePropertyChange(EditorSettingsStorage.PROP_DATA, null, null);
                return null;
            }
        });
    }
}

