/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor.mdxbuilder.nodes;

import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.mdxeditor.mdxbuilder.dnd.TransferableMdxBuilderTreeNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.DefaultMBTNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgSetNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTFunctionNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTMembersNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTPopUpActions;
import rex.graphics.mdxeditor.mdxfunctions.MdxFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxSetFunction;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;

public class DefaultMBTAxisNode
extends DefaultMBTNode
implements Serializable,
LanguageChangedListener {
    private String axisCaption;
    private boolean nonEmpty;
    private static String childrenIndent = "  ";
    static ImageIcon icon = S.getAppIcon("MBTAxisNode.gif");

    public DefaultMBTAxisNode(String _axisCaption, boolean _nonEmpty) {
        I18n.addOnLanguageChangedListener(this);
        this.axisCaption = _axisCaption;
        this.nonEmpty = _nonEmpty;
    }

    @Override
    public String getMdx(String indent) {
        if (this.getChildren() == null) {
            return "";
        }
        StringBuffer mdx = new StringBuffer("");
        for (int i = 0; i < this.getChildren().size(); ++i) {
            if (mdx.length() == 0) {
                mdx.append("\n" + this.getChild(i).getMdx(indent + childrenIndent));
                continue;
            }
            mdx.append("\n" + this.addCommaAfterBlanks(this.getChild(i).getMdx(indent + childrenIndent)));
        }
        if (this.nonEmpty) {
            return indent + "NON EMPTY {" + "\n" + mdx + "\n" + indent + "} ON " + this.axisCaption;
        }
        return indent + "{" + "\n" + mdx + "\n" + indent + "} ON " + this.axisCaption;
    }

    @Override
    public String toString() {
        return this.axisCaption;
    }

    @Override
    void setAcceptableFlavorsArray() {
        this.acceptableFlavorsMimeTypes = new String[]{TransferableMdxBuilderTreeNode.DIMENSION_TREE_NODE_LEVEL_FLAVOR_STRING, TransferableMdxBuilderTreeNode.DIMENSION_TREE_NODE_DIMENSION_FLAVOR_STRING, TransferableMdxBuilderTreeNode.DIMENSION_TREE_NODE_HIERARCHY_FLAVOR_STRING, TransferableMdxBuilderTreeNode.DIMENSION_TREE_NODE_MEASURE_FLAVOR_STRING, TransferableMdxBuilderTreeNode.DIMENSION_TREE_NODE_MEMBER_FLAVOR_STRING, TransferableMdxBuilderTreeNode.MDX_BUILDER_TREE_SET_FUNCTION_NODE_FLAVOR_STRING, TransferableMdxBuilderTreeNode.MDX_BUILDER_TREE_CALCULATED_MEMBER_NODE_FLAVOR_STRING, TransferableMdxBuilderTreeNode.MDX_BUILDER_TREE_NAMED_SET_NODE_FLAVOR_STRING, TransferableMdxBuilderTreeNode.MDX_BUILDER_TREE_MEMBER_FUNCTION_NODE_FLAVOR_STRING};
    }

    @Override
    public ImageIcon getIcon() {
        return icon;
    }

    @Override
    public void handleDrop(Object droppedData, DefaultMutableTreeNode containerNode, DefaultTreeModel treeModel) {
        if (droppedData instanceof MdxFunction) {
            this.addMdxFunctionChild((MdxFunction)droppedData, containerNode, treeModel);
        } else if (droppedData instanceof MBTFunctionNode) {
            this.moveMBTFunctionNode((MBTFunctionNode)droppedData, containerNode, treeModel);
        } else {
            if (droppedData instanceof DimensionTreeElement) {
                int mfdp = this.membersFromDifferentDimensionPresent(this, ((DimensionTreeElement)droppedData).getDimensionUniqueName());
                if (mfdp == 1) {
                    this.addCrossjoinAndMoveLevelMembers(containerNode, (DimensionTreeElement)droppedData, treeModel);
                    return;
                }
                if (mfdp > 1) {
                    if (this.addDroppedNodeToTheExistingCrossjoin(containerNode, (DimensionTreeElement)droppedData, treeModel)) {
                        return;
                    }
                    if (this.addCrossjoinAndDroppedNode(containerNode, (DimensionTreeElement)droppedData, treeModel)) {
                        return;
                    }
                }
            }
            try {
                this.addChildAndMBTMembersNode(droppedData, containerNode, treeModel);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void addCrossjoinAndMoveLevelMembers(DefaultMutableTreeNode parent, DimensionTreeElement droppedData, DefaultTreeModel treeModel) {
        this.addMdxFunctionChild(this.getCrossjoin(), parent, treeModel);
        DefaultMutableTreeNode cjNode = (DefaultMutableTreeNode)parent.getLastChild();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (((DefaultMutableTreeNode)parent.getChildAt(i)).getUserObject() instanceof MBTMembersNode) {
                DefaultMutableTreeNode nodeToMove = (DefaultMutableTreeNode)parent.getChildAt(i);
                this.removeMySelfFromTheParent(nodeToMove, treeModel);
                --i;
                treeModel.insertNodeInto(nodeToMove, (DefaultMutableTreeNode)cjNode.getChildAt(0), cjNode.getChildAt(0).getChildCount());
                ((MBTNode)((DefaultMutableTreeNode)cjNode.getChildAt(0)).getUserObject()).addChild((MBTNode)nodeToMove.getUserObject());
                continue;
            }
            if (!(((DefaultMutableTreeNode)parent.getChildAt(i)).getUserObject() instanceof MBTFunctionNode) || ((MBTFunctionNode)((DefaultMutableTreeNode)parent.getChildAt(i)).getUserObject()).getFunctionName().equals("Crossjoin")) continue;
            this.moveMBTFunctionNode((MBTFunctionNode)((DefaultMutableTreeNode)parent.getChildAt(i)).getUserObject(), (DefaultMutableTreeNode)cjNode.getChildAt(0), treeModel);
        }
        try {
            this.addChildAndMBTMembersNode(droppedData, (DefaultMutableTreeNode)cjNode.getChildAt(1), treeModel);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private boolean addCrossjoinAndDroppedNode(DefaultMutableTreeNode parent, DimensionTreeElement droppedData, DefaultTreeModel treeModel) {
        for (int i = parent.getChildCount() - 1; i >= 0; --i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(i);
            if (!(child.getUserObject() instanceof MBTFunctionNode) || !((MBTFunctionNode)child.getUserObject()).getFunctionName().equals("Crossjoin")) continue;
            DefaultMutableTreeNode arg2 = (DefaultMutableTreeNode)child.getChildAt(1);
            MBTNode child1ofArg2 = (MBTNode)((DefaultMutableTreeNode)arg2.getChildAt(0)).getUserObject();
            if (child1ofArg2 instanceof MBTFunctionNode && ((MBTFunctionNode)child1ofArg2).getFunctionName().equals("Crossjoin") && this.addCrossjoinAndDroppedNode(arg2, droppedData, treeModel)) {
                return true;
            }
            this.addCrossjoinAndMoveLevelMembers(arg2, droppedData, treeModel);
            return true;
        }
        return false;
    }

    private boolean addDroppedNodeToTheExistingCrossjoin(DefaultMutableTreeNode parent, DimensionTreeElement droppedData, DefaultTreeModel treeModel) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(i);
            if (!(child.getUserObject() instanceof MBTFunctionNode) || !((MBTFunctionNode)child.getUserObject()).getFunctionName().equals("Crossjoin")) continue;
            DefaultMutableTreeNode arg1 = (DefaultMutableTreeNode)child.getChildAt(0);
            DefaultMutableTreeNode arg2 = (DefaultMutableTreeNode)child.getChildAt(1);
            if (((MBTFunctionNode)child.getUserObject()).isComplete()) {
                MBTNode child1ofArg1 = (MBTNode)((DefaultMutableTreeNode)arg1.getChildAt(0)).getUserObject();
                MBTNode child1ofArg2 = (MBTNode)((DefaultMutableTreeNode)arg2.getChildAt(0)).getUserObject();
                if (child1ofArg1 instanceof MBTMembersNode && ((MBTMembersNode)child1ofArg1).getDimensionUniqueName().equals(droppedData.getDimensionUniqueName())) {
                    try {
                        this.addChildAndMBTMembersNode(droppedData, arg1, treeModel);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return true;
                }
                if (child1ofArg2 instanceof MBTMembersNode && ((MBTMembersNode)child1ofArg2).getDimensionUniqueName().equals(droppedData.getDimensionUniqueName())) {
                    try {
                        this.addChildAndMBTMembersNode(droppedData, arg2, treeModel);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return true;
                }
                if (this.addDroppedNodeToTheExistingCrossjoin((DefaultMutableTreeNode)child.getChildAt(0), droppedData, treeModel)) {
                    return true;
                }
                if (!this.addDroppedNodeToTheExistingCrossjoin((DefaultMutableTreeNode)child.getChildAt(1), droppedData, treeModel)) continue;
                return true;
            }
            if (arg1.getChildCount() == 0) {
                try {
                    this.addChildAndMBTMembersNode(droppedData, arg1, treeModel);
                }
                catch (Exception e) {}
            } else {
                try {
                    this.addChildAndMBTMembersNode(droppedData, arg2, treeModel);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    private MdxFunction getCrossjoin() {
        return new MdxSetFunction("Crossjoin", I18n.getString("setFunction.crossJoin"), "Crossjoin(\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9"), new MBTArgSetNode("\u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9")};
            }
        };
    }

    @Override
    public String[] getPopUpActionList() {
        if (this.nonEmpty) {
            return new String[]{MBTPopUpActions.DELETE_CHILDREN, MBTPopUpActions.EMPTY};
        }
        return new String[]{MBTPopUpActions.DELETE_CHILDREN, MBTPopUpActions.NON_EMPTY};
    }

    @Override
    public void handlePopUpAction(String action, DefaultMutableTreeNode actionNode, DefaultTreeModel treeModel) {
        if (action.equals(MBTPopUpActions.DELETE_CHILDREN)) {
            this.removeAllChildrenFromTheTree(actionNode, treeModel);
        } else if (action.equals(MBTPopUpActions.EMPTY)) {
            this.nonEmpty = false;
        } else if (action.equals(MBTPopUpActions.NON_EMPTY)) {
            this.nonEmpty = true;
        }
    }

    public void setNonEmpty(boolean bool) {
        this.nonEmpty = bool;
    }

    public boolean getNonEmpty() {
        return this.nonEmpty;
    }

    @Override
    public void languageChanged(LanguageChangedEvent evt) {
        MBTPopUpActions.popUpCaptions.put(MBTPopUpActions.DELETE_CHILDREN, I18n.getString("menu.deleteChildren"));
        MBTPopUpActions.popUpCaptions.put(MBTPopUpActions.EMPTY, I18n.getString("menu.allowEmpty"));
        MBTPopUpActions.popUpCaptions.put(MBTPopUpActions.NON_EMPTY, I18n.getString("menu.nonEmpty"));
    }

    @Override
    public void removeLanguageListener() {
        I18n.removeOnLanguageChangedListener(this);
    }
}

