/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.db.api.explorer.NodeProvider;
import org.netbeans.modules.db.explorer.DbNodeLoader;
import org.openide.nodes.Node;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbNodeLoaderImpl
implements DbNodeLoader,
ChangeListener {
    static final String NODE_PROVIDER_PATH = "Databases/NodeProviders";
    static Collection providers;
    final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();

    public List<Node> getAllNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (providers == null) {
            providers = Lookups.forPath((String)NODE_PROVIDER_PATH).lookupAll(NodeProvider.class);
        }
        for (NodeProvider nodeProvider : providers) {
            List<Node> list = nodeProvider.getNodes();
            if (list != null) {
                arrayList.addAll(list);
            }
            nodeProvider.addChangeListener(this);
        }
        return arrayList;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    @Override
    public synchronized void stateChanged(ChangeEvent changeEvent) {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }
}

