/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.netbeans.modules.xml.retriever.DocumentTypeParser;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentTypeSchemaWsdlParser
implements DocumentTypeParser {
    private static XPath xpath = null;
    private Map<String, String> namespaces = new HashMap<String, String>();
    private Map<String, String> prefixes = new HashMap<String, String>();

    @Override
    public boolean accept(String string) {
        if (string != null && string.equalsIgnoreCase(Utilities.DocumentTypesEnum.schema.toString())) {
            return true;
        }
        return string != null && string.equalsIgnoreCase(Utilities.DocumentTypesEnum.wsdl.toString());
    }

    @Override
    public List<String> getAllLocationOfReferencedEntities(FileObject fileObject) throws Exception {
        return this.getAllLocationOfReferencedEntities(FileUtil.toFile((FileObject)fileObject));
    }

    private void initXpath() throws Exception {
        if (xpath == null) {
            xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(this.getNamespaceContext());
            xpath.compile("//xsd:schema/xsd:import/@schemaLocation");
            xpath.compile("//xsd:schema/xsd:include/@schemaLocation");
            xpath.compile("//xsd:schema/xsd:redefine/@schemaLocation");
            xpath.compile("//wsdl:definitions/wsdl:import/@location");
            xpath.compile("/wsdl:definitions");
            xpath.compile("/xsd:schema");
        }
    }

    private NamespaceContext getNamespaceContext() {
        this.namespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
        this.prefixes.put("http://www.w3.org/2001/XMLSchema", "xsd");
        this.namespaces.put("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.prefixes.put("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        return new Utilities.HashNamespaceResolver(this.namespaces, this.prefixes);
    }

    private Node getDOMTree(File file) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        Document document = documentBuilderFactory.newDocumentBuilder().parse(fileObject.getInputStream());
        return document;
    }

    @Override
    public List<String> getAllLocationOfReferencedEntities(File file) throws Exception {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        this.initXpath();
        Node node = this.getDOMTree(file);
        String string = "//xsd:schema/xsd:import/@schemaLocation";
        NodeList nodeList = (NodeList)xpath.evaluate(string, node, XPathConstants.NODESET);
        if (nodeList == null) {
            string = "//xsd:schema/xsd:import/@namespace";
            nodeList = (NodeList)xpath.evaluate(string, node, XPathConstants.NODESET);
        }
        if (nodeList != null && nodeList.getLength() > 0) {
            for (n = 0; n < nodeList.getLength(); ++n) {
                Node node2 = nodeList.item(n);
                arrayList.add(node2.getNodeValue());
            }
        }
        if ((nodeList = (NodeList)xpath.evaluate(string = "//xsd:schema/xsd:include/@schemaLocation", node, XPathConstants.NODESET)) != null && nodeList.getLength() > 0) {
            for (n = 0; n < nodeList.getLength(); ++n) {
                arrayList.add(nodeList.item(n).getNodeValue());
            }
        }
        if ((nodeList = (NodeList)xpath.evaluate(string = "//xsd:schema/xsd:redefine/@schemaLocation", node, XPathConstants.NODESET)) != null && nodeList.getLength() > 0) {
            for (n = 0; n < nodeList.getLength(); ++n) {
                arrayList.add(nodeList.item(n).getNodeValue());
            }
        }
        if ((nodeList = (NodeList)xpath.evaluate(string = "//wsdl:definitions/wsdl:import/@location", node, XPathConstants.NODESET)) != null && nodeList.getLength() > 0) {
            for (n = 0; n < nodeList.getLength(); ++n) {
                arrayList.add(nodeList.item(n).getNodeValue());
            }
        }
        return arrayList;
    }

    public String getFileExtensionByParsing(File file) throws Exception {
        Object var2_2 = null;
        this.initXpath();
        Node node = this.getDOMTree(file);
        String string = "/xsd:schema";
        NodeList nodeList = (NodeList)xpath.evaluate(string, node, XPathConstants.NODESET);
        if (nodeList != null && nodeList.getLength() > 0) {
            return "xsd";
        }
        string = "/wsdl:definitions";
        nodeList = (NodeList)xpath.evaluate(string, node, XPathConstants.NODESET);
        if (nodeList != null && nodeList.getLength() > 0) {
            return "wsdl";
        }
        return "xml";
    }
}

