/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.catalog.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.netbeans.modules.xml.retriever.catalog.CatalogElement;
import org.netbeans.modules.xml.retriever.catalog.CatalogEntry;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogEntryImpl
implements CatalogEntry {
    private CatalogElement entryType;
    private String source;
    private String target;
    private CatalogModel thisCatModel = null;
    private HashMap<String, String> extraAttributeMap = null;

    public CatalogEntryImpl(CatalogElement catalogElement, String string, String string2) {
        this.entryType = catalogElement;
        this.source = string;
        this.target = string2;
    }

    public CatalogEntryImpl(CatalogElement catalogElement, String string, String string2, HashMap<String, String> hashMap) {
        this.entryType = catalogElement;
        this.source = string;
        this.target = string2;
        this.extraAttributeMap = hashMap;
    }

    @Override
    public CatalogElement getEntryType() {
        return this.entryType;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public HashMap<String, String> getExtraAttributeMap() {
        return this.extraAttributeMap;
    }

    @Override
    public boolean isValid() {
        if (this.thisCatModel == null) {
            return false;
        }
        ModelSource modelSource = null;
        try {
            modelSource = this.thisCatModel.getModelSource(new URI(this.source), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
        catch (CatalogModelException catalogModelException) {
            return false;
        }
        return modelSource != null;
    }

    public void setCatalogModel(CatalogModel catalogModel) {
        this.thisCatModel = catalogModel;
    }
}

