/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.modules.autoupdate.services.FeatureUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitImpl;
import org.netbeans.modules.autoupdate.updateprovider.ArtificialFeaturesProvider;
import org.netbeans.modules.autoupdate.updateprovider.FeatureItem;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureUpdateUnitImpl
extends UpdateUnitImpl {
    private Logger err = Logger.getLogger(this.getClass().getName());
    private UpdateElement installedElement = null;
    private UpdateElement updateElement = null;
    private boolean initialized = false;
    private UpdateManager.TYPE type;

    public FeatureUpdateUnitImpl(String string, UpdateManager.TYPE tYPE) {
        super(string);
        this.type = tYPE;
    }

    @Override
    public UpdateElement getInstalled() {
        if (!this.initialized) {
            this.initializeFeature();
        }
        return this.installedElement;
    }

    @Override
    public List<UpdateElement> getAvailableUpdates() {
        if (!this.initialized) {
            this.initializeFeature();
        }
        if (this.updateElement == null) {
            return Collections.emptyList();
        }
        String string = this.updateElement.getCodeName();
        this.err.log(Level.FINE, "UpdateElement " + string + "[" + (this.installedElement == null ? "<not installed>" : this.installedElement.getSpecificationVersion()) + "] has update " + string + "[" + this.updateElement.getSpecificationVersion() + "]");
        return Collections.singletonList(this.updateElement);
    }

    @Override
    public UpdateManager.TYPE getType() {
        return this.type;
    }

    private void initializeFeature() {
        boolean bl;
        List<UpdateElement> list = this.getUpdates();
        this.installedElement = null;
        this.updateElement = null;
        UpdateElement object2 = null;
        FeatureUpdateElementImpl featureUpdateElementImpl = null;
        HashSet<ModuleUpdateElementImpl> hashSet = new HashSet<ModuleUpdateElementImpl>();
        HashSet<ModuleUpdateElementImpl> hashSet2 = new HashSet<ModuleUpdateElementImpl>();
        HashSet<ModuleUpdateElementImpl> hashSet3 = new HashSet<ModuleUpdateElementImpl>();
        assert (list != null) : "FeatureUpdateUnitImpl " + this.getCodeName() + " contains some available elements.";
        for (UpdateElement object3 : list) {
            featureUpdateElementImpl = (FeatureUpdateElementImpl)Trampoline.API.impl(object3);
            boolean featureUpdateElementImpl3 = false;
            for (ModuleUpdateElementImpl moduleUpdateElementImpl : featureUpdateElementImpl.getContainedModuleElements()) {
                UpdateElementImpl updateElementImpl;
                featureUpdateElementImpl3 |= moduleUpdateElementImpl.getUpdateUnit().getInstalled() != null;
                UpdateElement updateElement = moduleUpdateElementImpl.getUpdateUnit().getInstalled();
                UpdateElementImpl updateElementImpl2 = updateElementImpl = updateElement == null ? null : Trampoline.API.impl(updateElement);
                assert (updateElementImpl == null || updateElementImpl instanceof ModuleUpdateElementImpl) : "Impl of " + updateElement + " is instanceof ModuleUpdateElementImpl";
                if (updateElement != null) {
                    hashSet.add((ModuleUpdateElementImpl)updateElementImpl);
                } else {
                    this.err.log(Level.FINER, this.getCodeName() + " misses required module " + moduleUpdateElementImpl.getUpdateElement());
                    hashSet3.add(moduleUpdateElementImpl);
                }
                if (moduleUpdateElementImpl.getUpdateUnit().getAvailableUpdates().isEmpty()) continue;
                UpdateElement updateElement2 = moduleUpdateElementImpl.getUpdateUnit().getAvailableUpdates().get(0);
                UpdateElementImpl updateElementImpl3 = Trampoline.API.impl(updateElement2);
                assert (updateElementImpl3 instanceof ModuleUpdateElementImpl) : "Impl of " + updateElement2 + " is instanceof ModuleUpdateElementImpl";
                hashSet2.add((ModuleUpdateElementImpl)updateElementImpl3);
                this.err.log(Level.FINER, this + " has a update of module " + moduleUpdateElementImpl.getUpdateElement() + " to " + updateElementImpl3.getUpdateElement());
            }
            if (!featureUpdateElementImpl3) continue;
            object2 = object3;
        }
        boolean bl2 = bl = UpdateManager.TYPE.STANDALONE_MODULE == this.getType();
        if (object2 != null) {
            FeatureItem featureItem = ArtificialFeaturesProvider.createFeatureItem(this.getCodeName(), hashSet, featureUpdateElementImpl, bl ? null : FeatureUpdateUnitImpl.presentAddionallyDescription(hashSet, FeatureUpdateUnitImpl.presentMissingModules(hashSet3)));
            FeatureUpdateElementImpl featureUpdateElementImpl2 = new FeatureUpdateElementImpl(featureItem, object2.getSource(), hashSet, featureUpdateElementImpl.getType());
            this.installedElement = Trampoline.API.createUpdateElement(featureUpdateElementImpl2);
            featureUpdateElementImpl2.setUpdateUnit(object2.getUpdateUnit());
        }
        if (!list.isEmpty() && !hashSet2.isEmpty()) {
            hashSet3.addAll(hashSet2);
            FeatureItem featureItem = ArtificialFeaturesProvider.createFeatureItem(this.getCodeName(), hashSet2, featureUpdateElementImpl, bl ? null : FeatureUpdateUnitImpl.presentAddionallyDescription(FeatureUpdateUnitImpl.presentUpdatableModules(hashSet3), hashSet));
            FeatureUpdateElementImpl featureUpdateElementImpl3 = new FeatureUpdateElementImpl(featureItem, list.get(0).getSource(), hashSet2, featureUpdateElementImpl.getType());
            this.updateElement = Trampoline.API.createUpdateElement(featureUpdateElementImpl3);
            featureUpdateElementImpl3.setUpdateUnit(list.get(0).getUpdateUnit());
            this.addUpdate(this.updateElement);
        }
        this.initialized = true;
    }

    @Override
    public void setInstalled(UpdateElement updateElement) {
        assert (false) : "Invalid calling setInstalled (" + updateElement + ") on FeatureUpdateUnitImpl.";
    }

    @Override
    public void setAsUninstalled() {
        this.initialized = false;
    }

    @Override
    public void updateInstalled(UpdateElement updateElement) {
        this.initialized = false;
    }

    private static String getDisplayNames(Set<ModuleUpdateElementImpl> set) {
        assert (set != null && !set.isEmpty()) : "Some ModuleUpdateElementImpl must found to take its display names.";
        String string = "";
        for (ModuleUpdateElementImpl moduleUpdateElementImpl : set) {
            string = string + (string.length() == 0 ? "" : ", ") + moduleUpdateElementImpl.getDisplayName();
        }
        return string;
    }

    private static String presentMissingModules(Set<ModuleUpdateElementImpl> set) {
        if (set.isEmpty()) {
            return "";
        }
        boolean bl = set.size() == 1;
        String string = bl ? NbBundle.getMessage(FeatureUpdateUnitImpl.class, (String)"FeatureUpdateUnitImpl_MissingModule", (Object)FeatureUpdateUnitImpl.getDisplayNames(set)) : NbBundle.getMessage(FeatureUpdateUnitImpl.class, (String)"FeatureUpdateUnitImpl_MissingModules", (Object)FeatureUpdateUnitImpl.getDisplayNames(set));
        return string;
    }

    private static String presentUpdatableModules(Set<ModuleUpdateElementImpl> set) {
        if (set.isEmpty()) {
            return "";
        }
        boolean bl = set.size() == 1;
        String string = bl ? NbBundle.getMessage(FeatureUpdateUnitImpl.class, (String)"FeatureUpdateUnitImpl_UpdatableModule", (Object)FeatureUpdateUnitImpl.getDisplayNames(set)) : NbBundle.getMessage(FeatureUpdateUnitImpl.class, (String)"FeatureUpdateUnitImpl_UpdatableModules", (Object)FeatureUpdateUnitImpl.getDisplayNames(set));
        return string;
    }

    private static String presentIncludedModules(Set<ModuleUpdateElementImpl> set) {
        if (set.isEmpty()) {
            return "";
        }
        boolean bl = set.size() == 1;
        String string = bl ? NbBundle.getMessage(FeatureUpdateUnitImpl.class, (String)"FeatureUpdateUnitImpl_ContainedModule", (Object)FeatureUpdateUnitImpl.getDisplayNames(set)) : NbBundle.getMessage(FeatureUpdateUnitImpl.class, (String)"FeatureUpdateUnitImpl_ContainedModules", (Object)FeatureUpdateUnitImpl.getDisplayNames(set));
        return string;
    }

    private static String presentAddionallyDescription(Set<ModuleUpdateElementImpl> set, String string) {
        String string2 = FeatureUpdateUnitImpl.presentIncludedModules(set) + string;
        return string2.length() > 0 ? string2 : null;
    }

    private static String presentAddionallyDescription(String string, Set<ModuleUpdateElementImpl> set) {
        String string2 = string + FeatureUpdateUnitImpl.presentIncludedModules(set);
        return string2.length() > 0 ? string2 : null;
    }
}

