/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table;

import com.jaspersoft.ireport.components.table.TableAlignWithWidgetCollector;
import com.jaspersoft.ireport.components.table.TableCell;
import com.jaspersoft.ireport.components.table.TableMatrix;
import com.jaspersoft.ireport.components.table.TableModelUtils;
import com.jaspersoft.ireport.components.table.actions.SeparatorDblClickResizeAction;
import com.jaspersoft.ireport.components.table.actions.TableCellSeparatorMoveAction;
import com.jaspersoft.ireport.components.table.actions.TableElementPopupMenuProvider;
import com.jaspersoft.ireport.components.table.actions.TableSceneClickAction;
import com.jaspersoft.ireport.components.table.nodes.TableCellNode;
import com.jaspersoft.ireport.components.table.nodes.TableColumnGroupNode;
import com.jaspersoft.ireport.components.table.nodes.TableNullCellNode;
import com.jaspersoft.ireport.components.table.nodes.TableSectionNode;
import com.jaspersoft.ireport.components.table.undo.AddTableCellUndoableEdit;
import com.jaspersoft.ireport.components.table.widgets.IndicatorWidget;
import com.jaspersoft.ireport.components.table.widgets.TableCellSeparatorWidget;
import com.jaspersoft.ireport.components.table.widgets.TableWidget;
import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.actions.KeyboardElementMoveAction;
import com.jaspersoft.ireport.designer.actions.ReportAlignWithMoveStrategyProvider;
import com.jaspersoft.ireport.designer.actions.ReportAlignWithResizeStrategyProvider;
import com.jaspersoft.ireport.designer.actions.TranslucentRectangularSelectDecorator;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.widgets.JRDesignChartWidget;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import com.jaspersoft.ireport.designer.widgets.JRDesignImageWidget;
import com.jaspersoft.ireport.designer.widgets.SelectionWidget;
import com.jaspersoft.ireport.designer.widgets.visitor.ConfigurableDrawVisitor;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.undo.UndoableEdit;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.draw.DrawVisitor;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.AlignWithWidgetCollector;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.RectangularSelectDecorator;
import org.netbeans.api.visual.action.RectangularSelectProvider;
import org.netbeans.api.visual.action.ResizeProvider;
import org.netbeans.api.visual.action.ResizeStrategy;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.SeparatorWidget;
import org.netbeans.api.visual.widget.Widget;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableObjectScene
extends AbstractReportObjectScene
implements PropertyChangeListener {
    private TableWidget tableWidget = null;
    private List<JRDesignElement> selectedElements = new ArrayList<JRDesignElement>();
    private StandardTable table = null;
    private JasperDesign jasperDesign = null;
    private DrawVisitor drawVisitor = null;
    private JRDesignComponentElement tableElement = null;
    private TableAlignWithWidgetCollector reportAlignWithWidgetCollector = null;
    private ReportAlignWithMoveStrategyProvider reportAlignWithMoveStrategyProvider = null;
    private ReportAlignWithResizeStrategyProvider reportAlignWithResizeStrategyProvider = null;
    private KeyboardElementMoveAction keyboardElementMoveAction = null;
    private TableSceneClickAction tableSceneClickAction = null;
    protected static final WidgetAction tableElementPopupMenuAction = ActionFactory.createPopupMenuAction((PopupMenuProvider)new TableElementPopupMenuProvider());
    private PropertyChangeListener stylesChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            TableObjectScene.this.setDrawVisitor(null);
            TableObjectScene.this.tableWidget.revalidate(true);
            TableObjectScene.this.getScene().validate();
            if (evt.getPropertyName().equals("styles")) {
                TableObjectScene.this.updateStyleListeners();
            }
        }
    };
    private TableMatrix tableMatrix = null;
    LayerWidget backgroundLayer = null;
    LayerWidget pageLayer = null;
    LayerWidget interractionLayer = null;
    LayerWidget indicatorsLayer = null;
    LayerWidget cellSeparatorsLayer = null;
    Node[] lastSelectedNodes = null;

    public TableObjectScene(JasperDesign jasperdesign, JRDesignComponentElement tableElement) {
        this.tableElement = tableElement;
        this.jasperDesign = jasperdesign;
        this.table = (StandardTable)tableElement.getComponent();
        this.initScene();
        jasperdesign.getEventSupport().addPropertyChangeListener("styles", this.stylesChangeListener);
        this.updateStyleListeners();
    }

    private void updateStyleListeners() {
        if (this.getJasperDesign() != null) {
            List styles = this.getJasperDesign().getStylesList();
            for (int i = 0; i < styles.size(); ++i) {
                if (!(styles.get(i) instanceof JRDesignStyle)) continue;
                ((JRDesignStyle)styles.get(i)).getEventSupport().removePropertyChangeListener(this.stylesChangeListener);
                ((JRDesignStyle)styles.get(i)).getEventSupport().addPropertyChangeListener(this.stylesChangeListener);
            }
        }
    }

    private void initScene() {
        this.setBackground(UIManager.getColor("Panel.background"));
        this.setKeyEventProcessingType(EventProcessingType.FOCUSED_WIDGET_AND_ITS_PARENTS);
        this.backgroundLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.backgroundLayer);
        this.pageLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.pageLayer);
        this.elementsLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.elementsLayer);
        this.cellSeparatorsLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.cellSeparatorsLayer);
        this.selectionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.selectionLayer);
        this.guideLinesLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.guideLinesLayer);
        this.interractionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.interractionLayer);
        this.indicatorsLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.indicatorsLayer);
        this.reportAlignWithWidgetCollector = new TableAlignWithWidgetCollector(this);
        this.reportAlignWithMoveStrategyProvider = new ReportAlignWithMoveStrategyProvider((AlignWithWidgetCollector)this.reportAlignWithWidgetCollector, this.interractionLayer, ALIGN_WITH_MOVE_DECORATOR_DEFAULT, false);
        this.reportAlignWithResizeStrategyProvider = new ReportAlignWithResizeStrategyProvider((AlignWithWidgetCollector)this.reportAlignWithWidgetCollector, this.interractionLayer, ALIGN_WITH_MOVE_DECORATOR_DEFAULT, false);
        this.tableSceneClickAction = new TableSceneClickAction();
        this.getActions().addAction((WidgetAction)this.tableSceneClickAction);
        this.getActions().addAction(ActionFactory.createRectangularSelectAction((RectangularSelectDecorator)new TranslucentRectangularSelectDecorator((Scene)this), (LayerWidget)this.interractionLayer, (RectangularSelectProvider)ActionFactory.createObjectSceneRectangularSelectProvider((ObjectScene)this)));
        this.getActions().addAction(reportPopupMenuAction);
        this.getActions().addAction(ActionFactory.createMouseCenteredZoomAction((double)1.1));
        this.getActions().addAction(ActionFactory.createPanAction());
        this.keyboardElementMoveAction = new KeyboardElementMoveAction();
        this.getActions().addAction((WidgetAction)this.keyboardElementMoveAction);
        this.setMaximumBounds(new Rectangle(-10, -10, Integer.MAX_VALUE, Integer.MAX_VALUE));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TableObjectScene.this.rebuildDocument();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildDocument() {
        if (this.tableMatrix == null) {
            this.tableMatrix = new TableMatrix(this.getJasperDesign(), this.getTable());
        } else {
            this.tableMatrix.processMatrix();
        }
        boolean oldUpdateingStatus = this.isUpdatingView();
        try {
            this.setUpdatingView(true);
            this.pageLayer.removeChildren();
            this.cellSeparatorsLayer.removeChildren();
            this.backgroundLayer.removeChildren();
            this.interractionLayer.removeChildren();
            this.indicatorsLayer.removeChildren();
            if (this.jasperDesign == null) {
                while (this.getObjects().size() > 0) {
                    this.removeObject(this.getObjects().iterator().next());
                }
                this.elementsLayer.removeChildren();
                this.selectionLayer.removeChildren();
                return;
            }
            if (this.getTableWidget() == null) {
                this.setTableWidget(new TableWidget(this, this.getTableElement()));
                this.getTableWidget().getActions().addAction(this.inplaceEditorAction);
            } else {
                this.getTableWidget().updateBounds();
            }
            this.pageLayer.addChild((Widget)this.getTableWidget());
            this.refreshCells();
        }
        finally {
            this.setUpdatingView(oldUpdateingStatus);
        }
    }

    public void refreshCells() {
        TableCellSeparatorWidget w;
        int i;
        List bWidgets = this.cellSeparatorsLayer.getChildren();
        this.cellSeparatorsLayer.removeChildren();
        boolean currentX = false;
        for (i = 1; i < this.getVerticalSeparators().size(); ++i) {
            w = new TableCellSeparatorWidget(this, i, SeparatorWidget.Orientation.VERTICAL);
            w.getActions().addAction((WidgetAction)new TableCellSeparatorMoveAction(true, 64));
            w.getActions().addAction((WidgetAction)new TableCellSeparatorMoveAction());
            w.getActions().addAction((WidgetAction)new SeparatorDblClickResizeAction());
            this.cellSeparatorsLayer.addChild((Widget)w);
        }
        this.updateIndicators();
        for (i = 1; i < this.getHorizontalSeparators().size(); ++i) {
            if (!this.tableMatrix.isValidBase(i)) continue;
            w = new TableCellSeparatorWidget(this, i, SeparatorWidget.Orientation.HORIZONTAL);
            w.getActions().addAction((WidgetAction)new TableCellSeparatorMoveAction(true, 64));
            w.getActions().addAction((WidgetAction)new TableCellSeparatorMoveAction());
            w.getActions().addAction((WidgetAction)new SeparatorDblClickResizeAction());
            this.cellSeparatorsLayer.addChild((Widget)w);
        }
        List<TableCell> tableCells = this.getTableMatrix().getCells();
        ArrayList<DesignCell> cells = new ArrayList<DesignCell>();
        for (TableCell cell : tableCells) {
            if (cell.getCell() == null) continue;
            cells.add(cell.getCell());
        }
        ArrayList toBeRemovedObjects = new ArrayList();
        ArrayList<Widget> toBeRemoved = new ArrayList<Widget>();
        ArrayList<SelectionWidget> toBeRemovedSelection = new ArrayList<SelectionWidget>();
        for (Object obj : this.getObjects()) {
            if (!(obj instanceof JRDesignElement) || cells.contains(TableModelUtils.getCell((JRDesignElement)obj))) continue;
            Widget w2 = this.findWidget(obj);
            if (w2 != null) {
                toBeRemoved.add(w2);
                toBeRemovedSelection.add(((JRDesignElementWidget)w2).getSelectionWidget());
            }
            toBeRemovedObjects.add(obj);
        }
        for (Object obj : toBeRemovedObjects) {
            this.removeObject(obj);
        }
        this.elementsLayer.removeChildren(toBeRemoved);
        this.selectionLayer.removeChildren(toBeRemovedSelection);
        for (DesignCell cell : cells) {
            if (cell == null) continue;
            this.addElements(cell.getChildren());
        }
        this.validate();
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void refreshElementGroup(JRElementGroup group) {
    }

    public DrawVisitor getDrawVisitor() {
        if (this.drawVisitor == null) {
            this.drawVisitor = new ConfigurableDrawVisitor((JRReport)this.getJasperDesign(), null);
        }
        return this.drawVisitor;
    }

    public void setDrawVisitor(DrawVisitor drawVisitor) {
        this.drawVisitor = drawVisitor;
    }

    public LayerWidget getBackgroundLayer() {
        return this.backgroundLayer;
    }

    public LayerWidget getPageLayer() {
        return this.pageLayer;
    }

    public LayerWidget getInterractionLayer() {
        return this.interractionLayer;
    }

    public LayerWidget getIndicatorsLayer() {
        return this.indicatorsLayer;
    }

    public LayerWidget getCellSeparatorsLayer() {
        return this.cellSeparatorsLayer;
    }

    public void setCellSeparatorsLayer(LayerWidget cellSeparatorsLayer) {
        this.cellSeparatorsLayer = cellSeparatorsLayer;
    }

    public JRDesignComponentElement getTableElement() {
        return this.tableElement;
    }

    public StandardTable getTable() {
        return (StandardTable)this.tableElement.getComponent();
    }

    public void setTableElement(JRDesignComponentElement tableElement) {
        this.tableElement = tableElement;
    }

    public TableWidget getTableWidget() {
        return this.tableWidget;
    }

    public void setTableWidget(TableWidget tableWidget) {
        this.tableWidget = tableWidget;
    }

    public List<Integer> getVerticalSeparators() {
        return this.getTableMatrix().getVerticalSeparators();
    }

    public List<Integer> getHorizontalSeparators() {
        return this.getTableMatrix().getHorizontalSeparators();
    }

    private void addElements(List children) {
        for (int i = 0; i < children.size(); ++i) {
            Object obj = children.get(i);
            if (obj instanceof JRDesignElementGroup) {
                if (!this.elementGroupListeners.containsKey(obj)) {
                    AbstractReportObjectScene.GroupChangeListener gcl = new AbstractReportObjectScene.GroupChangeListener((AbstractReportObjectScene)this, (JRDesignElementGroup)obj);
                    ((JRDesignElementGroup)obj).getEventSupport().addPropertyChangeListener((PropertyChangeListener)gcl);
                    this.elementGroupListeners.put(obj, gcl);
                }
                this.addElements(((JRDesignElementGroup)obj).getChildren());
            }
            if (!(obj instanceof JRDesignElement)) continue;
            JRDesignElement de = (JRDesignElement)obj;
            JRDesignElementWidget w = this.findElementWidget(de);
            if (w != null) {
                w.updateBounds();
                w.bringToFront();
                w.getSelectionWidget().updateBounds();
                w.getSelectionWidget().bringToFront();
            } else {
                w = this.addElementWidget(de);
            }
            if (w == null || w.getChildrenElements() == null) continue;
            this.addElements(w.getChildrenElements());
        }
    }

    public JRDesignElementWidget addElementWidget(JRDesignElement de) {
        if (de == null) {
            return null;
        }
        JRDesignElementWidget widget = null;
        if (de instanceof JRDesignComponentElement) {
            widget = IReportManager.getComponentWidget((AbstractReportObjectScene)this, (JRDesignComponentElement)((JRDesignComponentElement)de));
        } else if (de instanceof JRDesignImage) {
            widget = new JRDesignImageWidget((AbstractReportObjectScene)this, (JRDesignImage)de);
        } else if (de instanceof JRDesignChart) {
            widget = new JRDesignChartWidget((AbstractReportObjectScene)this, (JRDesignChart)de);
        }
        if (widget == null) {
            widget = new JRDesignElementWidget((AbstractReportObjectScene)this, de);
        }
        widget.getActions().addAction(this.getReportSelectAction());
        widget.getSelectionWidget().getActions().addAction((WidgetAction)this.keyboardElementMoveAction);
        widget.getSelectionWidget().getActions().addAction(this.getReportSelectAction());
        widget.getSelectionWidget().getActions().addAction(this.createObjectHoverAction());
        widget.getSelectionWidget().getActions().addAction(ActionFactory.createResizeAction((ResizeStrategy)this.reportAlignWithResizeStrategyProvider, (ResizeProvider)this.reportAlignWithResizeStrategyProvider));
        widget.getSelectionWidget().getActions().addAction(ActionFactory.createMoveAction((MoveStrategy)this.reportAlignWithMoveStrategyProvider, (MoveProvider)this.reportAlignWithMoveStrategyProvider));
        widget.getActions().addAction(ActionFactory.createResizeAction((ResizeStrategy)this.reportAlignWithResizeStrategyProvider, (ResizeProvider)this.reportAlignWithResizeStrategyProvider));
        widget.getActions().addAction(ActionFactory.createMoveAction((MoveStrategy)this.reportAlignWithMoveStrategyProvider, (MoveProvider)this.reportAlignWithMoveStrategyProvider));
        widget.getActions().addAction(this.inplaceEditorAction);
        widget.getSelectionWidget().getActions().addAction(this.inplaceEditorAction);
        widget.getActions().addAction(tableElementPopupMenuAction);
        widget.getSelectionWidget().getActions().addAction(tableElementPopupMenuAction);
        widget.getActions().addAction(ActionFactory.createActionMapAction((InputMap)elementInputMap, (ActionMap)elementActionMap));
        widget.getSelectionWidget().getActions().addAction(ActionFactory.createActionMapAction((InputMap)elementInputMap, (ActionMap)elementActionMap));
        this.elementsLayer.addChild((Widget)widget);
        this.selectionLayer.addChild((Widget)widget.getSelectionWidget());
        this.addObject(de, new Widget[]{widget});
        return widget;
    }

    public Point getParentLocation(JasperDesign jd, JRDesignElement element, JRDesignElementWidget widget) {
        Point base = null;
        if (element == null) {
            return new Point(0, 0);
        }
        for (JRElementGroup grp = element.getElementGroup(); grp != null; grp = grp.getElementGroup()) {
            if (grp instanceof DesignCell) {
                base = this.getTableMatrix().getCellLocation((DesignCell)grp);
                break;
            }
            if (!(grp instanceof JRDesignFrame)) continue;
            JRDesignFrame frame = (JRDesignFrame)grp;
            base = this.getParentLocation(jd, (JRDesignElement)frame, widget);
            base.x += frame.getX();
            base.y += frame.getY();
            break;
        }
        if (base == null) {
            JRDesignElementWidget owner;
            base = new Point(0, 0);
            if (widget != null && widget.getScene() instanceof AbstractReportObjectScene && (owner = ((AbstractReportObjectScene)widget.getScene()).findCustomComponentOwner(element)) != null) {
                base = this.getParentLocation(jd, owner.getElement(), owner);
                base.x += owner.getElement().getX();
                base.y += owner.getElement().getY();
            }
        }
        return base;
    }

    public TableMatrix getTableMatrix() {
        return this.tableMatrix;
    }

    public void setTableMatrix(TableMatrix tableMatrix) {
        this.tableMatrix = tableMatrix;
    }

    public Rectangle getParentBounds(JasperDesign jd, JRDesignElement element, JRDesignElementWidget widget) {
        Point p;
        Rectangle base = null;
        if (element == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        for (JRElementGroup grp = element.getElementGroup(); grp != null; grp = grp.getElementGroup()) {
            if (grp instanceof DesignCell) {
                DesignCell cell = (DesignCell)grp;
                base = this.getTableMatrix().getCellBounds(cell);
                break;
            }
            if (!(grp instanceof JRDesignFrame)) continue;
            JRDesignFrame frame = (JRDesignFrame)grp;
            p = this.getParentLocation(jd, (JRDesignElement)frame, widget);
            base = new Rectangle();
            base.x = p.x + frame.getX();
            base.y = p.y + frame.getY();
            base.width = frame.getWidth();
            base.height = frame.getHeight();
            break;
        }
        if (base == null) {
            JRDesignElementWidget owner;
            base = new Rectangle(0, 0, 0, 0);
            if (widget != null && widget.getScene() instanceof AbstractReportObjectScene && (owner = ((AbstractReportObjectScene)widget.getScene()).findCustomComponentOwner(element)) != null) {
                p = this.getParentLocation(jd, owner.getElement(), owner);
                base.x += owner.getElement().getX();
                base.y += owner.getElement().getY();
                base.width += owner.getElement().getWidth();
                base.height += owner.getElement().getHeight();
            }
        }
        return base;
    }

    public Object dropElementAt(JRDesignElement element, Point location) {
        Point p = this.convertViewToScene(location);
        TableCell cell = this.getTableMatrix().getCellAt(p);
        if (cell == null) {
            return null;
        }
        DesignCell designCell = cell.getCell();
        JRDesignElementWidget wContainer = this.findTopMostFrameAt(p);
        if (wContainer != null) {
            JRDesignElement frame = wContainer.getElement();
            Point parentLocation = wContainer.convertModelToLocalLocation(new Point(frame.getX(), frame.getY()));
            element.setX(p.x - parentLocation.x);
            element.setY(p.y - parentLocation.y);
            wContainer.addElement(element);
            return frame;
        }
        Point parentLocation = this.getTableMatrix().getCellLocation(cell);
        element.setX(p.x - parentLocation.x);
        element.setY(p.y - parentLocation.y);
        if (designCell == null) {
            designCell = new DesignCell();
            int rowHight = this.getHorizontalSeparators().get(cell.getRow() + cell.getRowSpan()) - this.getHorizontalSeparators().get(cell.getRow());
            designCell.setHeight(Integer.valueOf(rowHight));
            designCell.addElement(element);
            TableModelUtils.addCell(cell.getColumn(), designCell, (byte)cell.getType(), cell.getGroupName());
            AddTableCellUndoableEdit edit = new AddTableCellUndoableEdit(this.getTable(), this.getJasperDesign(), designCell, cell.getColumn(), (byte)cell.getType(), cell.getGroupName() != null ? this.getGroup(cell.getGroupName()) : null);
            IReportManager.getInstance().addUndoableEdit((UndoableEdit)((Object)edit));
        } else {
            designCell.addElement(element);
        }
        return designCell;
    }

    private JRGroup getGroup(String name) {
        JRDesignDataset dataset = this.getJasperDesign().getMainDesignDataset();
        if (this.table.getDatasetRun() != null && this.table.getDatasetRun().getDatasetName() != null) {
            dataset = (JRDesignDataset)this.getJasperDesign().getDatasetMap().get(this.table.getDatasetRun().getDatasetName());
        }
        if (dataset != null) {
            return (JRGroup)dataset.getGroupsMap().get(name);
        }
        return null;
    }

    private JRDesignElementWidget findTopMostFrameAt(Point p) {
        LayerWidget layer = this.getElementsLayer();
        List widgets = layer.getChildren();
        for (int i = widgets.size() - 1; i >= 0; --i) {
            Point p2;
            Widget w = (Widget)widgets.get(i);
            if (!w.isHitAt(p2 = w.convertSceneToLocal(p)) || !(w instanceof JRDesignElementWidget)) continue;
            JRDesignElement de = ((JRDesignElementWidget)w).getElement();
            if (((JRDesignElementWidget)w).getChildrenElements() == null) continue;
            return (JRDesignElementWidget)w;
        }
        return null;
    }

    public boolean acceptDropAt(Point location) {
        Point p = this.convertViewToScene(location);
        return this.getTableMatrix().getCellAt(p) != null;
    }

    public JRDesignElementWidget findElementWidget(JRDesignElement de) {
        List widgets = this.elementsLayer.getChildren();
        for (Widget w : widgets) {
            JRDesignElementWidget dew;
            if (!(w instanceof JRDesignElementWidget) || (dew = (JRDesignElementWidget)w).getElement() != de) continue;
            return dew;
        }
        return null;
    }

    public synchronized void reprocessMatrix() {
        if (this.getJasperDesign() == null) {
            return;
        }
        if (this.table == null) {
            return;
        }
        if (this.getTableMatrix() == null) {
            return;
        }
        JRDesignDataset dataset = this.getJasperDesign().getMainDesignDataset();
        if (this.table.getDatasetRun() != null && this.table.getDatasetRun().getDatasetName() != null) {
            dataset = (JRDesignDataset)this.getJasperDesign().getDatasetMap().get(this.table.getDatasetRun().getDatasetName());
        }
        this.getTableMatrix().processMatrix(dataset);
    }

    private void updateIndicators() {
        Rectangle r;
        BaseColumn column = null;
        this.getIndicatorsLayer().removeChildren();
        if (this.lastSelectedNodes == null || this.lastSelectedNodes.length == 0) {
            this.validate();
            return;
        }
        block0: for (int i = 0; i < this.lastSelectedNodes.length; ++i) {
            IndicatorWidget cw;
            Rectangle r2;
            IndicatorWidget cw2;
            Rectangle r3;
            TableCell tc;
            Object cellNode;
            if (!this.isNodeChildOf(this.lastSelectedNodes[i], this.getTableElement())) continue;
            column = (BaseColumn)this.lastSelectedNodes[i].getLookup().lookup(BaseColumn.class);
            if (this.lastSelectedNodes[i] instanceof TableNullCellNode) {
                cellNode = (TableNullCellNode)this.lastSelectedNodes[i];
                tc = this.getTableMatrix().findTableCell(((TableNullCellNode)((Object)cellNode)).getColumn(), ((TableNullCellNode)((Object)cellNode)).getSection(), ((TableNullCellNode)((Object)cellNode)).getGroup() == null ? null : ((TableNullCellNode)((Object)cellNode)).getGroup().getName());
                if (tc == null || (r3 = this.getTableMatrix().getCellBounds(tc)) == null) continue;
                cw2 = new IndicatorWidget(this, tc.getRow(), 1);
                cw2.setPreferredLocation(new Point(-10, r3.y));
                cw2.setPreferredBounds(new Rectangle(0, 0, 8, r3.height));
                cw2.revalidate(true);
                this.getIndicatorsLayer().addChild((Widget)cw2);
                continue;
            }
            if (this.lastSelectedNodes[i] instanceof TableCellNode) {
                cellNode = (TableCellNode)this.lastSelectedNodes[i];
                tc = this.getTableMatrix().findTableCell(((TableCellNode)cellNode).getColumn(), ((TableCellNode)cellNode).getSection(), ((TableCellNode)cellNode).getGroup() == null ? null : ((TableCellNode)cellNode).getGroup().getName());
                if (tc == null || (r3 = this.getTableMatrix().getCellBounds(tc)) == null) continue;
                cw2 = new IndicatorWidget(this, tc.getRow(), 1);
                cw2.setPreferredLocation(new Point(-10, r3.y));
                cw2.setPreferredBounds(new Rectangle(0, 0, 8, r3.height));
                cw2.revalidate(true);
                this.getIndicatorsLayer().addChild((Widget)cw2);
                continue;
            }
            if (this.lastSelectedNodes[i] instanceof TableSectionNode) {
                TableSectionNode sectionNode = (TableSectionNode)this.lastSelectedNodes[i];
                r2 = this.getTableMatrix().getSectionBounds(sectionNode.getSectionType(), sectionNode.getGroup() == null ? null : sectionNode.getGroup().getName());
                if (r2 == null) continue;
                cw = new IndicatorWidget(this, new Object[]{sectionNode.getSectionType(), sectionNode.getGroup()}, 2);
                cw.setPreferredLocation(new Point(-10, r2.y));
                cw.setPreferredBounds(new Rectangle(0, 0, 8, r2.height));
                cw.revalidate(true);
                this.getIndicatorsLayer().addChild((Widget)cw);
                continue;
            }
            if (this.lastSelectedNodes[i] instanceof TableColumnGroupNode) {
                TableColumnGroupNode columnGroupNode = (TableColumnGroupNode)this.lastSelectedNodes[i];
                r2 = this.getTableMatrix().getColumnBounds((BaseColumn)columnGroupNode.getColumnGroup());
                if (r2 == null) continue;
                cw = new IndicatorWidget(this, columnGroupNode.getColumnGroup(), 3);
                cw.setPreferredLocation(new Point(-10, r2.y));
                cw.setPreferredBounds(new Rectangle(0, 0, 8, r2.height));
                cw.revalidate(true);
                this.getIndicatorsLayer().addChild((Widget)cw);
                continue;
            }
            if (!(this.lastSelectedNodes[i] instanceof ElementNode)) continue;
            for (Node parent = this.lastSelectedNodes[i].getParentNode(); parent != null; parent = parent.getParentNode()) {
                if (!(parent instanceof TableCellNode)) continue;
                TableCellNode cellNode2 = (TableCellNode)parent;
                TableCell tc2 = this.getTableMatrix().findTableCell(cellNode2.getColumn(), cellNode2.getSection(), cellNode2.getGroup() == null ? null : cellNode2.getGroup().getName());
                if (tc2 == null) continue block0;
                column = tc2.getColumn();
                Rectangle r4 = this.getTableMatrix().getCellBounds(tc2);
                if (r4 == null) continue block0;
                IndicatorWidget cw3 = new IndicatorWidget(this, tc2.getRow(), 1);
                cw3.setPreferredLocation(new Point(-10, r4.y));
                cw3.setPreferredBounds(new Rectangle(0, 0, 8, r4.height));
                cw3.revalidate(true);
                this.getIndicatorsLayer().addChild((Widget)cw3);
                continue block0;
            }
        }
        if (column != null && (r = this.getTableMatrix().getColumnBounds(column)) != null) {
            IndicatorWidget cw = new IndicatorWidget(this, column, 0);
            cw.setPreferredLocation(new Point(r.x, -10));
            cw.setPreferredBounds(new Rectangle(0, 0, r.width, 8));
            cw.revalidate(true);
            this.getIndicatorsLayer().addChild((Widget)cw);
        }
        this.validate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("selectedNodes")) {
            Node[] selectedNodes = (Node[])evt.getNewValue();
            this.lastSelectedNodes = selectedNodes;
            this.updateIndicators();
        }
    }

    private boolean isNodeChildOf(Node node, JRDesignComponentElement tableElement) {
        if (node == null) {
            return false;
        }
        if (node.getLookup().lookup(JRDesignComponentElement.class) == tableElement) {
            return true;
        }
        return this.isNodeChildOf(node.getParentNode(), tableElement);
    }
}

