/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table;

import com.jaspersoft.ireport.components.table.TableCell;
import com.jaspersoft.ireport.components.table.TableModelUtils;
import com.jaspersoft.ireport.components.table.undo.AddTableColumnUndoableEdit;
import com.jaspersoft.ireport.components.table.undo.DeleteTableColumnUndoableEdit;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoableEdit;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.util.ImageUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableMatrix {
    private List<TableCell> cells = new ArrayList<TableCell>();
    private List<Integer> verticalSeparators = new ArrayList<Integer>();
    private List<Integer> horizontalSeparators = new ArrayList<Integer>();
    private StandardTable table = null;
    private JasperDesign jasperDesign = null;

    public TableMatrix(JasperDesign jd, StandardTable table) {
        this.jasperDesign = jd;
        this.table = table;
        this.processMatrix();
    }

    public void processMatrix() {
        if (this.getTable() == null || this.getJasperDesign() == null) {
            return;
        }
        JRDesignDataset dataset = this.getJasperDesign().getMainDesignDataset();
        if (this.table.getDatasetRun() != null && this.table.getDatasetRun().getDatasetName() != null) {
            dataset = (JRDesignDataset)this.getJasperDesign().getDatasetMap().get(this.table.getDatasetRun().getDatasetName());
        }
        this.processMatrix(dataset);
    }

    public synchronized void processMatrix(JRDesignDataset dataset) {
        this.cells.clear();
        this.getVerticalSeparators().clear();
        this.getHorizontalSeparators().clear();
        this.createVerticalSeparators();
        List columns = this.getTable().getColumns();
        int x = 0;
        int y = 0;
        int col = 0;
        int row = 0;
        byte[] sections = new byte[]{0, 1, 2, 3, 4, 5, 6};
        this.horizontalSeparators.add(0);
        for (byte sectionType : sections) {
            int iterations = 1;
            if (sectionType == 2 || sectionType == 4) {
                iterations = dataset != null ? dataset.getGroupsList().size() : 0;
            }
            for (int k = 0; k < iterations; ++k) {
                String groupName = null;
                if (dataset != null && (sectionType == 2 || sectionType == 4)) {
                    groupName = ((JRGroup)dataset.getGroupsList().get(k)).getName();
                }
                int sectionHeight = this.getSectionHeight(sectionType, groupName);
                int sectionRows = this.getSectionRows(sectionType, groupName);
                for (int i = 0; i < sectionRows - 1; ++i) {
                    this.getHorizontalSeparators().add(0);
                }
                for (BaseColumn c : columns) {
                    Point pos = this.processSection(c, x, y, row, col, sectionHeight, sectionRows, sectionType, groupName);
                    x += pos.x;
                    col += pos.y;
                }
                x = 0;
                row += sectionRows;
                col = 0;
                this.getHorizontalSeparators().add(y += sectionHeight);
            }
        }
        for (int i = 1; i < this.getHorizontalSeparators().size(); ++i) {
            int maxRowHeight = 0;
            boolean hasCells = false;
            for (TableCell cell : this.cells) {
                if (cell.getRow() + cell.getRowSpan() != i) continue;
                hasCells = true;
                break;
            }
            for (TableCell cell : this.cells) {
                int cellHeight;
                if (cell.getRow() + cell.getRowSpan() != i || (cellHeight = cell.getCell() != null && cell.getCell().getHeight() != null ? cell.getCell().getHeight() : 0) == 0) continue;
                if (cell.getRowSpan() > 1) {
                    int previousSpannedRowsHeight = this.getHorizontalSeparators().get(cell.getRow()) - this.getHorizontalSeparators().get(cell.getRow() + cell.getRowSpan() - 1);
                    cellHeight -= -previousSpannedRowsHeight;
                    if (hasCells) {
                        cellHeight = 0;
                    }
                }
                if (cellHeight <= 0) continue;
                maxRowHeight = cellHeight > maxRowHeight ? cellHeight : maxRowHeight;
            }
            this.getHorizontalSeparators().set(i, maxRowHeight + this.getHorizontalSeparators().get(i - 1));
        }
    }

    private Point processSection(BaseColumn column, int x, int y, int row, int col, int availableHeight, int availableRows, byte sectionType, String groupName) {
        Point p = new Point(column.getWidth(), 1);
        DesignCell cell = (DesignCell)this.getCellOfType(column, sectionType, groupName);
        if (column instanceof StandardColumn) {
            this.addCell(x, y, row, col, column, cell, availableRows, 1, sectionType, groupName);
            return p;
        }
        if (column instanceof StandardColumnGroup) {
            int exceedingVerticalCells = 0;
            int rowHeight = 0;
            if (cell != null) {
                rowHeight = cell.getHeight();
                if (cell.getRowSpan() != null) {
                    int nestedRows;
                    exceedingVerticalCells = cell.getRowSpan() - 1;
                    if (exceedingVerticalCells < 0) {
                        exceedingVerticalCells = 0;
                    }
                    if (exceedingVerticalCells + 1 > availableRows - (nestedRows = this.getSectionRows((StandardColumnGroup)column, sectionType, groupName))) {
                        exceedingVerticalCells = availableRows - nestedRows - 1;
                    }
                }
            }
            int nextRow = row;
            int nextAvailableRows = availableRows;
            if (sectionType != 3) {
                int horiz = this.getHorizontalSeparators().get(row + exceedingVerticalCells + 1);
                if (horiz < y + rowHeight) {
                    this.getHorizontalSeparators().set(row + exceedingVerticalCells + 1, y + rowHeight);
                }
                nextRow = row + 1 + exceedingVerticalCells;
                nextAvailableRows = availableRows - 1 - exceedingVerticalCells;
            }
            List subColumns = ((StandardColumnGroup)column).getColumns();
            int subCol = 0;
            int subX = 0;
            for (BaseColumn subColumn : subColumns) {
                Point coords = this.processSection(subColumn, x + subX, y + rowHeight, nextRow, col + subCol, availableHeight - rowHeight, nextAvailableRows, sectionType, groupName);
                subX += coords.x;
                subCol += coords.y;
            }
            if (sectionType != 3) {
                this.addCell(x, y, row, col, column, cell, 1 + exceedingVerticalCells, subCol, sectionType, groupName);
            }
            p.x = x + subX;
            p.y = subCol;
        }
        return p;
    }

    private void addCell(int x, int y, int row, int col, BaseColumn baseColumn, DesignCell cell, int rowSpan, int colSpan, byte cellType, String groupName) {
        TableCell tableCell = new TableCell();
        tableCell.setCol(col);
        tableCell.setRow(row);
        tableCell.setType(cellType);
        tableCell.setGroupName(groupName);
        tableCell.setCell(cell);
        tableCell.setColSpan(colSpan);
        tableCell.setRowSpan(rowSpan);
        tableCell.setColumn(baseColumn);
        this.cells.add(tableCell);
    }

    private int getSectionHeight(byte sectionType) {
        return this.getSectionHeight(sectionType, null);
    }

    private int getSectionHeight(byte sectionType, String groupName) {
        int height = 0;
        List columns = this.getTable().getColumns();
        for (BaseColumn c : columns) {
            if (c instanceof StandardColumn) {
                Cell cell = this.getCellOfType(c, sectionType, groupName);
                if (cell == null || cell.getHeight() <= height) continue;
                height = cell.getHeight();
                continue;
            }
            if (!(c instanceof StandardColumnGroup)) continue;
            int gh = this.getSectionHeight((StandardColumnGroup)c, sectionType, groupName);
            height = gh > height ? gh : height;
        }
        return height;
    }

    private int getSectionHeight(StandardColumnGroup standardColumnGroup, byte sectionType, String groupName) {
        int headerHeight = 0;
        Cell cell = this.getCellOfType((BaseColumn)standardColumnGroup, sectionType, groupName);
        if (cell != null) {
            headerHeight = cell.getHeight();
        }
        List columns = standardColumnGroup.getColumns();
        int maxChildrenHeaderHeight = 0;
        for (BaseColumn c : columns) {
            if (c instanceof StandardColumn) {
                cell = this.getCellOfType(c, sectionType, groupName);
                if (cell == null || cell.getHeight() <= maxChildrenHeaderHeight) continue;
                maxChildrenHeaderHeight = cell.getHeight();
                continue;
            }
            if (!(c instanceof StandardColumnGroup)) continue;
            int gh = this.getSectionHeight((StandardColumnGroup)c, sectionType, groupName);
            maxChildrenHeaderHeight = gh > maxChildrenHeaderHeight ? gh : maxChildrenHeaderHeight;
        }
        return headerHeight + maxChildrenHeaderHeight;
    }

    private int getSectionRows(byte sectionType) {
        return this.getSectionRows(sectionType, null);
    }

    private int getSectionRows(byte sectionType, String groupName) {
        return this.getSectionRows(null, sectionType, groupName);
    }

    private int getSectionRows(Object parent, byte sectionType, String groupName) {
        if (sectionType == 3) {
            return 1;
        }
        List columns = parent == null ? this.getTable().getColumns() : TableModelUtils.getColumns(parent);
        int maxChildRows = 0;
        for (BaseColumn c : columns) {
            if (!(c instanceof StandardColumnGroup)) continue;
            int rows = this.getSectionRows((StandardColumnGroup)c, sectionType, groupName);
            maxChildRows = rows > maxChildRows ? rows : maxChildRows;
        }
        return maxChildRows + 1;
    }

    private Cell getCellOfType(BaseColumn col, byte sectionType, String groupName) {
        if (col == null) {
            return null;
        }
        switch (sectionType) {
            case 0: {
                return col.getTableHeader();
            }
            case 1: {
                return col.getColumnHeader();
            }
            case 2: {
                return col.getGroupHeader(groupName);
            }
            case 6: {
                return col.getTableFooter();
            }
            case 5: {
                return col.getColumnFooter();
            }
            case 4: {
                return col.getGroupFooter(groupName);
            }
            case 3: {
                if (!(col instanceof StandardColumn)) break;
                return ((StandardColumn)col).getDetailCell();
            }
        }
        return null;
    }

    public List<TableCell> getCells() {
        return this.cells;
    }

    private void createVerticalSeparators() {
        this.verticalSeparators = new ArrayList<Integer>();
        int pos = 0;
        this.verticalSeparators.add(pos);
        List<StandardColumn> cols = this.getStandardColumns();
        for (StandardColumn c : cols) {
            this.verticalSeparators.add(pos += c.getWidth().intValue());
        }
    }

    public List<Integer> getVerticalSeparators() {
        return this.verticalSeparators;
    }

    public List<Integer> getHorizontalSeparators() {
        return this.horizontalSeparators;
    }

    public Point getCellLocation(DesignCell designCell) {
        for (TableCell tc : this.cells) {
            if (tc.getCell() != designCell) continue;
            return this.getCellLocation(tc);
        }
        return new Point(0, 0);
    }

    public Point getCellLocation(TableCell tc) {
        return new Point(this.getVerticalSeparators().get(tc.getCol()), this.getHorizontalSeparators().get(tc.getRow()));
    }

    public Rectangle getCellBounds(DesignCell designCell) {
        for (TableCell tc : this.cells) {
            if (tc.getCell() != designCell) continue;
            return this.getCellBounds(tc);
        }
        return null;
    }

    public Rectangle getCellBounds(TableCell tc) {
        int x = this.getVerticalSeparators().get(tc.getCol());
        int y = this.getHorizontalSeparators().get(tc.getRow());
        int w = this.getVerticalSeparators().get(tc.getCol() + tc.getColSpan()) - x;
        int h = this.getHorizontalSeparators().get(tc.getRow() + tc.getRowSpan()) - y;
        return new Rectangle(x, y, w, h);
    }

    public StandardTable getTable() {
        return this.table;
    }

    public void setTable(StandardTable table) {
        this.table = table;
    }

    public StandardColumn getColumn(int i) {
        return this.getStandardColumns().get(i);
    }

    public List<StandardColumn> getStandardColumns() {
        ArrayList<StandardColumn> standardColumns = new ArrayList<StandardColumn>();
        List columns = this.getTable().getColumns();
        for (BaseColumn c : columns) {
            standardColumns.addAll(this.getStandardColumns(c));
        }
        return standardColumns;
    }

    private List<StandardColumn> getStandardColumns(BaseColumn col) {
        ArrayList<StandardColumn> standardColumns = new ArrayList<StandardColumn>();
        if (col instanceof StandardColumn) {
            standardColumns.add((StandardColumn)col);
        } else if (col instanceof StandardColumnGroup) {
            StandardColumnGroup columnGroup = (StandardColumnGroup)col;
            List columns = columnGroup.getColumns();
            for (BaseColumn c : columns) {
                standardColumns.addAll(this.getStandardColumns(c));
            }
        }
        return standardColumns;
    }

    boolean isValidBase(int i) {
        for (TableCell cell : this.getCells()) {
            if (cell.getRow() + 1 != i || cell.getRowSpan() != 1 || cell.getCell() == null) continue;
            return true;
        }
        return false;
    }

    public TableCell getCellAt(Point point) {
        for (TableCell cell : this.getCells()) {
            if (!this.getCellBounds(cell).contains(point)) continue;
            return cell;
        }
        return null;
    }

    public BaseColumn getColumnAt(Point point) {
        for (TableCell cell : this.getCells()) {
            Rectangle r = this.getCellBounds(cell);
            if (point.x < r.x || point.x > r.x + r.width) continue;
            return cell.getColumn();
        }
        return null;
    }

    public TableCell findTableCell(BaseColumn column, byte section, String grpName) {
        for (TableCell cell : this.getCells()) {
            if (cell.getColumn() != column || cell.getType() != section || (cell.getType() == 4 || cell.getType() == 2) && !cell.getGroupName().equals(grpName)) continue;
            return cell;
        }
        return null;
    }

    public Rectangle getColumnBounds(BaseColumn column) {
        for (TableCell cell : this.cells) {
            if (cell.getColumn() != column || cell.getType() != 0) continue;
            Rectangle r = this.getCellBounds(cell);
            r.height = this.getHorizontalSeparators().get(this.getHorizontalSeparators().size() - 1) - r.y;
            return r;
        }
        return null;
    }

    public Rectangle getSectionBounds(byte section, String grpName) {
        Rectangle rect = null;
        for (TableCell cell : this.cells) {
            if (cell.getType() != section || cell.getGroupName() != null && !cell.getGroupName().equals(grpName)) continue;
            Rectangle r = this.getCellBounds(cell);
            if (rect == null) {
                rect = r;
                continue;
            }
            if (r.x < rect.x) {
                rect.x = r.x;
            }
            if (r.y < rect.y) {
                rect.y = r.y;
            }
            if (r.y + r.height > rect.y + rect.height) {
                rect.height = r.y + r.height - rect.y;
            }
            if (r.x + r.width <= rect.x + rect.width) continue;
            rect.width = r.x + r.width - rect.x;
        }
        return rect;
    }

    public int getColumnIndex(BaseColumn column) {
        for (TableCell cell : this.cells) {
            if (cell.getColumn() != column) continue;
            return cell.getCol();
        }
        return -1;
    }

    public Object getColumnParent(BaseColumn column) {
        List columns = this.getTable().getColumns();
        for (BaseColumn c : columns) {
            StandardColumnGroup parent;
            if (c == column) {
                return this.getTable();
            }
            if (!(c instanceof StandardColumnGroup) || (parent = this.getColumnParent(column, (StandardColumnGroup)c)) == null) continue;
            return parent;
        }
        return null;
    }

    private StandardColumnGroup getColumnParent(BaseColumn column, StandardColumnGroup standardColumnGroup) {
        List columns = standardColumnGroup.getColumns();
        for (BaseColumn c : columns) {
            StandardColumnGroup parent;
            if (c == column) {
                return standardColumnGroup;
            }
            if (!(c instanceof StandardColumnGroup) || (parent = this.getColumnParent(column, (StandardColumnGroup)c)) == null) continue;
            return parent;
        }
        return null;
    }

    public static boolean isAncestorColumnOf(BaseColumn child, BaseColumn parent) {
        if (parent == child) {
            return true;
        }
        if (parent instanceof StandardColumnGroup) {
            for (BaseColumn c : ((StandardColumnGroup)parent).getColumns()) {
                if (!TableMatrix.isAncestorColumnOf(child, c)) continue;
                return true;
            }
        }
        return false;
    }

    public void moveColumn(BaseColumn column, Object newParent, int newPosition) {
        List newColumns;
        if (column == null) {
            return;
        }
        if (newParent == null) {
            return;
        }
        if (!(newParent instanceof StandardColumnGroup) && !(newParent instanceof StandardTable)) {
            return;
        }
        Object aParent = newParent;
        while (!(aParent instanceof StandardTable)) {
            if ((aParent = this.getColumnParent((BaseColumn)aParent)) != null) continue;
            return;
        }
        if (aParent != this.getTable()) {
            return;
        }
        aParent = column;
        while (!(aParent instanceof StandardTable)) {
            if ((aParent = this.getColumnParent((BaseColumn)aParent)) != null) continue;
            return;
        }
        if (aParent != this.getTable()) {
            return;
        }
        if (newParent instanceof StandardColumnGroup && TableMatrix.isAncestorColumnOf((BaseColumn)((StandardColumnGroup)newParent), column)) {
            return;
        }
        Object oldParent = this.getColumnParent(column);
        List oldColumns = oldParent instanceof StandardTable ? ((StandardTable)oldParent).getColumns() : ((StandardColumnGroup)oldParent).getColumns();
        List list = newColumns = newParent instanceof StandardTable ? ((StandardTable)newParent).getColumns() : ((StandardColumnGroup)newParent).getColumns();
        if (newParent == oldParent) {
            if (oldColumns.size() == 1) {
                return;
            }
            int oldIndex = oldColumns.indexOf(column);
            if (newPosition > oldIndex) {
                --newPosition;
            }
            oldColumns.remove(column);
            if (newPosition < 0 || newPosition > oldColumns.size()) {
                newPosition = oldColumns.size();
            }
            oldColumns.add(newPosition, column);
            if (newParent instanceof StandardTable) {
                ((StandardTable)newParent).getEventSupport().firePropertyChange("columns", null, (Object)oldColumns);
            } else {
                ((StandardColumnGroup)newParent).getEventSupport().firePropertyChange("columns", null, (Object)oldColumns);
            }
            DeleteTableColumnUndoableEdit edit = new DeleteTableColumnUndoableEdit(this.getTable(), this.getJasperDesign(), column, oldParent, oldIndex);
            AddTableColumnUndoableEdit edit2 = new AddTableColumnUndoableEdit(this.getTable(), this.getJasperDesign(), column, newParent, newPosition);
            edit.concatenate((UndoableEdit)((Object)edit2));
            edit.setPresentationName("Move Column");
            IReportManager.getInstance().addUndoableEdit((UndoableEdit)((Object)edit));
            TableModelUtils.fixTableLayout(this.getTable(), this.getJasperDesign());
        } else {
            if (oldColumns.size() == 1 && JOptionPane.showConfirmDialog(Misc.getMainFrame(), "You are moving a column from a group which contains only this column.\nA column group must have at least a column.\nIf you continue, the column group will be removed.\n\nContinue anyway?", "Deleting Column Group", 1, 2, ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"com/jaspersoft/ireport/components/table/deleting_group.png"))) != 0) {
                return;
            }
            int oldIndex = oldColumns.indexOf(column);
            oldColumns.remove(column);
            DeleteTableColumnUndoableEdit edit = new DeleteTableColumnUndoableEdit(this.getTable(), this.getJasperDesign(), column, oldParent, oldIndex);
            while (oldColumns.size() == 0 && oldParent instanceof StandardColumnGroup) {
                Object oldParentParent = this.getColumnParent((BaseColumn)((StandardColumnGroup)oldParent));
                if (oldParentParent == null) continue;
                if (oldParentParent instanceof StandardTable) {
                    oldIndex = ((StandardTable)oldParentParent).getColumns().indexOf((StandardColumnGroup)oldParent);
                    ((StandardTable)oldParentParent).removeColumn((BaseColumn)((StandardColumnGroup)oldParent));
                    edit.concatenate((UndoableEdit)((Object)new DeleteTableColumnUndoableEdit(this.getTable(), this.getJasperDesign(), (BaseColumn)((StandardColumnGroup)oldParent), oldParentParent, oldIndex)));
                    oldColumns = ((StandardTable)oldParentParent).getColumns();
                    oldParent = oldParentParent;
                    continue;
                }
                oldIndex = ((StandardColumnGroup)oldParentParent).getColumns().indexOf((StandardColumnGroup)oldParent);
                ((StandardColumnGroup)oldParentParent).removeColumn((BaseColumn)((StandardColumnGroup)oldParent));
                edit.concatenate((UndoableEdit)((Object)new DeleteTableColumnUndoableEdit(this.getTable(), this.getJasperDesign(), (BaseColumn)((StandardColumnGroup)oldParent), oldParentParent, oldIndex)));
                oldColumns = ((StandardColumnGroup)oldParentParent).getColumns();
                oldParent = oldParentParent;
            }
            if (oldParent != newParent) {
                if (oldParent instanceof StandardTable) {
                    ((StandardTable)oldParent).getEventSupport().firePropertyChange("columns", null, (Object)oldColumns);
                } else {
                    ((StandardColumnGroup)oldParent).getEventSupport().firePropertyChange("columns", null, (Object)oldColumns);
                }
            }
            if (newPosition < 0 || newPosition > newColumns.size()) {
                newPosition = newColumns.size();
            }
            newColumns.add(newPosition, column);
            if (newParent instanceof StandardTable) {
                ((StandardTable)newParent).getEventSupport().firePropertyChange("columns", null, (Object)newColumns);
            } else {
                ((StandardColumnGroup)newParent).getEventSupport().firePropertyChange("columns", null, (Object)newColumns);
            }
            AddTableColumnUndoableEdit edit2 = new AddTableColumnUndoableEdit(this.getTable(), this.getJasperDesign(), column, newParent, newPosition);
            edit.concatenate((UndoableEdit)((Object)edit2));
            edit.setPresentationName("Move Column");
            IReportManager.getInstance().addUndoableEdit((UndoableEdit)((Object)edit));
            TableModelUtils.fixTableLayout(this.getTable(), this.getJasperDesign());
        }
    }

    public int getTableDesignHeight() {
        return this.getHorizontalSeparators().get(this.getHorizontalSeparators().size() - 1);
    }

    public int getTableDesignWidth() {
        return this.getVerticalSeparators().get(this.getVerticalSeparators().size() - 1);
    }

    public TableCell getTableCell(DesignCell designCell) {
        for (TableCell cell : this.cells) {
            if (cell.getCell() != designCell) continue;
            return cell;
        }
        return null;
    }

    public int getMaxRowSpan(DesignCell designCell) {
        TableCell cell = this.getTableCell(designCell);
        if (cell.getColumn() instanceof StandardColumn) {
            return 1;
        }
        int totalSectionRows = this.getSectionRows(this.getColumnParent(cell.getColumn()), (byte)cell.getType(), cell.getGroupName());
        int otherRows = this.getSectionRows((StandardColumnGroup)cell.getColumn(), (byte)cell.getType(), cell.getGroupName());
        return totalSectionRows - otherRows;
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
    }
}

