/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.map;

import com.jaspersoft.ireport.designer.editor.ExpressionEditorArea;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jasperreports.components.map.StandardMarkerProperty;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.openide.util.NbBundle;

public class MarkerPropertyPanel
extends JPanel {
    private boolean init = false;
    private StandardMarkerProperty markerProperty = new StandardMarkerProperty();
    private ExpressionEditorArea jrExpressionArea = new ExpressionEditorArea();
    private JCheckBox jCheckBox1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;

    public MarkerPropertyPanel() {
        this.initComponents();
        this.jrExpressionArea.getExpressionEditorPane().getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                MarkerPropertyPanel.this.jRTextExpressionAreaTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                MarkerPropertyPanel.this.jRTextExpressionAreaTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                MarkerPropertyPanel.this.jRTextExpressionAreaTextChanged();
            }
        });
        this.jTextArea1.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                MarkerPropertyPanel.this.jTextAreaTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                MarkerPropertyPanel.this.jTextAreaTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                MarkerPropertyPanel.this.jTextAreaTextChanged();
            }
        });
    }

    public void jRTextExpressionAreaTextChanged() {
        if (this.isInit()) {
            return;
        }
        if (this.markerProperty != null) {
            JRDesignExpression exp = null;
            if (this.jrExpressionArea.getText().trim().length() > 0) {
                exp = new JRDesignExpression();
                exp.setText(this.jrExpressionArea.getText());
            }
            this.markerProperty.setValueExpression((JRExpression)exp);
        }
    }

    public void jTextAreaTextChanged() {
        if (this.isInit()) {
            return;
        }
        if (this.markerProperty != null) {
            this.markerProperty.setValue(this.jTextArea1.getText());
        }
    }

    private void initComponents() {
        this.jCheckBox1 = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MarkerPropertyPanel.class, (String)"MarkerPropertyPanel.border.title")));
        this.setLayout(new GridBagLayout());
        this.jCheckBox1.setText(NbBundle.getMessage(MarkerPropertyPanel.class, (String)"MarkerPropertyPanel.jCheckBox1.text"));
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MarkerPropertyPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jCheckBox1, gridBagConstraints);
        this.jPanel1.setLayout(new BorderLayout());
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        if (this.jCheckBox1.isSelected()) {
            this.markerProperty.setValue(null);
            this.markerProperty.setValueExpression((JRExpression)Misc.createExpression(null, (String)""));
        } else {
            this.markerProperty.setValueExpression(null);
            this.markerProperty.setValue("");
        }
        this.updateEditorComponent();
    }

    public StandardMarkerProperty getMarkerProperty() {
        return this.markerProperty;
    }

    public void setMarkerProperty(StandardMarkerProperty markerProperty) {
        this.setInit(true);
        this.markerProperty = markerProperty;
        ((TitledBorder)this.getBorder()).setTitle(markerProperty.getName());
        this.updateUI();
        this.jCheckBox1.setSelected(markerProperty.getValue() == null);
        this.updateEditorComponent();
        if (markerProperty.getValue() != null) {
            this.jTextArea1.setText(markerProperty.getValue() + "");
        } else {
            this.jrExpressionArea.setText(Misc.getExpressionText((JRExpression)markerProperty.getValueExpression()));
        }
        this.setInit(false);
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    private void updateEditorComponent() {
        this.jPanel1.removeAll();
        if (this.jCheckBox1.isSelected()) {
            this.jPanel1.removeAll();
            this.jPanel1.add((Component)this.jrExpressionArea, "Center");
        } else {
            this.jPanel1.add((Component)this.jTextArea1, "Center");
        }
        this.jPanel1.updateUI();
    }
}

