/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.expressions.functions;

import net.sf.jasperreports.expressions.annotations.JRExprFunction;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionCategories;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionParameter;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionParameters;

public final class LogicalFunctions {
    @JRExprFunction(name="AND", description="Returns true if all arguments are considered true, false otherwise. Argument must be a logical result or a direct boolean value.")
    @JRExprFunctionCategories(value={"LOGICAL"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Argument", description="A boolean expression or value.")})
    public static Boolean AND(Boolean ... arguments) {
        if (arguments.length == 0) {
            return null;
        }
        boolean result = true;
        for (Boolean arg : arguments) {
            boolean bl = result = result && arg != false;
            if (result) continue;
            return false;
        }
        return result;
    }

    @JRExprFunction(name="FALSE", description="Returns the logical value FALSE.")
    @JRExprFunctionCategories(value={"LOGICAL"})
    public static Boolean FALSE() {
        return Boolean.FALSE;
    }

    @JRExprFunction(name="TRUE", description="Returns the logical value TRUE.")
    @JRExprFunctionCategories(value={"LOGICAL"})
    public static Boolean TRUE() {
        return Boolean.TRUE;
    }

    @JRExprFunction(name="NOT", description="Returns the negation of the specified boolean expression.")
    @JRExprFunctionCategories(value={"LOGICAL"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Argument", description="A boolean expression or value.")})
    public static Boolean NOT(Boolean boolValue) {
        if (boolValue == null) {
            return null;
        }
        return boolValue == false;
    }

    @JRExprFunction(name="OR", description="Returns true if any of the arguments is considered true, false otherwise. Argument must be a logical result or a direct boolean value.")
    @JRExprFunctionCategories(value={"LOGICAL"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Argument", description="A boolean expression or value.")})
    public static Boolean OR(Boolean ... arguments) {
        if (arguments.length == 0) {
            return null;
        }
        boolean result = false;
        for (Boolean arg : arguments) {
            boolean bl = result = result || arg != false;
            if (!result) continue;
            return true;
        }
        return result;
    }

    @JRExprFunction(name="IF", description="Returns one of two values, depending on a test condition.")
    @JRExprFunctionCategories(value={"LOGICAL"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Test condition", description="An expression returning a boolean value."), @JRExprFunctionParameter(name="Value 1 (true)", description="The value returned when the test is true."), @JRExprFunctionParameter(name="Value 2 (false)", description="The value returned when the test is false.")})
    public static Object IF(Boolean test, Object value1, Object value2) {
        if (test == null) {
            return null;
        }
        return test != false ? value1 : value2;
    }

    @JRExprFunction(name="EQUALS", description="Checks if the two specified objects are equals.")
    @JRExprFunctionCategories(value={"LOGICAL"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Object 1", description="The first element to be compared."), @JRExprFunctionParameter(name="Object 2", description="The second element to be compared.")})
    public static Boolean EQUALS(Object obj1, Object obj2) {
        if (obj1 != null) {
            return obj1.equals(obj2);
        }
        if (obj2 != null) {
            return obj2.equals(obj1);
        }
        return true;
    }
}

