/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.DatabaseUser;
import org.netbeans.modules.db.mysql.impl.SampleManager;
import org.netbeans.modules.db.mysql.util.DatabaseUtils;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class CreateDatabasePanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(CreateDatabasePanel.class.getName());
    private DialogDescriptor descriptor;
    private Dialog dialog;
    private final DatabaseServer server;
    private final DatabaseComboModel databaseComboModel;
    private DatabaseConnection dbconn;
    private Color nbErrorForeground;
    private JButton okButton;
    private JButton cancelButton;
    private JCheckBox chkGrantAccess;
    private JComboBox comboDatabaseName;
    private JComboBox comboUsers;
    private JLabel messageLabel;
    private JLabel nameLabel;
    private JProgressBar progressBar;
    private JLabel progressLabel;

    private void validatePanel(String string) {
        if (this.descriptor == null) {
            return;
        }
        String string2 = null;
        this.comboUsers.setEnabled(this.isGrantAccess());
        if (Utils.isEmpty(string)) {
            string2 = NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.MSG_SpecifyDatabase");
        }
        if (this.isGrantAccess() && Utils.isEmpty((String)this.comboUsers.getSelectedItem())) {
            string2 = NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatbasePanel.MSG_NoGrantUserSelected");
        }
        if (string2 != null) {
            this.messageLabel.setText(string2);
            this.okButton.setEnabled(false);
        } else {
            this.messageLabel.setText(" ");
            this.okButton.setEnabled(true);
        }
    }

    private void startProgress() {
        this.setProgress(true);
    }

    private void stopProgress() {
        this.setProgress(false);
    }

    private void setProgress(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CreateDatabasePanel.this.comboDatabaseName.setEnabled(!bl);
                CreateDatabasePanel.this.okButton.setEnabled(!bl);
                if (!bl) {
                    CreateDatabasePanel.this.cancelButton.setEnabled(true);
                }
                CreateDatabasePanel.this.progressBar.setVisible(bl);
                CreateDatabasePanel.this.progressLabel.setVisible(bl);
                CreateDatabasePanel.this.progressBar.setIndeterminate(bl);
                CreateDatabasePanel.this.resize();
            }
        });
    }

    public DatabaseConnection showCreateDatabaseDialog() throws DatabaseException {
        assert (SwingUtilities.isEventDispatchThread());
        this.okButton = new JButton(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.CTL_OKButton"));
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.CTL_CancelButton"));
        ActionListener actionListener = new ActionListener(){
            RequestProcessor.Task task;

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(CreateDatabasePanel.this.okButton)) {
                    if (this.task != null && !this.task.isFinished()) {
                        return;
                    }
                    CreateDatabasePanel.this.startProgress();
                    this.task = RequestProcessor.getDefault().create(new Runnable(){

                        public void run() {
                            CreateDatabasePanel.this.createDatabase();
                            if (CreateDatabasePanel.this.isGrantAccess()) {
                                CreateDatabasePanel.this.grantAccess();
                            }
                        }
                    });
                    this.task.addTaskListener(new TaskListener(){

                        public void taskFinished(Task task) {
                            CreateDatabasePanel.this.stopProgress();
                            CreateDatabasePanel.this.dialog.dispose();
                        }
                    });
                    this.task.schedule(0);
                } else if (actionEvent.getSource().equals(CreateDatabasePanel.this.cancelButton)) {
                    CreateDatabasePanel.this.dialog.dispose();
                }
            }
        };
        this.okButton.addActionListener(actionListener);
        this.cancelButton.addActionListener(actionListener);
        String string = NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.LBL_CreateDatabaseTitle");
        this.descriptor = new DialogDescriptor((Object)this, string, true, (Object[])new JButton[]{this.okButton, this.cancelButton}, (Object)this.okButton, 0, HelpCtx.findHelp(CreateDatabasePanel.class), null);
        this.descriptor.setClosingOptions(new Object[0]);
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        String string2 = NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.ACSD_CreateNewDatabasePanel");
        this.dialog.getAccessibleContext().setAccessibleDescription(string2);
        this.stopProgress();
        this.dialog.setVisible(true);
        return this.dbconn;
    }

    private void grantAccess() {
        String string = this.getDatabaseName();
        DatabaseUser databaseUser = (DatabaseUser)this.comboUsers.getSelectedItem();
        assert (databaseUser != null);
        this.server.grantFullDatabaseRights(string, databaseUser);
    }

    private void createDatabase() {
        this.dbconn = null;
        String string = this.getDatabaseName();
        boolean bl = false;
        try {
            if (!this.ensureConnected()) {
                return;
            }
            if (!CreateDatabasePanel.checkExistingDatabase(this.server, this.getDatabaseName())) {
                return;
            }
            this.server.createDatabase(string);
            bl = true;
            this.dbconn = CreateDatabasePanel.createConnection(this.server, string);
            if (this.dbconn == null) {
                return;
            }
            boolean bl2 = false;
            if (SampleManager.isSample(string)) {
                bl2 = !this.databaseComboModel.isSelectedSample() ? Utils.displayYesNoDialog(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.MSG_ConfirmCreateSample", (Object)string)) : true;
            }
            if (bl2) {
                this.cancelButton.setEnabled(false);
                SampleManager.createSample(string, this.dbconn);
            }
        }
        catch (DatabaseException databaseException) {
            CreateDatabasePanel.displayCreateFailure(this.server, databaseException, string, bl);
            this.dbconn = null;
        }
    }

    private boolean ensureConnected() throws DatabaseException {
        try {
            this.server.validateConnection();
        }
        catch (DatabaseException databaseException) {
            LOGGER.log(Level.INFO, null, databaseException);
            Utils.displayError(databaseException.getMessage(), (Exception)((Object)databaseException));
        }
        if (this.server.isConnected()) {
            return true;
        }
        try {
            this.server.reconnect();
        }
        catch (TimeoutException timeoutException) {
            Utils.displayError(timeoutException.getMessage(), timeoutException);
            LOGGER.log(Level.INFO, null, timeoutException);
        }
        return this.server.isConnected();
    }

    private static void displayCreateFailure(DatabaseServer databaseServer, DatabaseException databaseException, String string, boolean bl) {
        LOGGER.log(Level.INFO, null, databaseException);
        Utils.displayError(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.MSG_CreateFailed"), (Exception)((Object)databaseException));
        if (bl) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.MSG_DeleteCreatedDatabase", (Object)string), NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.STR_DeleteCreatedDatabaseTitle"), 0);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (object == NotifyDescriptor.YES_OPTION) {
                databaseServer.dropDatabase(string);
            }
        }
    }

    private static boolean checkExistingDatabase(DatabaseServer databaseServer, String string) throws DatabaseException {
        if (!databaseServer.databaseExists(string)) {
            return true;
        }
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.MSG_DatabaseAlreadyExists", (Object)string));
        message.setTitle(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.STR_DatabaseExistsTitle"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        return false;
    }

    private static DatabaseConnection createConnection(DatabaseServer databaseServer, String string) throws DatabaseException {
        List<DatabaseConnection> list = DatabaseUtils.findDatabaseConnections(databaseServer.getURL(string));
        if (!list.isEmpty()) {
            return list.get(0);
        }
        DatabaseConnection databaseConnection = DatabaseConnection.create((JDBCDriver)DatabaseUtils.getJDBCDriver(), (String)databaseServer.getURL(string), (String)databaseServer.getUser(), null, (String)databaseServer.getPassword(), (boolean)false);
        ConnectionManager.getDefault().addConnection(databaseConnection);
        ConnectionManager.getDefault().connect(databaseConnection);
        return databaseConnection;
    }

    public CreateDatabasePanel(DatabaseServer databaseServer) throws DatabaseException {
        this.server = databaseServer;
        this.nbErrorForeground = UIManager.getColor("nb.errorForeground");
        if (this.nbErrorForeground == null) {
            this.nbErrorForeground = new Color(255, 0, 0);
        }
        this.initComponents();
        this.databaseComboModel = new DatabaseComboModel();
        this.comboDatabaseName.setModel(this.databaseComboModel);
        this.comboDatabaseName.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
                String string = Character.toString(keyEvent.getKeyChar()).trim();
                String string2 = Utils.isEmpty(string) ? CreateDatabasePanel.this.comboDatabaseName.getEditor().getItem().toString().trim() : string;
                CreateDatabasePanel.this.validatePanel(string2);
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.comboUsers.setModel(new UsersComboModel(databaseServer));
        if (this.comboUsers.getItemCount() == 0) {
            this.comboUsers.setVisible(false);
            this.chkGrantAccess.setVisible(false);
        } else {
            this.comboUsers.setSelectedIndex(0);
            this.setGrantAccess(false);
        }
        this.setBackground(this.getBackground());
        this.messageLabel.setBackground(this.getBackground());
        this.messageLabel.setText(" ");
    }

    private void resize() {
        this.revalidate();
        if (this.dialog != null) {
            this.dialog.pack();
        }
    }

    private String getDatabaseName() {
        String string = (String)this.comboDatabaseName.getSelectedItem();
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    private void setGrantAccess(boolean bl) {
        this.chkGrantAccess.setSelected(bl);
        this.comboUsers.setEnabled(bl);
    }

    private boolean isGrantAccess() {
        return this.chkGrantAccess.isSelected();
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.chkGrantAccess = new JCheckBox();
        this.comboDatabaseName = new JComboBox();
        this.comboUsers = new JComboBox();
        this.messageLabel = new JLabel();
        this.progressLabel = new JLabel();
        this.nameLabel.setLabelFor(this.comboDatabaseName);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.nameLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.chkGrantAccess, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.chkGrantAccess.text"));
        this.chkGrantAccess.setToolTipText(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.chkGrantAccess.AccessibleContext.accessibleDescription"));
        this.chkGrantAccess.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CreateDatabasePanel.this.chkGrantAccessItemStateChanged(itemEvent);
            }
        });
        this.comboDatabaseName.setEditable(true);
        this.comboDatabaseName.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.comboDatabaseName.setToolTipText(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.comboDatabaseName.AccessibleContext.accessibleDescription"));
        this.comboDatabaseName.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CreateDatabasePanel.this.comboDatabaseNameItemStateChanged(itemEvent);
            }
        });
        this.comboUsers.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.comboUsers.setToolTipText(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.comboUsers.AccessibleContext.accessibleDescription"));
        this.messageLabel.setForeground(new Color(255, 0, 51));
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.messageLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.progressLabel, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.progressLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add(2, (Component)this.nameLabel, -1, -1, Short.MAX_VALUE).add(2, (Component)this.chkGrantAccess, -1, 173, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.comboUsers, 0, 323, Short.MAX_VALUE).add((Component)this.comboDatabaseName, 0, 323, Short.MAX_VALUE))).add((Component)this.messageLabel, -1, 501, Short.MAX_VALUE).add((Component)this.progressBar, -1, 501, Short.MAX_VALUE).add((Component)this.progressLabel, -1, 501, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.nameLabel).add((Component)this.comboDatabaseName, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.chkGrantAccess).add((Component)this.comboUsers, -2, -1, -2)).addPreferredGap(1).add((Component)this.messageLabel).addPreferredGap(0).add((Component)this.progressBar, -2, -1, -2).addPreferredGap(0).add((Component)this.progressLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.comboDatabaseName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.comboDatabaseName.AccessibleContext.accessibleName"));
        this.comboDatabaseName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.comboDatabaseName.AccessibleContext.accessibleDescription"));
        this.comboUsers.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.comboUsers.AccessibleContext.accessibleName"));
        this.comboUsers.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.comboUsers.AccessibleContext.accessibleDescription"));
    }

    private void comboDatabaseNameItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.validatePanel(itemEvent.getItem().toString().trim());
        }
    }

    private void chkGrantAccessItemStateChanged(ItemEvent itemEvent) {
        this.comboUsers.setEnabled(this.isGrantAccess());
    }

    private static class UsersComboModel
    implements ComboBoxModel {
        final DatabaseServer server;
        ArrayList<DatabaseUser> users = new ArrayList();
        DatabaseUser selected;

        public UsersComboModel(DatabaseServer databaseServer) throws DatabaseException {
            this.server = databaseServer;
            try {
                this.users.addAll(databaseServer.getUsers());
                DatabaseUser databaseUser = null;
                for (DatabaseUser databaseUser2 : this.users) {
                    if (databaseUser2.getUser() == null || !databaseUser2.getUser().equals("root")) continue;
                    databaseUser = databaseUser2;
                    break;
                }
                if (databaseUser != null) {
                    this.users.remove(databaseUser);
                }
            }
            catch (DatabaseException databaseException) {
                if (!databaseServer.isConnected()) {
                    throw databaseException;
                }
                LOGGER.log(Level.INFO, null, databaseException);
                this.users.clear();
            }
        }

        public void setSelectedItem(Object object) {
            this.selected = (DatabaseUser)object;
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public int getSize() {
            return this.users.size();
        }

        public Object getElementAt(int n) {
            return this.users.get(n);
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }

    private static class DatabaseComboModel
    implements ComboBoxModel {
        private final List<String> sampleNames = SampleManager.getSampleNames();
        static final String SAMPLE_PREFIX = NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.STR_SampleDatabase") + ": ";
        String selected = null;
        final ArrayList<ListDataListener> listeners = new ArrayList();

        private DatabaseComboModel() {
        }

        public void setSelectedItem(Object object) {
            this.selected = (String)object;
        }

        public boolean isSelectedSample() {
            return this.selected != null && this.selected.startsWith(SAMPLE_PREFIX);
        }

        public Object getSelectedItem() {
            if (this.isSelectedSample()) {
                return this.selected.replace(SAMPLE_PREFIX, "");
            }
            if (this.selected != null) {
                return this.selected;
            }
            return "";
        }

        public int getSize() {
            return this.sampleNames.size();
        }

        public Object getElementAt(int n) {
            if (n < 0) {
                return null;
            }
            return SAMPLE_PREFIX + this.sampleNames.get(n).toString();
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }
}

