/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.filtertree;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import rex.graphics.TreeElement;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.dimensiontree.elements.HierarchyElement;
import rex.graphics.dimensiontree.elements.LevelElement;
import rex.graphics.filtertree.elements.FilterTreeRootElement;
import rex.metadata.QueryElement;
import rex.metadata.ServerMetadata;
import rex.metadata.UniqueNameElement;
import rex.utils.I18n;

public class FilterTreeModel
implements TreeModel {
    private Vector treeModelListeners;
    private TreeElement root;
    private ServerMetadata smd;
    private boolean flattenDimensions = true;
    protected static int MAX_CHILDREN_COUNT_ASK = 1001;
    protected static int MAX_CHILDREN_COUNT_DONT_ASK = 1;
    private LinkedList enabledMembersList;
    private LinkedList disabledMembersList;
    private DimensionTreeElement filterDimension;

    public FilterTreeModel(ServerMetadata _smd, DimensionTreeElement _filterDimension, LinkedList _enabledMembersList) {
        this.root = new TreeElement(new FilterTreeRootElement(_filterDimension), null);
        ((FilterTreeRootElement)this.root.getUserObject()).setFlattenDimensions(this.flattenDimensions);
        this.smd = _smd;
        this.enabledMembersList = _enabledMembersList;
        this.disabledMembersList = new LinkedList();
        this.filterDimension = _filterDimension;
        this.treeModelListeners = new Vector();
        this.buildTree();
    }

    public void buildTree() {
        DimensionTreeElement[] levhier = ((FilterTreeRootElement)this.root.getUserObject()).getChildren(false);
        if (levhier != null) {
            for (int i = 0; levhier != null && i < levhier.length; ++i) {
                TreeElement lh = new TreeElement(levhier[i], this.root);
                this.root.addChild(lh);
                this.buildTreeRecursively(lh);
            }
            this.setEnabledFlagsRec(this.root);
            this.fireTreeStructureChanged(this.root);
        } else {
            JOptionPane.showMessageDialog(null, I18n.getString("msgText.noDimensions"), I18n.getString("msgTitle.getDimensions"), 0);
        }
    }

    private void buildTreeRecursively(TreeElement parent) {
        DimensionTreeElement current = (DimensionTreeElement)parent.getUserObject();
        if (current.getChildrenCount() < MAX_CHILDREN_COUNT_DONT_ASK) {
            DimensionTreeElement[] dte = current.getChildren(false);
            for (int i = 0; dte != null && i < dte.length; ++i) {
                TreeElement node = new TreeElement(dte[i], parent);
                parent.addChild(node);
                if (dte[i].getChildrenCount() <= 0) continue;
                if (dte[i].getChildrenCount() >= MAX_CHILDREN_COUNT_DONT_ASK) continue;
                this.buildTreeRecursively(node);
            }
        }
    }

    protected void addChildrenOneLevel(TreeElement parent) {
        DimensionTreeElement[] dte = ((DimensionTreeElement)parent.getUserObject()).getChildren(true);
        for (int i = 0; dte != null && i < dte.length; ++i) {
            TreeElement node = new TreeElement(dte[i], parent);
            parent.addChild(node);
        }
        this.setEnabledFlagsRec(parent);
    }

    private void setEnabledFlagsRec(TreeElement parent) {
        DimensionTreeElement dte = (DimensionTreeElement)parent.getUserObject();
        dte.setEnabled(this.isEnabled((UniqueNameElement)((Object)dte)));
        for (int i = 0; i < parent.getChildCount(); ++i) {
            this.setEnabledFlagsRec(parent.getChildAt(i));
        }
    }

    private boolean isEnabled(UniqueNameElement une) {
        if (this.enabledMembersList.size() > 0) {
            ListIterator it = this.enabledMembersList.listIterator();
            while (it.hasNext()) {
                if (!((UniqueNameElement)it.next()).getUniqueName().equals(une.getUniqueName())) continue;
                return true;
            }
            return false;
        }
        ListIterator it = this.disabledMembersList.listIterator();
        while (it.hasNext()) {
            if (!((UniqueNameElement)it.next()).getUniqueName().equals(une.getUniqueName())) continue;
            return false;
        }
        return true;
    }

    protected String getEnabledMembersCaption() {
        ListIterator it;
        StringBuffer retVal = new StringBuffer("<html>Enabled members are");
        if (this.enabledMembersList.size() == 0) {
            retVal.append(" <b>ALL</b> but these members:");
            it = this.disabledMembersList.listIterator();
        } else {
            retVal.append(":");
            it = this.enabledMembersList.listIterator();
        }
        while (it.hasNext()) {
            retVal.append("<br><b>" + ((UniqueNameElement)it.next()).getUniqueName() + "</b>");
        }
        retVal.append("</html>");
        return retVal.toString();
    }

    protected void enableMember(DimensionTreeElement dte) {
        dte.setEnabled(true);
        if (this.enabledMembersList.size() > 0) {
            this.enabledMembersList.add(dte);
        } else {
            this.removeFromList((UniqueNameElement)((Object)dte), this.disabledMembersList);
        }
    }

    protected void disableMember(DimensionTreeElement dte) {
        dte.setEnabled(false);
        if (this.enabledMembersList.size() > 0) {
            this.removeFromList((UniqueNameElement)((Object)dte), this.enabledMembersList);
        } else {
            this.disabledMembersList.add(dte);
        }
    }

    private void removeFromList(UniqueNameElement une, LinkedList ll) {
        ListIterator it = ll.listIterator();
        while (it.hasNext()) {
            if (!((UniqueNameElement)it.next()).getUniqueName().equals(une.getUniqueName())) continue;
            it.previous();
            it.remove();
        }
    }

    protected void setAllButThisMember(UniqueNameElement une) {
        this.enabledMembersList.clear();
        this.disabledMembersList.clear();
        this.disabledMembersList.add(une);
        this.setEnabledFlagsRec(this.root);
    }

    protected void setOnlyThisMember(UniqueNameElement une) {
        this.enabledMembersList.clear();
        this.enabledMembersList.add(une);
        this.setEnabledFlagsRec(this.root);
    }

    public boolean isFilttering() {
        return this.enabledMembersList.size() != 0 || this.disabledMembersList.size() != 0;
    }

    public boolean isDisplayedInTab() {
        return ((FilterTreeRootElement)this.root.getUserObject()).isDisplayInTab();
    }

    public String getCaption() {
        return ((FilterTreeRootElement)this.root.getUserObject()).toString();
    }

    public QueryElement getAnyQueryElement() {
        if (this.root.getChildCount() > 0) {
            return (LevelElement)this.root.getChildAt(0).getUserObject();
        }
        return null;
    }

    public String getQueryWithMemberExpression() {
        ListIterator it;
        StringBuffer expr = new StringBuffer("\n   MEMBER ");
        expr.append(this.getAggregateMemberName() + "\n    AS 'Aggregate(");
        if (this.enabledMembersList.size() == 0) {
            it = this.disabledMembersList.listIterator();
            expr.append("\n       Except(" + this.filterDimension.getUniqueName() + ".Members, ");
        } else {
            it = this.enabledMembersList.listIterator();
        }
        expr.append("\n          {");
        while (it.hasNext()) {
            if (it.hasPrevious()) {
                expr.append("\n          , " + ((UniqueNameElement)it.next()).getUniqueName());
                continue;
            }
            expr.append("\n            " + ((UniqueNameElement)it.next()).getUniqueName());
        }
        expr.append("\n          }");
        if (this.enabledMembersList.size() == 0) {
            expr.append("\n       )");
        }
        expr.append("\n      )'");
        return expr.toString();
    }

    private String getAggregateMemberName() {
        String uName = this.filterDimension instanceof LevelElement ? ((LevelElement)this.filterDimension).getHierarchyUniqueName() : (this.filterDimension instanceof HierarchyElement ? ((HierarchyElement)this.filterDimension).getHierarchyUniqueName() : this.filterDimension.getDimensionUniqueName());
        return uName + ".[Filter members from " + uName.replace('[', '(').replace(']', ')') + "]";
    }

    public String getQueryWhereExpression() {
        return this.getAggregateMemberName();
    }

    protected void fireTreeStructureChanged(TreeElement oldRoot) {
        int len = this.treeModelListeners.size();
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{oldRoot});
        for (int i = 0; i < len; ++i) {
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeStructureChanged(e);
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.addElement(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        TreeElement p = (TreeElement)parent;
        return p.getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        TreeElement p = (TreeElement)parent;
        return p.getChildCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        TreeElement p = (TreeElement)parent;
        return p.getIndexOfChild((TreeElement)child);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        DimensionTreeElement dte = (DimensionTreeElement)((TreeElement)node).getUserObject();
        return dte.getChildrenCount() == 0;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.removeElement(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

