/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRMeasuredText;
import net.sf.jasperreports.engine.fill.JRTextMeasurer;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRSingletonCache;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextMeasurerUtil;
import net.sf.jasperreports.engine.util.MarkupProcessor;
import net.sf.jasperreports.engine.util.MarkupProcessorFactory;

public abstract class JRFillTextElement
extends JRFillElement
implements JRTextElement {
    public static final String PROPERTY_CONSUME_SPACE_ON_OVERFLOW = "net.sf.jasperreports.consume.space.on.overflow";
    private static final JRSingletonCache<MarkupProcessorFactory> markupProcessorFactoryCache = new JRSingletonCache<MarkupProcessorFactory>(MarkupProcessorFactory.class);
    private static final Map<String, MarkupProcessor> markupProcessors = new HashMap<String, MarkupProcessor>();
    private boolean isLeftToRight = true;
    private JRTextMeasurer textMeasurer;
    private float lineSpacingFactor;
    private float leadingOffset;
    private float textHeight;
    private int elementStretchHeightDelta;
    private int textStart;
    private int textEnd;
    private short[] lineBreakOffsets;
    private String textTruncateSuffix;
    private String rawText;
    private JRStyledText styledText;
    private Map<JRStyle, Map<AttributedCharacterIterator.Attribute, Object>> styledTextAttributesMap = new HashMap<JRStyle, Map<AttributedCharacterIterator.Attribute, Object>>();
    protected final JRLineBox initLineBox;
    protected final JRParagraph initParagraph;
    private final boolean consumeSpaceOnOverflow;
    protected JRLineBox lineBox;
    protected JRParagraph paragraph;

    protected JRFillTextElement(JRBaseFiller filler, JRTextElement textElement, JRFillObjectFactory factory) {
        super(filler, textElement, factory);
        this.initLineBox = textElement.getLineBox().clone(this);
        this.initParagraph = textElement.getParagraph().clone(this);
        this.consumeSpaceOnOverflow = JRPropertiesUtil.getInstance(filler.getJasperReportsContext()).getBooleanProperty(textElement, PROPERTY_CONSUME_SPACE_ON_OVERFLOW, true);
    }

    protected JRFillTextElement(JRFillTextElement textElement, JRFillCloneFactory factory) {
        super(textElement, factory);
        this.initLineBox = textElement.getLineBox().clone(this);
        this.initParagraph = textElement.getParagraph().clone(this);
        this.consumeSpaceOnOverflow = textElement.consumeSpaceOnOverflow;
    }

    private void createTextMeasurer() {
        this.textMeasurer = JRTextMeasurerUtil.getInstance(this.filler.getJasperReportsContext()).createTextMeasurer(this);
    }

    protected void ensureTextMeasurer() {
        if (this.textMeasurer == null) {
            this.createTextMeasurer();
        }
    }

    @Override
    protected void evaluateStyle(byte evaluation) throws JRException {
        super.evaluateStyle(evaluation);
        this.lineBox = null;
        this.paragraph = null;
        if (this.providerStyle != null) {
            this.lineBox = this.initLineBox.clone(this);
            this.paragraph = this.initParagraph.clone(this);
            JRStyleResolver.appendBox(this.lineBox, this.providerStyle.getLineBox());
            JRStyleResolver.appendParagraph(this.paragraph, this.providerStyle.getParagraph());
        }
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public HorizontalAlignEnum getHorizontalAlignmentValue() {
        return JRStyleResolver.getHorizontalAlignmentValue(this);
    }

    @Override
    public HorizontalAlignEnum getOwnHorizontalAlignmentValue() {
        return this.providerStyle == null || this.providerStyle.getOwnHorizontalAlignmentValue() == null ? ((JRTextElement)this.parent).getOwnHorizontalAlignmentValue() : this.providerStyle.getOwnHorizontalAlignmentValue();
    }

    @Override
    public void setHorizontalAlignment(HorizontalAlignEnum horizontalAlignment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VerticalAlignEnum getVerticalAlignmentValue() {
        return JRStyleResolver.getVerticalAlignmentValue(this);
    }

    @Override
    public VerticalAlignEnum getOwnVerticalAlignmentValue() {
        return this.providerStyle == null || this.providerStyle.getOwnVerticalAlignmentValue() == null ? ((JRTextElement)this.parent).getOwnVerticalAlignmentValue() : this.providerStyle.getOwnVerticalAlignmentValue();
    }

    @Override
    public void setVerticalAlignment(VerticalAlignEnum verticalAlignment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RotationEnum getRotationValue() {
        return JRStyleResolver.getRotationValue(this);
    }

    @Override
    public RotationEnum getOwnRotationValue() {
        return this.providerStyle == null || this.providerStyle.getOwnRotationValue() == null ? ((JRTextElement)this.parent).getOwnRotationValue() : this.providerStyle.getOwnRotationValue();
    }

    @Override
    public void setRotation(RotationEnum rotation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LineSpacingEnum getLineSpacingValue() {
        return this.getParagraph().getLineSpacing();
    }

    @Override
    public LineSpacingEnum getOwnLineSpacingValue() {
        return this.getParagraph().getOwnLineSpacing();
    }

    @Override
    public void setLineSpacing(LineSpacingEnum lineSpacing) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getMarkup() {
        return JRStyleResolver.getMarkup(this);
    }

    @Override
    public String getOwnMarkup() {
        return this.providerStyle == null || this.providerStyle.getOwnMarkup() == null ? ((JRTextElement)this.parent).getOwnMarkup() : this.providerStyle.getOwnMarkup();
    }

    @Override
    public void setMarkup(String markup) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox == null ? this.initLineBox : this.lineBox;
    }

    @Override
    public JRParagraph getParagraph() {
        return this.paragraph == null ? this.initParagraph : this.paragraph;
    }

    public JRFont getFont() {
        return this;
    }

    protected Map<AttributedCharacterIterator.Attribute, Object> getStyledTextAttributes() {
        JRStyle style = this.getStyle();
        Map<AttributedCharacterIterator.Attribute, Object> styledTextAttributes = this.styledTextAttributesMap.get(style);
        if (styledTextAttributes == null) {
            styledTextAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
            FontUtil.getInstance(this.filler.getJasperReportsContext()).getAttributesWithoutAwtFont(styledTextAttributes, this);
            styledTextAttributes.put(TextAttribute.FOREGROUND, this.getForecolor());
            if (this.getModeValue() == ModeEnum.OPAQUE) {
                styledTextAttributes.put(TextAttribute.BACKGROUND, this.getBackcolor());
            }
            this.styledTextAttributesMap.put(style, styledTextAttributes);
        }
        return styledTextAttributes;
    }

    protected float getLineSpacingFactor() {
        return this.lineSpacingFactor;
    }

    protected void setLineSpacingFactor(float lineSpacingFactor) {
        this.lineSpacingFactor = lineSpacingFactor;
    }

    protected float getLeadingOffset() {
        return this.leadingOffset;
    }

    protected void setLeadingOffset(float leadingOffset) {
        this.leadingOffset = leadingOffset;
    }

    public RunDirectionEnum getRunDirectionValue() {
        return this.isLeftToRight ? RunDirectionEnum.LTR : RunDirectionEnum.RTL;
    }

    protected float getTextHeight() {
        return this.textHeight;
    }

    protected void setTextHeight(float textHeight) {
        this.textHeight = textHeight;
    }

    protected int getTextStart() {
        return this.textStart;
    }

    protected void setTextStart(int textStart) {
        this.textStart = textStart;
    }

    protected int getTextEnd() {
        return this.textEnd;
    }

    protected void setTextEnd(int textEnd) {
        this.textEnd = textEnd;
    }

    protected short[] getLineBreakOffsets() {
        return this.lineBreakOffsets;
    }

    protected void setLineBreakOffsets(short[] lineBreakOffsets) {
        this.lineBreakOffsets = lineBreakOffsets;
    }

    protected void resetTextChunk() {
        this.textStart = 0;
        this.textEnd = 0;
        this.textTruncateSuffix = null;
        this.lineBreakOffsets = null;
        this.elementStretchHeightDelta = 0;
    }

    protected String getRawText() {
        return this.rawText;
    }

    protected void setRawText(String rawText) {
        this.rawText = rawText;
        this.styledText = null;
    }

    @Override
    protected void reset() {
        super.reset();
        this.isLeftToRight = true;
        this.lineSpacingFactor = 0.0f;
        this.leadingOffset = 0.0f;
        this.textHeight = 0.0f;
        this.elementStretchHeightDelta = 0;
    }

    @Override
    protected void rewind() {
        this.resetTextChunk();
    }

    protected JRStyledText getStyledText() {
        String text;
        if (this.styledText == null && (text = this.getRawText()) != null) {
            this.styledText = this.filler.getStyledTextParser().getStyledText(this.getStyledTextAttributes(), text, !"none".equals(this.getMarkup()), this.filler.getLocale());
        }
        return this.styledText;
    }

    public String getText() {
        JRStyledText tmpStyledText = this.getStyledText();
        if (tmpStyledText == null) {
            return null;
        }
        return tmpStyledText.getText();
    }

    protected void chopTextElement(int availableStretchHeight) {
        this.ensureTextMeasurer();
        JRStyledText tmpStyledText = this.getStyledText();
        if (tmpStyledText == null) {
            return;
        }
        if (this.getTextEnd() == tmpStyledText.getText().length()) {
            return;
        }
        boolean canOverflow = this.canOverflow();
        JRMeasuredText measuredText = this.textMeasurer.measure(tmpStyledText, this.getTextEnd(), availableStretchHeight, canOverflow);
        this.isLeftToRight = measuredText.isLeftToRight();
        this.setTextHeight(measuredText.getTextHeight());
        this.elementStretchHeightDelta = 0;
        if (this.getRotationValue().equals(RotationEnum.NONE)) {
            boolean textEnded;
            int elementTextHeight = (int)this.getTextHeight() + this.getLineBox().getTopPadding() + this.getLineBox().getBottomPadding();
            boolean bl = textEnded = measuredText.getTextOffset() >= tmpStyledText.getText().length();
            if (textEnded || !canOverflow || !this.consumeSpaceOnOverflow) {
                this.setStretchHeight(elementTextHeight);
            } else {
                int stretchHeight = this.getHeight() + availableStretchHeight;
                this.setStretchHeight(stretchHeight);
                int textStretchHeight = elementTextHeight > this.getHeight() ? elementTextHeight : this.getHeight();
                this.elementStretchHeightDelta = this.getStretchHeight() - textStretchHeight;
            }
        } else {
            this.setStretchHeight(this.getHeight());
        }
        this.setTextStart(this.getTextEnd());
        this.setTextEnd(measuredText.getTextOffset());
        this.setLineBreakOffsets(measuredText.getLineBreakOffsets());
        this.setTextTruncateSuffix(measuredText.getTextSuffix());
        this.setLineSpacingFactor(measuredText.getLineSpacingFactor());
        this.setLeadingOffset(measuredText.getLeadingOffset());
    }

    protected int getPrintElementHeight() {
        return this.getStretchHeight() - this.elementStretchHeightDelta;
    }

    protected abstract boolean canOverflow();

    @Override
    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    @Override
    public String getOwnFontName() {
        return this.providerStyle == null || this.providerStyle.getOwnFontName() == null ? ((JRFont)((Object)this.parent)).getOwnFontName() : this.providerStyle.getOwnFontName();
    }

    @Override
    public void setFontName(String fontName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    @Override
    public Boolean isOwnBold() {
        return this.providerStyle == null || this.providerStyle.isOwnBold() == null ? ((JRFont)((Object)this.parent)).isOwnBold() : this.providerStyle.isOwnBold();
    }

    @Override
    public void setBold(boolean isBold) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBold(Boolean isBold) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    @Override
    public Boolean isOwnItalic() {
        return this.providerStyle == null || this.providerStyle.isOwnItalic() == null ? ((JRFont)((Object)this.parent)).isOwnItalic() : this.providerStyle.isOwnItalic();
    }

    @Override
    public void setItalic(boolean isItalic) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setItalic(Boolean isItalic) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    @Override
    public Boolean isOwnUnderline() {
        return this.providerStyle == null || this.providerStyle.isOwnUnderline() == null ? ((JRFont)((Object)this.parent)).isOwnUnderline() : this.providerStyle.isOwnUnderline();
    }

    @Override
    public void setUnderline(boolean isUnderline) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUnderline(Boolean isUnderline) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    @Override
    public Boolean isOwnStrikeThrough() {
        return this.providerStyle == null || this.providerStyle.isOwnStrikeThrough() == null ? ((JRFont)((Object)this.parent)).isOwnStrikeThrough() : this.providerStyle.isOwnStrikeThrough();
    }

    @Override
    public void setStrikeThrough(boolean isStrikeThrough) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setStrikeThrough(Boolean isStrikeThrough) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFontSize() {
        return JRStyleResolver.getFontSize(this);
    }

    @Override
    public Integer getOwnFontSize() {
        return this.providerStyle == null || this.providerStyle.getOwnFontSize() == null ? ((JRFont)((Object)this.parent)).getOwnFontSize() : this.providerStyle.getOwnFontSize();
    }

    @Override
    public void setFontSize(int size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFontSize(Integer size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    @Override
    public String getOwnPdfFontName() {
        return this.providerStyle == null || this.providerStyle.getOwnPdfFontName() == null ? ((JRFont)((Object)this.parent)).getOwnPdfFontName() : this.providerStyle.getOwnPdfFontName();
    }

    @Override
    public void setPdfFontName(String pdfFontName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    @Override
    public String getOwnPdfEncoding() {
        return this.providerStyle == null || this.providerStyle.getOwnPdfEncoding() == null ? ((JRFont)((Object)this.parent)).getOwnPdfEncoding() : this.providerStyle.getOwnPdfEncoding();
    }

    @Override
    public void setPdfEncoding(String pdfEncoding) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    @Override
    public Boolean isOwnPdfEmbedded() {
        return this.providerStyle == null || this.providerStyle.isOwnPdfEmbedded() == null ? ((JRFont)((Object)this.parent)).isOwnPdfEmbedded() : this.providerStyle.isOwnPdfEmbedded();
    }

    @Override
    public void setPdfEmbedded(boolean isPdfEmbedded) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPdfEmbedded(Boolean isPdfEmbedded) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        this.createTextMeasurer();
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        this.createTextMeasurer();
    }

    protected String processMarkupText(String text) {
        String markup;
        if ((text = JRStringUtil.replaceCRwithLF(text)) != null && !"none".equals(markup = this.getMarkup()) && !"styled".equals(markup)) {
            text = this.getMarkupProcessor(markup).convert(text);
        }
        return text;
    }

    protected MarkupProcessor getMarkupProcessor(String markup) {
        MarkupProcessor markupProcessor = markupProcessors.get(markup);
        if (markupProcessor == null) {
            String factoryClass = this.filler.getPropertiesUtil().getProperty("net.sf.jasperreports.markup.processor.factory." + markup);
            if (factoryClass == null) {
                throw new JRRuntimeException("No markup processor factory specifyed for '" + markup + "' markup.");
            }
            MarkupProcessorFactory factory = null;
            try {
                factory = markupProcessorFactoryCache.getCachedInstance(factoryClass);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
            markupProcessor = factory.createMarkupProcessor();
            markupProcessors.put(markup, markupProcessor);
        }
        return markupProcessor;
    }

    protected void setPrintText(JRPrintText printText) {
        boolean keepAllText;
        int startIndex = this.getTextStart();
        int endIndex = this.getTextEnd();
        JRStyledText fullStyledText = this.getStyledText();
        String fullText = fullStyledText.getText();
        boolean bl = keepAllText = !this.canOverflow() && this.filler.getPropertiesUtil().getBooleanProperty(this, "net.sf.jasperreports.print.keep.full.text", false);
        if (keepAllText) {
            if (startIndex != 0) {
                throw new JRRuntimeException("Text start index != 0 on keep all text.");
            }
            if (!"none".equals(this.getMarkup())) {
                String styledText = this.filler.getStyledTextParser().write(fullStyledText);
                printText.setText(styledText);
            } else {
                printText.setText(fullText);
            }
            if (endIndex < fullText.length()) {
                printText.setTextTruncateIndex(endIndex);
            }
        } else {
            String printedText = !"none".equals(this.getMarkup()) ? this.filler.getStyledTextParser().write(fullStyledText, startIndex, endIndex) : fullText.substring(startIndex, endIndex);
            printText.setText(printedText);
        }
        printText.setTextTruncateSuffix(this.getTextTruncateSuffix());
        printText.setLineBreakOffsets(this.getLineBreakOffsets());
    }

    protected String getTextTruncateSuffix() {
        return this.textTruncateSuffix;
    }

    protected void setTextTruncateSuffix(String textTruncateSuffix) {
        this.textTruncateSuffix = textTruncateSuffix;
    }
}

