/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.fill.calculation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketDefinition;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketingServiceContext;
import net.sf.jasperreports.crosstabs.fill.calculation.MeasureDefinition;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.type.CalculationEnum;

public abstract class BucketingService {
    public static final String PROPERTY_BUCKET_MEASURE_LIMIT = "net.sf.jasperreports.crosstab.bucket.measure.limit";
    protected static final byte DIMENSION_ROW = 0;
    protected static final byte DIMENSION_COLUMN = 1;
    protected static final int DIMENSIONS = 2;
    protected final BucketingServiceContext serviceContext;
    protected final BucketDefinition[] allBuckets;
    protected final BucketDefinition[][] buckets;
    protected final int rowBucketCount;
    protected final int colBucketCount;
    protected final boolean[][] retrieveTotal;
    protected boolean[] rowRetrTotals;
    protected int rowRetrTotalMin;
    protected int rowRetrTotalMax;
    protected int[] rowRetrColMax;
    protected final MeasureDefinition[] measures;
    protected final int origMeasureCount;
    protected final int[] measureIndexes;
    protected final boolean sorted;
    protected final BucketMap bucketValueMap;
    protected long dataCount;
    protected boolean processed;
    protected final MeasureDefinition.MeasureValue[] zeroUserMeasureValues;
    private final int bucketMeasureLimit;
    private int runningBucketMeasureCount;

    public BucketingService(BucketingServiceContext serviceContext, List<BucketDefinition> rowBuckets, List<BucketDefinition> columnBuckets, List<MeasureDefinition> measures, boolean sorted, boolean[][] retrieveTotal) {
        int i;
        this.serviceContext = serviceContext;
        this.sorted = sorted;
        this.buckets = new BucketDefinition[2][];
        this.rowBucketCount = rowBuckets.size();
        this.buckets[0] = new BucketDefinition[this.rowBucketCount];
        rowBuckets.toArray(this.buckets[0]);
        this.colBucketCount = columnBuckets.size();
        this.buckets[1] = new BucketDefinition[this.colBucketCount];
        columnBuckets.toArray(this.buckets[1]);
        this.allBuckets = new BucketDefinition[this.rowBucketCount + this.colBucketCount];
        System.arraycopy(this.buckets[0], 0, this.allBuckets, 0, this.rowBucketCount);
        System.arraycopy(this.buckets[1], 0, this.allBuckets, this.rowBucketCount, this.colBucketCount);
        this.origMeasureCount = measures.size();
        ArrayList<MeasureDefinition> measuresList = new ArrayList<MeasureDefinition>(measures.size() * 2);
        ArrayList<Integer> measureIndexList = new ArrayList<Integer>(measures.size() * 2);
        for (i = 0; i < measures.size(); ++i) {
            MeasureDefinition measure = measures.get(i);
            this.addMeasure(measure, i, measuresList, measureIndexList);
        }
        this.measures = new MeasureDefinition[measuresList.size()];
        measuresList.toArray(this.measures);
        this.measureIndexes = new int[measureIndexList.size()];
        for (i = 0; i < this.measureIndexes.length; ++i) {
            this.measureIndexes[i] = (Integer)measureIndexList.get(i);
        }
        this.retrieveTotal = retrieveTotal;
        this.checkTotals();
        this.bucketValueMap = this.createBucketMap(0);
        this.zeroUserMeasureValues = this.initUserMeasureValues();
        this.bucketMeasureLimit = JRPropertiesUtil.getInstance(serviceContext.getJasperReportsContext()).getIntegerProperty(PROPERTY_BUCKET_MEASURE_LIMIT, 0);
    }

    protected void checkTotals() {
        this.rowRetrTotalMin = this.rowBucketCount + 1;
        this.rowRetrTotalMax = -1;
        this.rowRetrTotals = new boolean[this.rowBucketCount + 1];
        this.rowRetrColMax = new int[this.rowBucketCount + 1];
        for (int row = 0; row <= this.rowBucketCount; ++row) {
            this.rowRetrColMax[row] = -1;
            boolean total = false;
            for (int col = 0; col <= this.colBucketCount; ++col) {
                if (!this.retrieveTotal[row][col]) continue;
                total = true;
                this.rowRetrColMax[row] = col;
            }
            this.rowRetrTotals[row] = total;
            if (!total) continue;
            if (row < this.rowRetrTotalMin) {
                this.rowRetrTotalMin = row;
            }
            this.rowRetrTotalMax = row;
            if (row >= this.rowBucketCount) continue;
            this.allBuckets[row].setComputeTotal();
        }
        for (int col = 0; col < this.colBucketCount; ++col) {
            BucketDefinition colBucket = this.allBuckets[this.rowBucketCount + col];
            if (colBucket.computeTotal()) continue;
            boolean total = false;
            for (int row = 0; !total && row <= this.rowBucketCount; ++row) {
                total = this.retrieveTotal[row][col];
            }
            if (!total) continue;
            colBucket.setComputeTotal();
        }
        for (int d = 0; d < 2; ++d) {
            boolean dTotal = false;
            for (int i = 0; i < this.buckets[d].length; ++i) {
                if (dTotal) {
                    this.buckets[d][i].setComputeTotal();
                    continue;
                }
                dTotal = this.buckets[d][i].computeTotal();
            }
        }
    }

    public void clear() {
        this.bucketValueMap.clear();
        this.processed = false;
        this.dataCount = 0L;
        this.runningBucketMeasureCount = 0;
    }

    protected BucketMap createBucketMap(int level) {
        BucketMap map = this.sorted ? new BucketListMap(level, false) : new BucketTreeMap(level);
        return map;
    }

    protected BucketListMap createCollectBucketMap(int level) {
        return new BucketListMap(level, true);
    }

    protected void addMeasure(MeasureDefinition measure, int index, List<MeasureDefinition> measuresList, List<Integer> measureIndexList) {
        switch (measure.getCalculation()) {
            case AVERAGE: 
            case VARIANCE: {
                MeasureDefinition sumMeasure = MeasureDefinition.createHelperMeasure(measure, CalculationEnum.SUM);
                this.addMeasure(sumMeasure, index, measuresList, measureIndexList);
                MeasureDefinition countMeasure = MeasureDefinition.createHelperMeasure(measure, CalculationEnum.COUNT);
                this.addMeasure(countMeasure, index, measuresList, measureIndexList);
                break;
            }
            case STANDARD_DEVIATION: {
                MeasureDefinition varianceMeasure = MeasureDefinition.createHelperMeasure(measure, CalculationEnum.VARIANCE);
                this.addMeasure(varianceMeasure, index, measuresList, measureIndexList);
                break;
            }
            case DISTINCT_COUNT: {
                MeasureDefinition countMeasure = MeasureDefinition.createDistinctCountHelperMeasure(measure);
                this.addMeasure(countMeasure, index, measuresList, measureIndexList);
                break;
            }
        }
        measuresList.add(measure);
        measureIndexList.add(index);
    }

    public void addData(Object[] bucketValues, Object[] measureValues) throws JRException {
        if (this.processed) {
            throw new JRException("Crosstab data has already been processed.");
        }
        ++this.dataCount;
        BucketDefinition.Bucket[] bucketVals = this.getBucketValues(bucketValues);
        MeasureDefinition.MeasureValue[] values = this.bucketValueMap.insertMeasureValues(bucketVals);
        for (int i = 0; i < this.measures.length; ++i) {
            Object measureValue = measureValues[this.measureIndexes[i]];
            values[i].addValue(measureValue);
        }
    }

    protected void bucketMeasuresCreated() {
        this.runningBucketMeasureCount += this.origMeasureCount;
        this.checkBucketMeasureCount(this.runningBucketMeasureCount);
    }

    protected BucketDefinition.Bucket[] getBucketValues(Object[] bucketValues) {
        BucketDefinition.Bucket[] bucketVals = new BucketDefinition.Bucket[this.allBuckets.length];
        for (int i = 0; i < this.allBuckets.length; ++i) {
            BucketDefinition bucket = this.allBuckets[i];
            Object value = bucketValues[i];
            bucketVals[i] = bucket.create(value);
        }
        return bucketVals;
    }

    protected MeasureDefinition.MeasureValue[] initMeasureValues() {
        MeasureDefinition.MeasureValue[] values = new MeasureDefinition.MeasureValue[this.measures.length];
        block5: for (int i = 0; i < this.measures.length; ++i) {
            MeasureDefinition measure = this.measures[i];
            values[i] = new MeasureDefinition.MeasureValue(measure);
            switch (measure.getCalculation()) {
                case AVERAGE: 
                case VARIANCE: {
                    values[i].setHelper(values[i - 2], (byte)1);
                    values[i].setHelper(values[i - 1], (byte)0);
                    continue block5;
                }
                case STANDARD_DEVIATION: {
                    values[i].setHelper(values[i - 1], (byte)2);
                }
                case DISTINCT_COUNT: {
                    values[i].setHelper(values[i - 1], (byte)0);
                }
            }
        }
        return values;
    }

    protected MeasureDefinition.MeasureValue[] initUserMeasureValues() {
        MeasureDefinition.MeasureValue[] vals = new MeasureDefinition.MeasureValue[this.origMeasureCount];
        int c = 0;
        for (int i = 0; i < this.measures.length; ++i) {
            if (this.measures[i].isSystemDefined()) continue;
            vals[c] = new MeasureDefinition.MeasureValue(this.measures[i]);
            ++c;
        }
        return vals;
    }

    public void processData() throws JRException {
        if (!this.processed) {
            if (this.dataCount > 0L && (this.allBuckets[this.rowBucketCount - 1].computeTotal() || this.allBuckets[this.allBuckets.length - 1].computeTotal())) {
                this.computeTotals(this.bucketValueMap);
            }
            this.processed = true;
        }
    }

    public boolean hasData() {
        return this.dataCount > 0L;
    }

    public MeasureDefinition.MeasureValue[] getMeasureValues(BucketDefinition.Bucket[] bucketValues) {
        BucketMap map = this.bucketValueMap;
        for (int i = 0; map != null && i < this.allBuckets.length - 1; map = (BucketMap)map.get(bucketValues[i]), ++i) {
        }
        return map == null ? null : (MeasureDefinition.MeasureValue[])map.get(bucketValues[this.allBuckets.length - 1]);
    }

    public MeasureDefinition.MeasureValue[] getUserMeasureValues(MeasureDefinition.MeasureValue[] values) {
        MeasureDefinition.MeasureValue[] vals = new MeasureDefinition.MeasureValue[this.origMeasureCount];
        int c = 0;
        for (int i = 0; i < this.measures.length; ++i) {
            if (this.measures[i].isSystemDefined()) continue;
            vals[c] = values[i];
            ++c;
        }
        return vals;
    }

    public MeasureDefinition.MeasureValue[] getZeroUserMeasureValues() {
        return this.zeroUserMeasureValues;
    }

    public MeasureDefinition.MeasureValue[] getGrandTotals() {
        BucketMap map = this.bucketValueMap;
        for (int i = 0; map != null && i < this.allBuckets.length - 1; ++i) {
            map = (BucketMap)map.getTotalEntry().getValue();
        }
        return map == null ? null : (MeasureDefinition.MeasureValue[])map.getTotalEntry().getValue();
    }

    protected void computeTotals(BucketMap bucketMap) throws JRException {
        boolean dimension;
        boolean bl = dimension = bucketMap.level >= this.rowBucketCount;
        if (dimension && !this.allBuckets[this.allBuckets.length - 1].computeTotal()) {
            return;
        }
        if (!bucketMap.last) {
            Iterator<Map.Entry<BucketDefinition.Bucket, Object>> it = bucketMap.entryIterator();
            while (it.hasNext()) {
                Map.Entry<BucketDefinition.Bucket, Object> entry = it.next();
                this.computeTotals((BucketMap)entry.getValue());
            }
        }
        if (this.allBuckets[bucketMap.level].computeTotal()) {
            if (dimension) {
                this.computeColumnTotal(bucketMap);
            } else {
                this.computeRowTotals(bucketMap);
            }
        }
    }

    protected void sumVals(MeasureDefinition.MeasureValue[] totals, MeasureDefinition.MeasureValue[] vals) throws JRException {
        for (int i = 0; i < this.measures.length; ++i) {
            totals[i].addValue(vals[i]);
        }
    }

    protected void computeColumnTotal(BucketMap bucketMap) throws JRException {
        MeasureDefinition.MeasureValue[] totals = this.initMeasureValues();
        Iterator<Map.Entry<BucketDefinition.Bucket, Object>> it = bucketMap.entryIterator();
        while (it.hasNext()) {
            MapEntry entry = it.next();
            for (int i = bucketMap.level + 1; i < this.allBuckets.length; ++i) {
                entry = ((BucketMap)entry.getValue()).getTotalEntry();
            }
            this.sumVals(totals, (MeasureDefinition.MeasureValue[])entry.getValue());
        }
        for (int i = bucketMap.level + 1; i < this.allBuckets.length; ++i) {
            bucketMap = bucketMap.addTotalNextMap();
        }
        bucketMap.addTotalEntry(totals);
    }

    protected void computeRowTotals(BucketMap bucketMap) throws JRException {
        BucketListMap totals = this.createCollectBucketMap(this.rowBucketCount);
        Iterator<Map.Entry<BucketDefinition.Bucket, Object>> it = bucketMap.entryIterator();
        while (it.hasNext()) {
            MapEntry entry = it.next();
            for (int i = bucketMap.level + 1; i < this.rowBucketCount; ++i) {
                entry = ((BucketMap)entry.getValue()).getTotalEntry();
            }
            totals.collectVals((BucketMap)entry.getValue(), true);
        }
        BucketMap totalBucketMap = bucketMap;
        for (int i = bucketMap.level + 1; i < this.rowBucketCount; ++i) {
            totalBucketMap = totalBucketMap.addTotalNextMap();
        }
        totalBucketMap.addTotalEntry(totals);
    }

    protected void checkBucketMeasureCount(int bucketMeasureCount) {
        if (this.bucketMeasureLimit > 0 && bucketMeasureCount > this.bucketMeasureLimit) {
            throw new JRRuntimeException("Crosstab bucket/measure limit (" + this.bucketMeasureLimit + ") exceeded.");
        }
    }

    protected class BucketListMap
    extends BucketMap {
        List<Map.Entry<BucketDefinition.Bucket, Object>> entries;
        Map<BucketDefinition.Bucket, Object> entryMap;

        BucketListMap(int level, boolean linked) {
            super(level);
            this.entries = linked ? new LinkedList<Map.Entry<BucketDefinition.Bucket, Object>>() : new ArrayList<Map.Entry<BucketDefinition.Bucket, Object>>();
            this.entryMap = new HashMap<BucketDefinition.Bucket, Object>();
        }

        @Override
        void clear() {
            this.entries.clear();
            this.entryMap.clear();
        }

        @Override
        public Iterator<Map.Entry<BucketDefinition.Bucket, Object>> entryIterator() {
            return this.entries.iterator();
        }

        private void add(BucketDefinition.Bucket key, Object value) {
            this.entries.add(new MapEntry(key, value));
            this.entryMap.put(key, value);
        }

        @Override
        public Object get(BucketDefinition.Bucket key) {
            return this.entryMap.get(key);
        }

        @Override
        MeasureDefinition.MeasureValue[] insertMeasureValues(BucketDefinition.Bucket[] bucketValues) {
            int i;
            Object levelObj = this;
            BucketListMap map = null;
            for (i = 0; i < BucketingService.this.allBuckets.length; ++i) {
                map = levelObj;
                int size = map.entries.size();
                if (size == 0) break;
                MapEntry lastEntry = (MapEntry)map.entries.get(size - 1);
                if (!lastEntry.key.equals(bucketValues[i])) break;
                levelObj = lastEntry.value;
            }
            if (i == BucketingService.this.allBuckets.length) {
                return (MeasureDefinition.MeasureValue[])levelObj;
            }
            while (i < BucketingService.this.allBuckets.length - 1) {
                BucketListMap nextMap = new BucketListMap(i + 1, false);
                map.add(bucketValues[i], nextMap);
                map = nextMap;
                ++i;
            }
            MeasureDefinition.MeasureValue[] values = BucketingService.this.initMeasureValues();
            map.add(bucketValues[i], values);
            BucketingService.this.bucketMeasuresCreated();
            return values;
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        @Override
        void addTotalEntry(Object value) {
            this.add(this.totalKey, value);
        }

        @Override
        public Object getTotal() {
            MapEntry totalEntry = this.getTotalEntry();
            return totalEntry == null ? null : totalEntry.getValue();
        }

        @Override
        public MapEntry getTotalEntry() {
            MapEntry lastEntry = (MapEntry)this.entries.get(this.entries.size() - 1);
            if (lastEntry.key.isTotal()) {
                return lastEntry;
            }
            return null;
        }

        void collectVals(BucketMap map, boolean sum) throws JRException {
            Map.Entry<BucketDefinition.Bucket, Object> entry;
            ListIterator<Map.Entry<BucketDefinition.Bucket, Object>> totalIt = this.entries.listIterator();
            MapEntry totalItEntry = totalIt.hasNext() ? (MapEntry)totalIt.next() : null;
            Iterator<Map.Entry<BucketDefinition.Bucket, Object>> it = map.entryIterator();
            Map.Entry<BucketDefinition.Bucket, Object> entry2 = entry = it.hasNext() ? it.next() : null;
            while (entry != null) {
                int compare;
                BucketDefinition.Bucket key = entry.getKey();
                int n = compare = totalItEntry == null ? -1 : key.compareTo(totalItEntry.key);
                if (compare <= 0) {
                    Object addVal = null;
                    if (this.last) {
                        if (sum) {
                            MeasureDefinition.MeasureValue[] totalVals;
                            MeasureDefinition.MeasureValue[] measureValueArray = totalVals = compare == 0 ? (MeasureDefinition.MeasureValue[])totalItEntry.value : null;
                            if (totalVals == null) {
                                addVal = totalVals = BucketingService.this.initMeasureValues();
                            }
                            BucketingService.this.sumVals(totalVals, (MeasureDefinition.MeasureValue[])entry.getValue());
                        }
                    } else {
                        BucketListMap nextTotals;
                        BucketListMap bucketListMap = nextTotals = compare == 0 ? (BucketListMap)totalItEntry.value : null;
                        if (nextTotals == null) {
                            nextTotals = BucketingService.this.createCollectBucketMap(this.level + 1);
                            addVal = nextTotals;
                        }
                        nextTotals.collectVals((BucketMap)entry.getValue(), sum);
                    }
                    if (compare < 0) {
                        if (totalItEntry != null) {
                            totalIt.previous();
                        }
                        totalIt.add(new MapEntry(key, addVal));
                        this.entryMap.put(key, addVal);
                        if (totalItEntry != null) {
                            totalIt.next();
                        }
                    }
                    Map.Entry<BucketDefinition.Bucket, Object> entry3 = entry = it.hasNext() ? it.next() : null;
                }
                if (compare < 0) continue;
                totalItEntry = totalIt.hasNext() ? (MapEntry)totalIt.next() : null;
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            Iterator<Map.Entry<BucketDefinition.Bucket, Object>> it = this.entries.iterator();
            while (it.hasNext()) {
                Map.Entry<BucketDefinition.Bucket, Object> entry = it.next();
                sb.append(entry);
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append('}');
            return sb.toString();
        }
    }

    protected class BucketTreeMap
    extends BucketMap {
        TreeMap<BucketDefinition.Bucket, Object> map;

        BucketTreeMap(int level) {
            super(level);
            this.map = new TreeMap();
        }

        @Override
        void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<Map.Entry<BucketDefinition.Bucket, Object>> entryIterator() {
            return this.map.entrySet().iterator();
        }

        @Override
        public Object get(BucketDefinition.Bucket key) {
            return this.map.get(key);
        }

        @Override
        MeasureDefinition.MeasureValue[] insertMeasureValues(BucketDefinition.Bucket[] bucketValues) {
            BucketTreeMap levelMap = (BucketTreeMap)BucketingService.this.bucketValueMap;
            for (int i = 0; i < bucketValues.length - 1; ++i) {
                BucketTreeMap nextMap = (BucketTreeMap)levelMap.get(bucketValues[i]);
                if (nextMap == null) {
                    nextMap = new BucketTreeMap(i + 1);
                    levelMap.map.put(bucketValues[i], nextMap);
                }
                levelMap = nextMap;
            }
            MeasureDefinition.MeasureValue[] values = (MeasureDefinition.MeasureValue[])levelMap.get(bucketValues[bucketValues.length - 1]);
            if (values == null) {
                values = BucketingService.this.initMeasureValues();
                levelMap.map.put(bucketValues[bucketValues.length - 1], values);
                BucketingService.this.bucketMeasuresCreated();
            }
            return values;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        void addTotalEntry(Object value) {
            this.map.put(this.totalKey, value);
        }

        @Override
        public Object getTotal() {
            return this.get(this.totalKey);
        }

        @Override
        public MapEntry getTotalEntry() {
            Object value = this.get(this.totalKey);
            return value == null ? null : new MapEntry(this.totalKey, value);
        }

        public String toString() {
            return this.map.toString();
        }
    }

    public abstract class BucketMap {
        final int level;
        final boolean last;
        final BucketDefinition.Bucket totalKey;

        BucketMap(int level) {
            this.level = level;
            this.last = level == BucketingService.this.allBuckets.length - 1;
            this.totalKey = BucketingService.this.allBuckets[level].VALUE_TOTAL;
        }

        BucketMap addTotalNextMap() {
            BucketMap nextMap = BucketingService.this.createBucketMap(this.level + 1);
            this.addTotalEntry(nextMap);
            return nextMap;
        }

        abstract void clear();

        public abstract Iterator<Map.Entry<BucketDefinition.Bucket, Object>> entryIterator();

        public abstract Object get(BucketDefinition.Bucket var1);

        abstract MeasureDefinition.MeasureValue[] insertMeasureValues(BucketDefinition.Bucket[] var1);

        abstract void addTotalEntry(Object var1);

        public abstract int size();

        public abstract Object getTotal();

        public abstract MapEntry getTotalEntry();
    }

    protected static class MapEntry
    implements Map.Entry<BucketDefinition.Bucket, Object>,
    Comparable<MapEntry> {
        final BucketDefinition.Bucket key;
        final Object value;

        MapEntry(BucketDefinition.Bucket key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public BucketDefinition.Bucket getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareTo(MapEntry o) {
            return this.key.compareTo(o.key);
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

