/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import java.util.List;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.components.map.Marker;
import net.sf.jasperreports.components.map.MarkerDataset;
import net.sf.jasperreports.components.map.MarkerProperty;
import net.sf.jasperreports.components.map.StandardMapComponent;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class MapCompiler
implements ComponentCompiler {
    @Override
    public void collectExpressions(Component component, JRExpressionCollector collector) {
        MapComponent map = (MapComponent)component;
        collector.addExpression(map.getLatitudeExpression());
        collector.addExpression(map.getLongitudeExpression());
        collector.addExpression(map.getZoomExpression());
        collector.addExpression(map.getLanguageExpression());
        MapCompiler.collectExpressions(map.getMarkerDataset(), collector);
    }

    public static void collectExpressions(MarkerDataset dataset, JRExpressionCollector collector) {
        if (dataset != null) {
            List<Marker> markers;
            JRExpressionCollector datasetCollector = collector;
            JRDatasetRun datasetRun = dataset.getDatasetRun();
            if (datasetRun != null) {
                collector.collect(datasetRun);
                datasetCollector = collector.getDatasetCollector(datasetRun.getDatasetName());
            }
            if ((markers = dataset.getMarkers()) != null && !markers.isEmpty()) {
                for (Marker marker : markers) {
                    List<MarkerProperty> markerProperties = marker.getProperties();
                    if (markerProperties == null) continue;
                    for (MarkerProperty property : markerProperties) {
                        datasetCollector.addExpression(property.getValueExpression());
                    }
                }
            }
        }
    }

    @Override
    public Component toCompiledComponent(Component component, JRBaseObjectFactory baseFactory) {
        MapComponent map = (MapComponent)component;
        return new StandardMapComponent(map, baseFactory);
    }

    @Override
    public void verify(Component component, JRVerifier verifier) {
        MapComponent map = (MapComponent)component;
        EvaluationTimeEnum evaluationTime = map.getEvaluationTime();
        if (evaluationTime == EvaluationTimeEnum.AUTO) {
            verifier.addBrokenRule("Auto evaluation time is not supported for maps", (Object)map);
        } else if (evaluationTime == EvaluationTimeEnum.GROUP) {
            String evaluationGroup = map.getEvaluationGroup();
            if (evaluationGroup == null || evaluationGroup.length() == 0) {
                verifier.addBrokenRule("No evaluation group set for map", (Object)map);
            } else if (!verifier.getReportDesign().getGroupsMap().containsKey(evaluationGroup)) {
                verifier.addBrokenRule("Map evalution group \"" + evaluationGroup + " not found", (Object)map);
            }
        }
        MarkerDataset dataset = map.getMarkerDataset();
        if (dataset != null) {
            this.verify(verifier, dataset);
        }
    }

    protected void verify(JRVerifier verifier, MarkerDataset dataset) {
        List<Marker> markers;
        if (dataset.getDatasetRun() != null) {
            verifier.verifyDatasetRun(dataset.getDatasetRun());
        }
        if ((markers = dataset.getMarkers()) != null) {
            for (Marker marker : markers) {
                this.verifyMarkerProperties(verifier, marker.getProperties());
            }
        }
    }

    protected void verifyMarkerProperties(JRVerifier verifier, List<MarkerProperty> markerProperties) {
        boolean hasLatitude = false;
        boolean hasLongitude = false;
        if (markerProperties != null) {
            for (MarkerProperty marker : markerProperties) {
                if ("latitude".equals(marker.getName())) {
                    hasLatitude = true;
                    continue;
                }
                if (!"longitude".equals(marker.getName())) continue;
                hasLongitude = true;
            }
        }
        if (!hasLatitude) {
            verifier.addBrokenRule("No latitude set for marker.", markerProperties);
        }
        if (!hasLongitude) {
            verifier.addBrokenRule("No longitude set for marker.", markerProperties);
        }
    }
}

