/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.hadoop.hive.connection;

import com.jaspersoft.hadoop.hive.connection.HiveConnection;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.log4j.Logger;

public class HiveConnectionFactory
implements PoolableObjectFactory<HiveConnection> {
    private final Logger logger = Logger.getLogger(HiveConnectionFactory.class);
    private String jdbcURL;

    public void activateObject(HiveConnection connection) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Activating Hive connection object");
        }
    }

    public void destroyObject(HiveConnection connection) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Destroying Hive connection");
        }
        if (connection != null) {
            connection.close();
        }
    }

    public HiveConnection makeObject() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Creating Hive connection");
        }
        return new HiveConnection(this.jdbcURL);
    }

    public void passivateObject(HiveConnection connection) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Passivate is not implemented");
        }
    }

    public boolean validateObject(HiveConnection connection) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Validating Hive connection");
        }
        if (connection != null) {
            return this.jdbcURL.equals(connection.getJdbcURL()) && connection.test().contains("success");
        }
        return false;
    }

    public void setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
    }
}

