/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.palette.ActiveEditorDropDefaultProvider;
import org.netbeans.modules.palette.ActiveEditorDropProvider;
import org.netbeans.modules.palette.PaletteItemHandler;
import org.netbeans.modules.palette.PaletteItemNode;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class PaletteEnvironmentProvider
implements Environment.Provider {
    private static PaletteEnvironmentProvider createProvider() {
        return new PaletteEnvironmentProvider();
    }

    private PaletteEnvironmentProvider() {
    }

    public Lookup getEnvironment(DataObject dataObject) {
        PaletteItemNodeFactory paletteItemNodeFactory = new PaletteItemNodeFactory((XMLDataObject)dataObject);
        return paletteItemNodeFactory.getLookup();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PaletteItemNodeFactory
    implements InstanceContent.Convertor<Class, PaletteItemNode> {
        private XMLDataObject xmlDataObject = null;
        private Lookup lookup = null;
        Reference<PaletteItemNode> refNode = new WeakReference<Object>(null);
        private WeakReference<XMLReader> cachedReader;

        PaletteItemNodeFactory(XMLDataObject xMLDataObject) {
            this.xmlDataObject = xMLDataObject;
            InstanceContent instanceContent = new InstanceContent();
            instanceContent.add(Node.class, (InstanceContent.Convertor)this);
            this.lookup = new AbstractLookup((AbstractLookup.Content)instanceContent);
        }

        Lookup getLookup() {
            return this.lookup;
        }

        public Class<? extends PaletteItemNode> type(Class clazz) {
            if (clazz == Node.class) {
                return PaletteItemNode.class;
            }
            return null;
        }

        public String id(Class clazz) {
            return clazz.toString();
        }

        public String displayName(Class clazz) {
            return clazz.getName();
        }

        public PaletteItemNode convert(Class clazz) {
            PaletteItemNode paletteItemNode = null;
            if (clazz == Node.class) {
                try {
                    paletteItemNode = this.getInstance();
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, exception);
                }
            }
            return paletteItemNode;
        }

        private XMLReader getXMLReader() throws SAXException {
            XMLReader xMLReader;
            XMLReader xMLReader2 = xMLReader = null == this.cachedReader ? null : (XMLReader)this.cachedReader.get();
            if (null == xMLReader) {
                xMLReader = XMLUtil.createXMLReader((boolean)true);
                xMLReader.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
                this.cachedReader = new WeakReference<XMLReader>(xMLReader);
            }
            return xMLReader;
        }

        public synchronized PaletteItemNode getInstance() {
            PaletteItemNode paletteItemNode = this.refNode.get();
            if (paletteItemNode != null) {
                return paletteItemNode;
            }
            FileObject fileObject = this.xmlDataObject.getPrimaryFile();
            if (fileObject.getSize() == 0L) {
                return null;
            }
            PaletteItemHandler paletteItemHandler = new PaletteItemHandler();
            try {
                XMLReader xMLReader = this.getXMLReader();
                FileObject fileObject2 = this.xmlDataObject.getPrimaryFile();
                String string = fileObject2.getURL().toExternalForm();
                InputSource inputSource = new InputSource(fileObject2.getInputStream());
                inputSource.setSystemId(string);
                xMLReader.setContentHandler(paletteItemHandler);
                xMLReader.parse(inputSource);
            }
            catch (SAXException sAXException) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, sAXException);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, iOException);
            }
            paletteItemNode = this.createPaletteItemNode(paletteItemHandler);
            this.refNode = new WeakReference<PaletteItemNode>(paletteItemNode);
            return paletteItemNode;
        }

        private PaletteItemNode createPaletteItemNode(PaletteItemHandler paletteItemHandler) {
            String string = this.xmlDataObject.getName();
            InstanceContent instanceContent = new InstanceContent();
            String string2 = paletteItemHandler.getClassName();
            if (string2 != null) {
                instanceContent.add((Object)string2, (InstanceContent.Convertor)ActiveEditorDropProvider.getInstance());
            } else {
                string2 = paletteItemHandler.getBody();
                if (string2 != null) {
                    instanceContent.add((Object)string2, (InstanceContent.Convertor)ActiveEditorDropDefaultProvider.getInstance());
                }
            }
            return null == paletteItemHandler.getDisplayName() ? new PaletteItemNode(new DataNode((DataObject)this.xmlDataObject, Children.LEAF), string, paletteItemHandler.getBundleName(), paletteItemHandler.getDisplayNameKey(), paletteItemHandler.getClassName(), paletteItemHandler.getTooltipKey(), paletteItemHandler.getIcon16URL(), paletteItemHandler.getIcon32URL(), instanceContent) : new PaletteItemNode(new DataNode((DataObject)this.xmlDataObject, Children.LEAF), string, paletteItemHandler.getDisplayName(), paletteItemHandler.getTooltip(), paletteItemHandler.getIcon16URL(), paletteItemHandler.getIcon32URL(), instanceContent);
        }
    }
}

