/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultilineToolbarLayout
implements LayoutManager {
    int SPACER = 4;

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        List<List<Component>> component_rows = this.getComponentRows(parent);
        int height = parent.getInsets().top + parent.getInsets().bottom;
        for (List<Component> comps : component_rows) {
            height += this.getMostHeightComponent(comps);
        }
        return new Dimension(this.getMinAvailableWidth(parent), height += this.SPACER * (component_rows.size() - 1));
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    @Override
    public void layoutContainer(Container parent) {
        int currentWidth = 0;
        int currentHeight = 0;
        List<List<Component>> component_rows = this.getComponentRows(parent);
        for (List<Component> comps : component_rows) {
            for (Component c : comps) {
                c.setLocation(currentWidth, currentHeight);
                c.setSize(c.getPreferredSize());
                currentWidth += c.getWidth() + this.SPACER;
            }
            currentHeight += this.getMostHeightComponent(comps) + this.SPACER;
            currentWidth = 0;
        }
    }

    private int getMostHeightComponent(List<Component> rowComponents) {
        int max = 0;
        for (Component c : rowComponents) {
            if (c.getPreferredSize().height <= max) continue;
            max = c.getPreferredSize().height;
        }
        return max;
    }

    public int getMinAvailableWidth(Container parent) {
        int width = parent.getWidth();
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            if (width >= c.getPreferredSize().width) continue;
            width = c.getPreferredSize().width;
        }
        return width;
    }

    public List<List<Component>> getComponentRows(Container parent) {
        ArrayList<List<Component>> component_rows = new ArrayList<List<Component>>();
        int min_width = this.getMinAvailableWidth(parent);
        int current_row_index = 0;
        int current_row_width = 0;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            if (component_rows.size() == current_row_index) {
                component_rows.add(new ArrayList());
            }
            if (((List)component_rows.get(current_row_index)).size() > 0) {
                if ((current_row_width += this.SPACER) + c.getPreferredSize().width > min_width) {
                    ++current_row_index;
                    current_row_width = 0;
                    --i;
                    continue;
                }
                current_row_width += c.getPreferredSize().width;
                ((List)component_rows.get(current_row_index)).add(c);
                continue;
            }
            current_row_width += c.getPreferredSize().width;
            ((List)component_rows.get(current_row_index)).add(c);
        }
        return component_rows;
    }
}

